package com.yizhi.research.application.vo.manage;

import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yizhi.research.application.vo.MessageRemindVo;
import com.yizhi.research.application.vo.domain.TrResearchAuthorizeVo;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 保存resrarch vo
 *
 * @Author: shengchenglong
 * @Date: 2018/3/13 11:06
 */
@Data
@Api(tags = "ResearchVo", description = "后台保存调研vo（修改时未改的字段勿传值也勿传空字符串）")
public class ResearchVo {

    @ApiModelProperty(value = "调研id（仅update时可传）")
    private Long id;

    @ApiModelProperty(value = "调研名称")
    private String name;

    @ApiModelProperty(value = "调研开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date startTime;

    @ApiModelProperty(value = "调研结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date endTime;

    @ApiModelProperty(value = "可见范围，1平台用户可见（企业下所有人员） 2指定学员可见")
    private Integer visibleRange;

    @ApiModelProperty(value = "调研说明")
    private String content;

    @ApiModelProperty(value = "调研备注")
    private String remark;

    @ApiModelProperty(value="调研指定的人员(仅当visibleRange=2时可传)")
    private List<TrResearchAuthorizeVo> trResearchAuthorize;

    @ApiModelProperty(value = "提醒vo")
    private RemindVo remindVo;

    @ApiModelProperty(value = "是否有提醒")
    private Integer remind;

    @ApiModelProperty(value = "积分，默认0")
    private Integer point;

    @ApiModelProperty(value = "各个业务设置提醒时的数据")
    private MessageRemindVo messageRemindVo;

    private String keywords;

    @ApiModelProperty(value = "调研logo")
    private String image;

    @ApiModelProperty(value = "是否启用在日历任务中显示")
    private Integer enableTask;
    
    @ApiModelProperty(value = "业务类型：1调研；2投票")
    private Integer bizType;
    
    @ApiModelProperty(value = "呈现样式：1逐题呈现；2整页呈现；3整页投票单选")
    private Integer pageMode;
    
    @ApiModelProperty(value = "投票选择次数：0无限制")
    private Integer voteNum;

    @ApiModelProperty(value = "展示样式")
    private Integer styleType;

    @ApiModelProperty(value = "logoSrc")
    private String logoSrc;


}
