package com.yizhi.research.application.controller;


import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.vo.DroolsVo;
import com.yizhi.research.application.mapper.ResearchMapper;
import com.yizhi.research.application.model.CopyResearchModel;
import com.yizhi.research.application.service.IResearchService;
import com.yizhi.research.application.vo.BaseModel;
import com.yizhi.research.application.vo.CalendarTaskParamVo;
import com.yizhi.research.application.vo.api.CheckResearchStateVo;
import com.yizhi.research.application.vo.api.PageVo;
import com.yizhi.research.application.vo.api.SearchVo;
import com.yizhi.research.application.vo.domain.*;
import com.yizhi.util.application.beanutil.BeanCopyListUtil;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import java.util.*;

/**
 * <p>
 * 调研 前端控制器
 * </p>
 *
 * @author shengchenglong
 * @since 2018-03-12
 */
@RestController
@RequestMapping("/research")
public class ResearchController {

    @Autowired
    private IResearchService researchService;
    @Autowired
    private ResearchMapper researchMapper;

    /**
     * 新增调研接口
     *
     * @return
     */
    @PostMapping("/insert")
    public Research insert(@RequestBody ResearchVo research) {
        Research research1=new Research();
        BeanUtils.copyProperties(research,research1);
        List<TrResearchRemindVo> list=research.getReminds();
        List<TrResearchRemind> list1=new ArrayList<>();
        if (CollectionUtil.isNotEmpty(list)) {
            list1 = BeanCopyListUtil.copyListProperties(list, TrResearchRemind::new);
        }
        List<TrResearchAuthorizeVo> list2 = research.getAuthorizes();
        List<TrResearchAuthorize> list3 = new ArrayList<>();
        if (CollectionUtil.isNotEmpty(list2)) {
            list3 = BeanCopyListUtil.copyListProperties(list2, TrResearchAuthorize::new);
        }
        List<TrResearchQuestionVo> list4 = research.getQuestions();
        List<TrResearchQuestion> list5 = new ArrayList<>();
        if (CollectionUtil.isNotEmpty(list4)) {
            list5 = BeanCopyListUtil.copyListProperties(list4, TrResearchQuestion::new);
        }
        List<TrResearchAnswerVo> list6 = research.getTrResearchAnswerVos();
        List<TrResearchAnswer> list7 = new ArrayList();
        if (CollectionUtil.isNotEmpty(list6)) {
            list7 = BeanCopyListUtil.copyListProperties(list6, TrResearchAnswer::new);
        }
        research1.setReminds(list1);
        research1.setAuthorizes(list3);
        research1.setQuestions(list5);
        research1.setTrResearchAnswers(list7);
        return  researchService.insertResearch(research1);
    }


    /**
     * 查看调研接口
     *
     * @return
     */
    @GetMapping("/view")
    public Research viewOne(@RequestParam("id") Long id) {
        Research research = researchService.viewOne(id);
        return research;
    }

    /**
     * 分页列表
     *
     * @return
     */
    @GetMapping("/page/list")
    public Page<Research> listPage(@RequestBody BaseModel<Page<Research>> model) {
        Page<Research> page = model.getObj();
        RequestContext context = model.getContext();

        Map map = page.getCondition();
        Integer pageNo = page.getCurrent();
        Integer pageSize = page.getSize();

        return researchService.listPage(map, context, pageNo, pageSize);
    }

    @GetMapping("/page/poolExamList")
    public Page<Map<String, Object>> getPoolExamList(@RequestParam(value = "name", required = false) String name,
                                                     @RequestParam(value = "ids", required = false) List<Long> ids,
                                                     @RequestParam(value = "pageNo", required = false) Integer pageNo,
                                                     @RequestParam(value = "pageSize", required = false) Integer pageSize) {
        return researchService.getPoolExamList(name, ids, pageNo, pageSize);
    }

    /**
     * 批量删除
     *
     * @return
     */
    @PostMapping("/batch/delete")
    public int batchDelete(@RequestBody List<Long> ids) {
        return researchService.batchDelete(ids);
    }

    /**
     * 更新一个调研，包含提醒（删除以前的提醒）
     *
     * @param research
     * @return
     */
    @PostMapping("/update")
    public int update(@RequestBody ResearchVo research) {
        Research research1=new Research();
        BeanUtils.copyProperties(research,research1);
        List<TrResearchRemindVo> list=research.getReminds();
        List<TrResearchRemind> list1=new ArrayList<>();
        if (CollectionUtil.isNotEmpty(list)) {
            list1 = BeanCopyListUtil.copyListProperties(list, TrResearchRemind::new);
        }
        List<TrResearchAuthorizeVo> list2 = research.getAuthorizes();
        List<TrResearchAuthorize> list3 = new ArrayList<>();
        if (CollectionUtil.isNotEmpty(list2)) {
            list3 = BeanCopyListUtil.copyListProperties(list2, TrResearchAuthorize::new);
        }
        List<TrResearchQuestionVo> list4 = research.getQuestions();
        List<TrResearchQuestion> list5 = new ArrayList<>();
        if (CollectionUtil.isNotEmpty(list4)) {
            list5 = BeanCopyListUtil.copyListProperties(list4, TrResearchQuestion::new);
        }
        List<TrResearchAnswerVo> list6 = research.getTrResearchAnswerVos();
        List<TrResearchAnswer> list7 = new ArrayList();
        if (CollectionUtil.isNotEmpty(list6)) {
            list7 = BeanCopyListUtil.copyListProperties(list6, TrResearchAnswer::new);
        }
        research1.setReminds(list1);
        research1.setAuthorizes(list3);
        research1.setQuestions(list5);
        research1.setTrResearchAnswers(list7);
        return researchService.update(research1);
    }

    /**
     * 上架 或 下架
     *
     * @param research
     * @return
     */
    @PostMapping("/release")
    public Research upOrDown(@RequestBody ResearchVo research) throws Exception {
        Research research1=new Research();
        BeanUtils.copyProperties(research,research1);
        List<TrResearchRemindVo> list=research.getReminds();
        List<TrResearchRemind> list1=new ArrayList<>();
        if (CollectionUtil.isNotEmpty(list)) {
            list1 = BeanCopyListUtil.copyListProperties(list, TrResearchRemind::new);
        }
        List<TrResearchAuthorizeVo> list2 = research.getAuthorizes();
        List<TrResearchAuthorize> list3 = new ArrayList<>();
        if (CollectionUtil.isNotEmpty(list2)) {
            list3 = BeanCopyListUtil.copyListProperties(list2, TrResearchAuthorize::new);
        }
        List<TrResearchQuestionVo> list4 = research.getQuestions();
        List<TrResearchQuestion> list5 = new ArrayList<>();
        if (CollectionUtil.isNotEmpty(list4)) {
            list5 = BeanCopyListUtil.copyListProperties(list4, TrResearchQuestion::new);
        }
        List<TrResearchAnswerVo> list6 = research.getTrResearchAnswerVos();
        List<TrResearchAnswer> list7 = new ArrayList();
        if (CollectionUtil.isNotEmpty(list6)) {
            list7 = BeanCopyListUtil.copyListProperties(list6, TrResearchAnswer::new);
        }
        research1.setReminds(list1);
        research1.setAuthorizes(list3);
        research1.setQuestions(list5);
        research1.setTrResearchAnswers(list7);
        return researchService.upOrDown(research1);
    }

    /**
     * 复制调研
     *
     * @param model
     * @return
     */
    @PostMapping("/copy")
    public Research copyResearch(@RequestBody CopyResearchModel model) throws Exception {
        return researchService.copyResearch(model.getResearchId(), model.getRequestContext(), model.getDate());
    }

    /**
     * 学员端分页列表
     *
     * @param model
     * @return
     */
    @GetMapping("api/page/list")
    public Page<Research> apiListPage(@RequestBody BaseModel<PageVo> model) {
        return researchService.apiListPage(model);
    }

    /**
     * 学员端模糊查询分页列表
     *
     * @param searchVo
     * @return
     */
    @GetMapping("api/search/page/list")
    public Page<Research> apiSearchPage(@RequestBody SearchVo searchVo) {
        String name = searchVo.getName();
        RequestContext context = searchVo.getContext();
        int pageNo = searchVo.getPageNo();
        int pageSize = searchVo.getPageSize();
        return researchService.apiSearchPage(name, context, pageNo, pageSize);
    }

    /**
     * 我的调研进行中的个数
     *
     * @param context
     * @return
     */
    @GetMapping("/api/count")
    public Integer searchUnfinishCount(@RequestBody RequestContext context) {
        return researchService.searchUnfinishCount(context);
    }

    /**
     * 我的调研状态检查
     *
     * @param checkResearchStateVo
     * @return
     */
    @PostMapping("/state/check")
    Integer checkResearchState(@RequestBody CheckResearchStateVo checkResearchStateVo) {
        return researchService.checkResearchState
                (checkResearchStateVo.getResearchId(), checkResearchStateVo.getContext());

    }

    @PostMapping("/state/checkTPlan")
    Integer checkTPlanResearchState(@RequestBody CheckResearchStateVo checkResearchStateVo) {
        return researchService.checkTPlanResearchState
                (checkResearchStateVo.getResearchId(), checkResearchStateVo.getContext());

    }

    /**
     * 调研报表列表
     *
     * @param startDate
     * @param endDate
     * @param kwd
     * @param pageSize
     * @param pageNo
     * @param orgIds
     * @param companyId
     * @param siteId
     * @return
     */
    @GetMapping("/group")
    public Page<Research> getResearchList(@RequestParam(name = "startDate", required = false) String startDate, @RequestParam(name = "endDate", required = false) String endDate,
                                          @RequestParam(name = "kwd", required = false) String kwd, @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize,
                                          @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo, @RequestParam(name = "orgIds", required = false) List<Long> orgIds,
                                          @RequestParam(name = "companyId", required = true) Long companyId, @RequestParam(name = "siteId", required = true) Long siteId
    ) {
        return researchService.getResearchList(startDate, endDate, kwd, pageSize, pageNo, orgIds, companyId, siteId);
    }

    /**
     * 某个调研的人员完成情况
     *
     * @param researchId
     * @return
     */
    @GetMapping("/group/view")
    public Research getResearchView(@RequestParam(name = "researchId", required = true) Long researchId) {
        return researchService.getResearchView(researchId);
    }


    @GetMapping(value="/by/new/server")
    public List<Map<String, Object>> getServerByCompanyIdAndIds(@RequestParam("companyId")Long companyId,@RequestParam(value="ids",required=false)List<Long> ids){
    	return researchService.getServerByCompanyIdAndIds(companyId, ids);
    }

    /**
     * @param researchId
     * @return
     */
    @PostMapping("/delete")
    public Integer delete(@RequestBody Map map) {
        Long researchId = new Long(map.get("researchId").toString()) ;
        Research research = researchService.selectById(researchId);
        if (null == research) {
//            throw new BizException("4000", "数据不存在,无法删除!"); 如果直接抛出异常会导致fein接口404
            return -1;
        }
        if (null != research.getTrainingProjectId()) {
//            throw new BizException("4000", "已关联培训项目，无法删除!");
            return -2;
        }
        if (research.getState() == 1) {
//            throw new BizException("4000", "上架状态，无法删除!");
            return -3;
        }

        Research r = new Research();
        r.setId(researchId);
        r.setDeleted(1);
        return (researchService.updateById(r) == true ? 1 : 0);
    }

    @GetMapping ("/getAllResearch")
    public List<Research> getAllResearch() {
        return researchMapper.getAllResearchs();

    }

    @GetMapping ("/selectRecordMinTime")
    public Date selectRecordMinTime() {
        return researchMapper.selectRecordMinTime();

    }

    @GetMapping ("/getAllSiteId")
    public List<Long> getAllSiteId() {
        List<Research> lists = researchMapper.getAllResearchs();
        Set<Long> sets = new HashSet<>();
        List<Long> allSiteIds = new ArrayList<>();
        lists.forEach(a -> {
            if (a.getSiteId() != null) {
                sets.add(a.getSiteId());
            }
        });
        allSiteIds.addAll(sets);
        return allSiteIds;

    }

    @GetMapping("/getPointById")
    public Integer getPointByIds(@RequestParam(value = "ids",required = false) List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return null;
        }
        EntityWrapper wrapper = new EntityWrapper();
        wrapper.setSqlSelect("point");
        wrapper.in("id", ids);
        List<Research> list = this.researchMapper.selectList(wrapper);
        Integer pointTotal = 0;
        if (!CollectionUtils.isEmpty(list)) {
            for (Research research : list) {
                Integer point = research.getPoint();
                point = (point == null ? 0 : point);
                pointTotal = pointTotal + point;
            }
        }
        return pointTotal;
    }

    @PostMapping("/getPageToCalendar")
    public Page<Research> getPageToCalendar(@ApiParam("paramVo") @RequestBody CalendarTaskParamVo paramVo){
        Page<Research> page = new Page(paramVo.getPageNo(), paramVo.getPageSize());

        return researchService.getPageToCalendar(paramVo.getDate(),page);
    }

    @GetMapping("/getPageByDrools")
    Page<DroolsVo> getPageByDrools(@RequestParam("field") String field,
                                   @RequestParam(value = "value", required = false) String value,
                                   @RequestParam("pageNo") Integer pageNo,
                                   @RequestParam("pageSize") Integer pageSize) {
        Page<DroolsVo> page = new Page<>(pageNo, pageSize);
        return researchService.getPageByDrools(field, value, page);
    }

    /**
     * 查看一个调研信息
     *
     * @param id
     * @return
     */
    @GetMapping("/info")
    Research viewInfo(@RequestParam("id") Long id) {
    	return researchService.viewInfo(id);
    }
    
    /**
     * 获取置顶的调研信息
     * @param bizType
     * @return
     */
    @GetMapping("/top/get")
    List<ResearchVo> getResearchTop(@RequestParam(value = "bizType", required = false) Integer bizType){
    	return researchService.getResearchTop(bizType);
    }
    
    /**
     * 查看调研详情
     *
     * @param id
     * @return
     */
    @GetMapping("/details")
    ResearchVo getResearchDetails(@RequestParam("id") Long id) {
    	return researchService.getResearchDetails(id);
    }
}

