package com.yizhi.research.application.download;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.context.TaskContext;
import com.yizhi.core.application.file.constant.FileConstant;
import com.yizhi.core.application.file.task.AbstractDefaultTask;
import com.yizhi.core.application.file.util.OssUpload;
import com.yizhi.research.application.mapper.TrResearchAnswerMapper;
import com.yizhi.research.application.service.IResearchService;
import com.yizhi.research.application.service.ITrResearchAnswerService;
import com.yizhi.research.application.service.ITrResearchQuestionOptionService;
import com.yizhi.research.application.service.ITrResearchQuestionService;
import com.yizhi.research.application.util.WorkUtil;
import com.yizhi.research.application.vo.api.ViewAnswerQuestionOptionVo;
import com.yizhi.research.application.vo.api.ViewAnswerQuestionVo;
import com.yizhi.research.application.vo.api.ViewAnswerVo;
import com.yizhi.research.application.vo.domain.TrResearchAuthorize;
import com.yizhi.research.application.vo.domain.TrResearchQuestion;
import com.yizhi.research.application.vo.domain.TrResearchQuestionOption;
import com.yizhi.research.application.vo.report.DownloadParamsVoOnTime;
import com.yizhi.research.application.vo.report.ReportResearchAnalyze;
import com.yizhi.research.application.vo.report.ResearchGroupViewVo;
import com.yizhi.system.application.constant.AuthzConstant;
import com.yizhi.system.application.system.remote.AccountClient;
import com.yizhi.system.application.system.remote.ReportClient;
import com.yizhi.system.application.vo.*;
import org.apache.commons.collections.CollectionUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.File;
import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;

import static java.math.BigDecimal.ROUND_HALF_DOWN;

@Component
public class DownloadResearchAnalyze extends AbstractDefaultTask<String, DownloadParamsVoOnTime> {

    private static final Logger logger = LoggerFactory.getLogger(DownloadResearchAnalyze.class);

    SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");

    @Autowired
    private WorkUtil workUtil;
    @Autowired
    private ITrResearchQuestionService researchQuestionService;
    @Autowired
    ITrResearchQuestionOptionService iTrResearchQuestionOptionService;
    @Autowired
    private ITrResearchAnswerService researchAnswerService;
    @Autowired
    private TrResearchAnswerMapper trResearchAnswerMapper;
    @Autowired
    private ReportClient reportClient;
    @Autowired
    private IResearchService researchService;
    @Autowired
    private AccountClient accountClient;

    @Override
    protected String execute(DownloadParamsVoOnTime vo) {

        Long researchId = vo.getResearchId();
        String researchName = vo.getResesrchName();
        RequestContext context = vo.getContext();
        String taskName = vo.getTaskName();
        String serialNo = vo.getSerialNo();
        Long taskId = vo.getTaskId();
        Long siteId = context.getSiteId();

        Date submitTime = new Date();
        TaskContext taskContext = new TaskContext(taskId, serialNo, taskName, context.getAccountId(), submitTime, context.getSiteId(), context.getCompanyId());
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        working(taskContext);

        Integer pageNo = 1;
        Integer pageSize = 20;
        List<ViewAnswerVo> viewAnswerVos = new ArrayList<ViewAnswerVo>();
        List<ViewAnswerVo> viewAnswerVos1;


        //获取问题列表
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("researchId", researchId);
        List<TrResearchQuestion> trResearchQuestions = researchQuestionService.listPage(map);
        if (trResearchQuestions == null) {
            trResearchQuestions = new ArrayList<>();
        }
        //获取问题选项列表
        List<TrResearchQuestionOption> trResearchQuestionOptions = iTrResearchQuestionOptionService.listAll(researchId);
        if (trResearchQuestionOptions == null) {
            trResearchQuestionOptions = new ArrayList<>();
        }


        //获取回答记录数
        Integer total = researchAnswerService.apiViewAnswersCount(researchId);
        //获取回答记录
        viewAnswerVos1 = researchAnswerService.viewAnswerVoList(researchId, 1, Integer.MAX_VALUE);
        viewAnswerVos.addAll(viewAnswerVos1);


        List<Long> accountIds = new ArrayList<>();

//        //这里主要获取问答题需要的字段数据 name、submitTime
        List<ResearchGroupViewVo> researchGroupViewVos = trResearchAnswerMapper.queryAnswerRecord(researchId, siteId);

        if (CollectionUtils.isNotEmpty(researchGroupViewVos)) {
            for (ResearchGroupViewVo groupViewVo : researchGroupViewVos) {
                accountIds.add(groupViewVo.getAccountId());
            }
            List<AccountVO> accountVOs = accountClient.idsGet(accountIds);
            //获取 《accountId,name》Map集合
            Map<Long, String> accountMap = new HashMap<>();
            //实时取用户名
            accountVOs.forEach(accountVo -> {
                if (!accountMap.containsKey(accountVo.getId())) {
                    accountMap.put(accountVo.getId(), accountVo.getName());
                }
            });

            for (ResearchGroupViewVo groupViewVo : researchGroupViewVos) {
                groupViewVo.setAccountName(accountMap.get(groupViewVo.getAccountId()));
            }
        }


        String upLoadUrl = null;
        String requestPath = FileConstant.SAVE_PATH;
//        String requestPath = "/Users/dingxiaowei/aaa";
//        String requestPath = "E\\";
        File fileDir = new File(requestPath);
        if (!fileDir.exists()) {
            fileDir.mkdir();
        }

        XSSFWorkbook workbook = new XSSFWorkbook();
        //创建单元格格式
        XSSFCellStyle style = workbook.createCellStyle();
        style.setAlignment(HorizontalAlignment.LEFT);//创建居左格式
        Cell cell;
        String sheetName = workUtil.chechPattonPattern(researchName + "调研分析表");
        XSSFSheet sheet = workbook.createSheet(sheetName);

        //创建第一行
        XSSFRow row = sheet.createRow((int) 0);
        cell = row.createCell((short) 0);
        cell.setCellValue(researchName);

        //创建第二行
        row = sheet.createRow((int) 1);
        cell = row.createCell((short) 0);
        String deadline = format.format(submitTime);
        cell.setCellValue("统计周期:" + "截止" + deadline);


        //获取实际参加人数
        Integer realJoinNum = total;
        Integer canjoinNum = 0;
        //获取可参加人数
        canjoinNum = queryCanJoinNum(researchId, context);

        ReportResearchAnalyze reportResearchAnalyze = new ReportResearchAnalyze();
        reportResearchAnalyze.setJoinCount(canjoinNum == null ? 0 : canjoinNum);
        reportResearchAnalyze.setRealJoinCount(realJoinNum == null ? 0 : realJoinNum);
        reportResearchAnalyze.setSubmitCount(realJoinNum == null ? 0 : realJoinNum);
        reportResearchAnalyze.setQuestionCount(trResearchQuestions.size());


        //创建第三行
        row = sheet.createRow((int) 2);
        row.createCell((short) 0).setCellValue("题目总数:" + reportResearchAnalyze.getQuestionCount());
        row.createCell((short) 1).setCellValue("提交问卷份数:" + reportResearchAnalyze.getSubmitCount());
        row.createCell((short) 2).setCellValue("可参加人数:" + reportResearchAnalyze.getJoinCount());
        row.createCell((short) 3).setCellValue("实际参加人数：" + reportResearchAnalyze.getRealJoinCount());

        try {
            //获取  用户id对应的用户答题记录
            Map<Long, ResearchGroupViewVo> statisticsResearchMap = new HashMap<Long, ResearchGroupViewVo>();
            for (ResearchGroupViewVo researchGroupViewVo : researchGroupViewVos) {
                if (researchGroupViewVo == null) {
                    continue;
                }
                statisticsResearchMap.put(researchGroupViewVo.getAccountId(), researchGroupViewVo);
            }
            int index = 3;

            List<ViewAnswerQuestionVo> answerQuestions;
            List<ViewAnswerQuestionOptionVo> viewAnswerQuestionOptionVos;

            Map<Long, Integer> viewAnswerVoMap = new HashMap<Long, Integer>();
            Map<Long, List<ViewAnswerQuestionVo>> accountMap = new HashMap<Long, List<ViewAnswerQuestionVo>>();
            List<ViewAnswerQuestionVo> voList = new ArrayList<ViewAnswerQuestionVo>();
            Map<Long, Integer> viewAnswerQuestionOptionVoMap = new HashMap<Long, Integer>();
            Map<Long, ViewAnswerQuestionOptionVo> optionVoMap = new HashMap<Long, ViewAnswerQuestionOptionVo>();
            //以分数位置为key,分数为value
            Map<Integer, Integer> scoreIndexMap = new HashMap<>();
            Integer scoreTem = 10;
            Integer indexTem = 1;
            for (indexTem = 1; indexTem <= 11; indexTem++) {
                scoreIndexMap.put(indexTem,scoreTem);
                scoreTem--;
            }

            //以选项id为key value 是 以分数为key，选择的人数为value
            Map<Long, Map<Integer, Integer>> optionMap1 = new HashMap<>();


            Long questionId;
            Long accountId;
            ResearchGroupViewVo researchGroupViewVo;
            ViewAnswerQuestionOptionVo questionOptionVo;
            for (ViewAnswerVo viewAnswerVo : viewAnswerVos) {
                researchGroupViewVo = statisticsResearchMap.get(viewAnswerVo.getAccountId());
                if (researchGroupViewVo == null) {
                    continue;
                }
                answerQuestions = viewAnswerVo.getAnswerQuestions();
                if (answerQuestions == null) {
                    continue;
                }
                for (ViewAnswerQuestionVo viewAnswerQuestionVo : answerQuestions) {
                    questionId = viewAnswerQuestionVo.getId();
                    Integer validCount = 0;//表示该问题有效填写的个数
                    boolean preCheck = false;
                    if (viewAnswerQuestionVo.getType() == 3) {//问答题
                        viewAnswerQuestionVo.setAccountId(viewAnswerVo.getAccountId());
                        if (viewAnswerQuestionVo.getAnswerContent() != null) {
                            voList.add(viewAnswerQuestionVo);
                            accountMap.put(questionId, voList);
                            preCheck = true;
                        }
                    } else {
                        viewAnswerQuestionOptionVos = viewAnswerQuestionVo.getOptions();
                        for (ViewAnswerQuestionOptionVo viewAnswerQuestionOptionVo : viewAnswerQuestionOptionVos) {
                            Integer count;
                            Long optionId = viewAnswerQuestionOptionVo.getId();
                            //单选题或者多选题
                            if (viewAnswerQuestionVo.getType() == 1 || viewAnswerQuestionVo.getType() == 2) {
                                if (viewAnswerQuestionOptionVo.getAnswerChecked()) {
                                    preCheck = true;
                                    count = viewAnswerQuestionOptionVoMap.get(viewAnswerQuestionOptionVo.getId());
                                    if (count == null) {
                                        count = 1;
                                    } else {
                                        count++;
                                    }
                                    viewAnswerQuestionOptionVoMap.put(viewAnswerQuestionOptionVo.getId(), count);
                                    //viewAnswerQuestionOptionVo.setCheckedCount(checkCount);
                                }
                            } else {//打分题
                                Integer answerScore = viewAnswerQuestionOptionVo.getAnswerScore();
                                Integer totalSocre;
                                if (answerScore != null) {
                                        if (!optionMap1.containsKey(optionId)) {
                                            Map<Integer, Integer> scoreMap = new HashMap<>();
                                            scoreMap.put(answerScore, 1);
                                            optionMap1.put(optionId, scoreMap);
                                        } else {
                                            Map<Integer, Integer> scoreMap = optionMap1.get(optionId);
                                            if (!scoreMap.containsKey(answerScore)) {
                                                scoreMap.put(answerScore, 1);
                                            } else {
                                                Integer selectNum = scoreMap.get(answerScore);
                                                scoreMap.put(answerScore, (selectNum + 1));
                                            }
                                            optionMap1.put(optionId, scoreMap);
                                        }
                                    preCheck = true;
                                    questionOptionVo = optionVoMap.get(viewAnswerQuestionOptionVo.getId());
                                    if (questionOptionVo == null) {
                                        questionOptionVo = new ViewAnswerQuestionOptionVo();
                                        questionOptionVo.setAnswerScore(answerScore);
                                        questionOptionVo.setCheckCount(1);
                                        questionOptionVo.setMinScore(answerScore);
                                        questionOptionVo.setMaxScore(answerScore);
                                        questionOptionVo.setTotalSocre(answerScore);
                                        optionVoMap.put(viewAnswerQuestionOptionVo.getId(), questionOptionVo);

                                    } else {
                                        count = questionOptionVo.getCheckCount();
                                        questionOptionVo.setCheckCount(++count);
                                        if (answerScore > questionOptionVo.getMaxScore()) {
                                            questionOptionVo.setMaxScore(answerScore);
                                        }
                                        if (answerScore < questionOptionVo.getMinScore()) {
                                            questionOptionVo.setMinScore(answerScore);
                                        }
                                        totalSocre = questionOptionVo.getTotalSocre();
                                        totalSocre += answerScore;
                                        questionOptionVo.setTotalSocre(totalSocre);
                                    }
                                }
                            }
                        }
                    }
                    if (preCheck) {
                        validCount = viewAnswerVoMap.get(questionId);
                        if (validCount == null) {
                            validCount = 1;
                        } else {
                            validCount += 1;
                        }
                        viewAnswerVoMap.put(questionId, validCount);
                    }

                }

            }
            List<TrResearchQuestionOption> optionList;
            Map<Long, List<TrResearchQuestionOption>> optionMap = new HashMap<Long, List<TrResearchQuestionOption>>();
            Long questionsId;
            for (TrResearchQuestionOption trResearchQuestionOption : trResearchQuestionOptions) {
                questionsId = trResearchQuestionOption.getQuestionId();
                optionList = optionMap.get(questionsId);
                if (optionList != null) {
                    optionList.add(trResearchQuestionOption);
                } else {
                    optionList = new ArrayList<TrResearchQuestionOption>();
                    optionList.add(trResearchQuestionOption);
                }
                optionMap.put(questionsId, optionList);
            }
            //答卷的问题
            BigDecimal d;
            BigDecimal dou;
            BigDecimal b = new BigDecimal(100);
            int s = 0;


            //第四行组装数据开始

            for (TrResearchQuestion trResearchQuestion : trResearchQuestions) {
                row = sheet.createRow((int) index);
                index++;
                cell = row.createCell((short) 0);
                if (trResearchQuestion.getContent() != null && trResearchQuestion.getNo() != null && trResearchQuestion.getType() == 1) {
                    cell.setCellValue(trResearchQuestion.getNo() + "、" + "(单选题)" + trResearchQuestion.getContent());
                }
                if (trResearchQuestion.getContent() != null && trResearchQuestion.getNo() != null && trResearchQuestion.getType() == 2) {
                    cell.setCellValue(trResearchQuestion.getNo() + "、" + "(多选题)" + trResearchQuestion.getContent());
                }
                if (trResearchQuestion.getContent() != null && trResearchQuestion.getNo() != null && trResearchQuestion.getType() == 3) {
                    cell.setCellValue(trResearchQuestion.getNo() + "、" + "(问答题)" + trResearchQuestion.getContent());
                }
                if (trResearchQuestion.getContent() != null && trResearchQuestion.getNo() != null && trResearchQuestion.getType() == 4) {
                    cell.setCellValue(trResearchQuestion.getNo() + "、" + "(打分题)" + trResearchQuestion.getContent());
                }
                questionId = trResearchQuestion.getId();
                Integer valid = viewAnswerVoMap.get(questionId);
                if (valid == null) {
                    valid = 0;
                }
                //单选
                if (trResearchQuestion.getType() == 1 || trResearchQuestion.getType() == 2) {
                    row.createCell((short) 1).setCellValue("有效填写:" + valid);
                    row = sheet.createRow((int) index);
                    index++;
                    row.createCell((short) 0).setCellValue("选项");
                    row.createCell((short) 1).setCellValue("小计");
                    row.createCell((short) 2).setCellValue("比例");
                    optionList = optionMap.get(questionId);
                    Integer totalCount = 0;
                    if (optionList != null) {
                        for (TrResearchQuestionOption trResearchQuestionOption : optionList) {
                            Integer i = viewAnswerQuestionOptionVoMap.get(trResearchQuestionOption.getId());
                            if (i == null) {
                                i = 0;
                            }
                            totalCount += i;
                        }
                        for (TrResearchQuestionOption trResearchQuestionOption : optionList) {
                            Integer i = viewAnswerQuestionOptionVoMap.get(trResearchQuestionOption.getId());
                            if (i == null) {
                                i = 0;
                            }
                            row = sheet.createRow((int) index);
                            index++;
                            cell = row.createCell((short) 0);
                            if (trResearchQuestionOption.getContent() != null) {
                                cell.setCellValue(trResearchQuestionOption.getContent());
                            }
                            row.createCell((short) 1).setCellValue(i);
                            d = new BigDecimal((double) i).multiply(b);
                            dou = new BigDecimal((double) totalCount);
                            cell = row.createCell((short) 2);
                            if (d.compareTo(BigDecimal.ZERO) == 0 || dou.compareTo(BigDecimal.ZERO) == 0) {
                                cell.setCellValue("0%");
                            } else {
                                cell.setCellValue(d.divide(dou, 0, ROUND_HALF_DOWN) + "%");
                            }
                        }
                    }
                    //问答题
                } else if (trResearchQuestion.getType() == 3) {
                    voList = accountMap.get(questionId);
                    if (voList == null) {
                        continue;
                    }
                    for (ViewAnswerQuestionVo viewAnswerQuestionVo : voList) {
                        int i = 0;
                        accountId = viewAnswerQuestionVo.getAccountId();
                        researchGroupViewVo = statisticsResearchMap.get(accountId);
                        row = sheet.createRow((int) index);
                        index++;
                        cell = row.createCell((short) 0);
                        if (researchGroupViewVo.getAccountName() != null) {
                            cell.setCellValue(researchGroupViewVo.getAccountName());
                        }
                        cell = row.createCell((short) 1);
                        if (researchGroupViewVo.getFinishTime() != null) {
                            cell.setCellValue(sdf.format(researchGroupViewVo.getFinishTime()));
                        }
                        cell = row.createCell((short) 2);
                        if (viewAnswerQuestionVo.getAnswerContent() != null) {
                            cell.setCellValue(viewAnswerQuestionVo.getAnswerContent());
                        }
                    }
                } else {
                    //打分题
                    row.createCell((short) 1).setCellValue("有效填写:" + valid);
                    row = sheet.createRow((int) index);
                    index++;
                    row.createCell((short) 0).setCellValue("打分项");
                    row.createCell((short) 1).setCellValue("10");
                    row.createCell((short) 2).setCellValue("9");
                    row.createCell((short) 3).setCellValue("8");
                    row.createCell((short) 4).setCellValue("7");
                    row.createCell((short) 5).setCellValue("6");
                    row.createCell((short) 6).setCellValue("5");
                    row.createCell((short) 7).setCellValue("4");
                    row.createCell((short) 8).setCellValue("3");
                    row.createCell((short) 9).setCellValue("2");
                    row.createCell((short) 10).setCellValue("1");
                    row.createCell((short) 11).setCellValue("0");
                    row.createCell((short) 12).setCellValue("参与人数");
                    row.createCell((short) 13).setCellValue("最高分");
                    row.createCell((short) 14).setCellValue("最低分");
                    row.createCell((short) 15).setCellValue("总分");
                    row.createCell((short) 16).setCellValue("平均分");
                    if (trResearchQuestionOptions == null) {
                        continue;
                    }
                    for (TrResearchQuestionOption trResearchQuestionOption : trResearchQuestionOptions) {
                        if (trResearchQuestionOption.getQuestionId().equals(questionId)) {
                            row = sheet.createRow(index);
                            index++;
                            cell = row.createCell((short) 0);
                            if (trResearchQuestionOption.getContent() != null) {
                                cell.setCellValue(trResearchQuestionOption.getContent());
                            }
                            questionOptionVo = optionVoMap.get(trResearchQuestionOption.getId());
                            if (questionOptionVo == null) {
                                continue;
                            }
                            //给选了那个分数的单元格赋值
                            Integer i = 1;
                            Long optionId = trResearchQuestionOption.getId();
                            for (i = 1; i <= 11; i++) {
                                Map<Integer, Integer> scoreMap = optionMap1.get(optionId);
                                if (scoreMap == null) {
                                    continue;
                                }
                                Integer score = scoreIndexMap.get(i);
                                Integer selectNum = scoreMap.get(score);
                                if (selectNum != null) {
                                    cell = row.createCell(i);
                                    cell.setCellValue(selectNum);
                                }
                            }


//                            int i = questionOptionVo.getAnswerScore();

//                            for (int j = 0; j < 11; j++) {
//                                row.createCell((short) (11 - j));
//                                if (i == j) {
//                                    cell = row.getCell((short) (11 - j));
//                                    if (questionOptionVo.getCheckCount() != null) {
//                                        cell.setCellValue(questionOptionVo.getCheckCount());
//                                    }
//                                }
//                            }
                            d = new BigDecimal(questionOptionVo.getTotalSocre());
                            dou = new BigDecimal(questionOptionVo.getCheckCount());
                            cell = row.createCell((short) 12);
                            if (questionOptionVo.getCheckCount() != null) {
                                cell.setCellValue(questionOptionVo.getCheckCount());
                            }
                            cell = row.createCell((short) 13);
                            if (questionOptionVo.getMaxScore() != null) {
                                cell.setCellValue(questionOptionVo.getMaxScore());
                            }
                            cell = row.createCell((short) 14);
                            if (questionOptionVo.getMinScore() != null) {
                                cell.setCellValue(questionOptionVo.getMinScore());
                            }
                            cell = row.createCell((short) 15);
                            if (questionOptionVo.getTotalSocre() != null) {
                                cell.setCellValue(questionOptionVo.getTotalSocre());
                            }
                            cell = row.createCell((short) 16);
                            if (d.compareTo(BigDecimal.ZERO) == 0 || dou.compareTo(BigDecimal.ZERO) == 0) {
                                cell.setCellValue("0");
                            } else {
                                cell.setCellValue(d.divide(dou, 2, ROUND_HALF_DOWN) + "");
                            }

                        }
                    }
                }
                s++;
//                taskDetail(taskContext.getTaskId(), research.getName() + "导出数据第" + s + "行成功");
            }

            //导出

            StringBuffer fileNameSb = new StringBuffer().append(vo.getTaskName()).append(".xlsx");
            String fileName = fileNameSb.toString();
            String path = new StringBuffer().append(requestPath).append(fileNameSb).toString();
            FileOutputStream os = null;
            File file = null;
            try {
                os = new FileOutputStream(path);
                workbook.write(os);
                //阿里云返回url
                upLoadUrl = OssUpload.upload(path, fileName);
                file = new File(path);
                success(taskContext, "成功", upLoadUrl);
            } catch (Exception e1) {
                e1.printStackTrace();
                fail(taskContext, "写入过程中发生错误");
                logger.error("写入数据到Excel的过程中或者上传到阿里云中发生错误");
            } finally {
                if (os != null) {
                    os.close();
                }
                if (workbook != null) {
                    workbook.close();
                }
                if (file != null) {
                    file.delete();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            fail(taskContext, researchName + "导出过程中发生错误，请查看日志");
            logger.error("创建Excel的过程中发生错误");
        }
        return upLoadUrl;
    }

    private Integer queryCanJoinNum(Long researchId, RequestContext context) {


        Integer canJoinNum = 0;
        //"可见范围，1平台用户可见（企业下所有人员） 2指定学员可见"
        Integer visibRange = researchService.selectById(researchId).getVisibleRange();

        List<Long> accountIds = new ArrayList<>();
        List<Long> orgIds = new ArrayList<>();

        // 如果是调研指定范围
        if (visibRange == 2) {
            TrResearchAuthorize example = new TrResearchAuthorize();
            example.setResearchId(researchId);
            List<TrResearchAuthorize> authorizes = example.selectList(new EntityWrapper(example));
            if (CollectionUtils.isNotEmpty(authorizes)) {
                for (TrResearchAuthorize authorize : authorizes) {
                    if (authorize.getType().equals(1)) {
                        orgIds.add(authorize.getRelationId());
                    } else {
                        accountIds.add(authorize.getRelationId());
                    }
                }
                //获取调研可见范围内的用户数据
                List<ReportAccountRespVO> queryAccountList = queryConditionalAccount(context, orgIds, accountIds);
                canJoinNum = queryAccountList == null ? 0 : queryAccountList.size();
//                List<Long> accountIdList = new ArrayList<>();
//                //获取全平台或者管辖区人员数据
//                List<ReportAccountRespVO> manageAccountList = queryAccountList(context, orgIds, accountIds);
//
//                if (CollectionUtils.isNotEmpty(queryAccountList)) {
//                    if (CollectionUtils.isNotEmpty(manageAccountList)) {
//                        for (ReportAccountRespVO vo : queryAccountList) {
//                            for (ReportAccountRespVO manageVo : manageAccountList) {
//                                if (manageVo.equals(vo.getUserId())) {
//                                    accountIdList.add(vo.getUserId());
//                                }
//                            }
//                        }
//                        canJoinNum = accountIdList.size();
//                    }
//                }
            }

        } else {

            //获取全平台或者管辖区人员数据   orgids,accountIds 都是空的
            List<ReportAccountRespVO> queryAccountList = queryAccountList(context, orgIds, accountIds);
            canJoinNum = queryAccountList.size();
        }
        return canJoinNum;
    }


    //获取全平台或者管辖区人员数据
    private List<ReportAccountRespVO> queryAccountList(RequestContext context, List<Long> orgIds, List<Long> accountIds) {

        List<ReportAccountRespVO> queryAccountList = new ArrayList<>();

        if (context.isAdmin()) {
            //全平台的用户数据
            queryAccountList = queryConditionalAccount(context, new ArrayList<>(), new ArrayList<>());
        } else {
            HQAccountInManageParam hp = new HQAccountInManageParam();
            hp.setAccountId(context.getAccountId());
            hp.setSiteId(context.getSiteId());
            hp.setModuleType(AuthzConstant.moduleType.statistics_research);
            ReportAccountRespInManageVO vo = reportClient.getRangeAccountsInManage(hp);
            queryAccountList = vo.getList();
            if (CollectionUtils.isEmpty(queryAccountList)) {
                queryAccountList = new ArrayList<>();
            }
        }

        return queryAccountList;
    }

    //查询指定范围内的人
    private List<ReportAccountRespVO> queryConditionalAccount(RequestContext context, List<Long> orgIds, List<Long> accountIds) {
        ReportRangeAccountReqVO rrarv = new ReportRangeAccountReqVO();
        rrarv.setSiteId(context.getSiteId());
        rrarv.setOrgIds(orgIds);
        rrarv.setAccountIds(accountIds);
        List<ReportAccountRespVO> queryAccountList = reportClient.getRangeAccounts(rrarv);
        if (CollectionUtils.isEmpty(queryAccountList)) {
            queryAccountList = new ArrayList<>();
        }
        return queryAccountList;
    }
}

