package com.yizhi.research.application.download;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.context.TaskContext;
import com.yizhi.core.application.file.constant.FileConstant;
import com.yizhi.core.application.file.task.AbstractDefaultTask;
import com.yizhi.core.application.file.util.OssUpload;
import com.yizhi.research.application.mapper.TrResearchAnswerMapper;
import com.yizhi.research.application.service.IResearchService;
import com.yizhi.research.application.service.ITrResearchAnswerService;
import com.yizhi.research.application.service.ITrResearchQuestionService;
import com.yizhi.research.application.util.WorkUtil;
import com.yizhi.research.application.vo.api.ViewAnswerQuestionOptionVo;
import com.yizhi.research.application.vo.api.ViewAnswerQuestionVo;
import com.yizhi.research.application.vo.api.ViewAnswerVo;
import com.yizhi.research.application.vo.domain.TrResearchAuthorize;
import com.yizhi.research.application.vo.domain.TrResearchQuestion;
import com.yizhi.research.application.vo.domain.TrResearchQuestionOption;
import com.yizhi.research.application.vo.report.DownloadParamsVoOnTime;
import com.yizhi.research.application.vo.report.ResearchGroupViewVo;
import com.yizhi.system.application.constant.AuthzConstant;
import com.yizhi.system.application.system.remote.ReportClient;
import com.yizhi.system.application.vo.HQAccountInManageParam;
import com.yizhi.system.application.vo.ReportAccountRespInManageVO;
import com.yizhi.system.application.vo.ReportAccountRespVO;
import com.yizhi.system.application.vo.ReportRangeAccountReqVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.*;


@Component
public class DownloadResearchDetails extends AbstractDefaultTask<String, DownloadParamsVoOnTime> {

    private static final Logger logger = LoggerFactory.getLogger(DownloadResearchDetails.class);

    @Autowired
    private ReportClient reportClient;
    @Autowired
    private ITrResearchAnswerService researchAnswerService;
    @Autowired
    private TrResearchAnswerMapper trResearchAnswerMapper;
    @Autowired
    private ITrResearchQuestionService researchQuestionService;


    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");

    @Autowired
    private WorkUtil workUtil;
    @Autowired
    private IResearchService researchService;

    @Override
    protected String execute(DownloadParamsVoOnTime vo) {
        String upLoadUrl = null;
        String requestPath = FileConstant.SAVE_PATH;
//        String requestPath = "/Users/dingxiaowei/aaa";
//        String requestPath = "E\\";
        File fileDir = new File(requestPath);
        if (!fileDir.exists()) {
            fileDir.mkdir();
        }


        Long researchId = vo.getResearchId();
        String researchName = vo.getResesrchName();
        RequestContext context = vo.getContext();
        String taskName = vo.getTaskName();
        String serialNo = vo.getSerialNo();
        Long taskId = vo.getTaskId();

        Date submitTime = new Date();
        Long accountId = context.getAccountId();
        TaskContext taskContext = new TaskContext(taskId, serialNo, taskName, accountId, submitTime, context.getSiteId(), context.getCompanyId());
        working(taskContext);

        List<ViewAnswerVo> viewAnswerVos = new ArrayList<>();
        List<ViewAnswerVo> viewAnswerVos1;
        List<ResearchGroupViewVo> researchGroupViewVos = null;

        try {
            //获取回答记录
            viewAnswerVos1 = researchAnswerService.viewAnswerVoList(researchId, 1, Integer.MAX_VALUE);
            viewAnswerVos.addAll(viewAnswerVos1);

            //学员答卷map  《学员id，答卷记录》
            Map<Long, ResearchGroupViewVo> accountIdRecordMap = new HashMap<>();
            researchGroupViewVos = new ArrayList<>();
            List<ResearchGroupViewVo> joinAccounts = new ArrayList<>();
            List<ResearchGroupViewVo> noJoinAccounts = new ArrayList<>();


//        //这里主要获取学员回答记录
            List<ResearchGroupViewVo> answerRecords = trResearchAnswerMapper.queryAnswerRecord(researchId, context.getSiteId());
            if (CollectionUtils.isNotEmpty(answerRecords)) {
                answerRecords.forEach(a -> {
                    if (!accountIdRecordMap.containsKey(a.getAccountId())) {
                        accountIdRecordMap.put(a.getAccountId(), a);
                    }
                });
            }

            //获取要参加的人员信息
            List<ReportAccountRespVO> accountList = queryCanJoinAccount(researchId, context);
            if (CollectionUtils.isNotEmpty(accountList)) {
                for (ReportAccountRespVO account : accountList) {

                    //组装下面Excel需要的数据
                    ResearchGroupViewVo cellValue = new ResearchGroupViewVo();
                    cellValue.setAccountId(account.getUserId());
                    cellValue.setAccountName(account.getUserName());
                    cellValue.setAccountFullName(account.getUserFullName());
                    cellValue.setOrgName(account.getOrgName());
                    if (accountIdRecordMap.containsKey(account.getUserId())) {
                        ResearchGroupViewVo tem = accountIdRecordMap.get(account.getUserId());
                        cellValue.setFinishTime(tem.getFinishTime());
                        cellValue.setJoinState(1);
                        joinAccounts.add(cellValue);
                    } else {
                        cellValue.setJoinState(0);
                        noJoinAccounts.add(cellValue);
                    }
                }
                //为了保证参加啦的人顺序排在前面
                researchGroupViewVos.addAll(joinAccounts);
                researchGroupViewVos.addAll(noJoinAccounts);
            }


        } catch (Exception e) {
            e.printStackTrace();
            fail(taskContext, researchName + "获取数据过程中出现错误，请查看日志");
            logger.error("获取数据过程中出现错误");
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            //excel生成：excel-sheet-row-cell
            XSSFWorkbook workbook = new XSSFWorkbook();
            //创建单元格格式
            XSSFCellStyle style = workbook.createCellStyle();
            style.setAlignment(HorizontalAlignment.LEFT);//创建居左格式
            String sheetName = workUtil.chechPattonPattern(researchName + "_" + dateFormat.format(submitTime));
            XSSFSheet sheet = workbook.createSheet(sheetName);
            XSSFRow row;
            XSSFCell cell;

            //创建第三行列名
            row = sheet.createRow((int) 2);
            cell = row.createCell((short) 0);
            cell.setCellValue("用户名");
            cell = row.createCell((short) 1);
            cell.setCellValue("姓名");
            cell = row.createCell((short) 2);
            cell.setCellValue("所在部门");
            cell = row.createCell((short) 3);
            cell.setCellValue("是否完成");
            cell = row.createCell((short) 4);
            cell.setCellValue("提交时间");


            //确定提交时间的位置
            int cellSize = 4;
            //第一个问题的位置
            int index = 5;
            //获取问题及其选项
            if (CollectionUtils.isNotEmpty(viewAnswerVos)) {

            }
            List<TrResearchQuestion> trResearchQuestions = researchQuestionService.listAll(researchId);
            if (CollectionUtils.isEmpty(trResearchQuestions)) {
                trResearchQuestions = new ArrayList<>();
            }
            cellSize += trResearchQuestions.size();
            List<TrResearchQuestionOption> trResearchQuestionOptions;
            //储存 一个问题对应的位置，下面就可以直接通过问题id定位位置。
            Map<Long, Integer> locationMap = new HashMap<Long, Integer>();
            //储存 一个问题选项对应的位置，下面就可以直接通过问题选项id定位位置。
            Map<Long, Integer> optionLocationMap = new HashMap<Long, Integer>();
            for (TrResearchQuestion trResearchQuestion : trResearchQuestions) {
                cell = row.createCell((short) index);
                if (null != trResearchQuestion.getId()) {
                    locationMap.put(trResearchQuestion.getId(), index);
                }
                index++;
                if (trResearchQuestion.getContent() != null) {
                    cell.setCellValue(trResearchQuestion.getContent());
                }
                trResearchQuestionOptions = trResearchQuestion.getOptions();
                if (trResearchQuestionOptions == null) {
                    continue;
                }
                if (trResearchQuestion.getType() == 4) {
                    for (TrResearchQuestionOption trResearchQuestionOption : trResearchQuestionOptions) {
                        cell = row.createCell((short) index);
                        if (trResearchQuestionOption.getContent() != null) {
                            cell.setCellValue(trResearchQuestionOption.getContent());
                        }
                        if (null != trResearchQuestionOption.getId()) {
                            optionLocationMap.put(trResearchQuestionOption.getId(), index);
                        }
                        index++;
                    }
                    cellSize += trResearchQuestionOptions.size();
                }

            }
//            cell = row.createCell((short) cellSize + 1);
//            cell.setCellValue("所在部门");

            // 在sheet中添加表头第0行,注意老版本poi对Excel的行数列数有限制short,
            // 创建第1行
            row = sheet.createRow((int) 0);
            //合并单元格
            CellRangeAddress cra = new CellRangeAddress(0, 0, 0, cellSize); // 起始行, 终止行, 起始列, 终止列
            sheet.addMergedRegion(cra);
            //合并前6列当做第0行的第0列
            cell = row.createCell((short) 0);
            cell.setCellValue(researchName + "调研明细表");
            cell.setCellStyle(style);


            //创建第2行
            row = sheet.createRow((int) 1);
            CellRangeAddress cra1 = new CellRangeAddress(1, 1, 0, cellSize); // 起始行, 终止行, 起始列, 终止列
            sheet.addMergedRegion(cra1);
            cell = row.createCell((short) 0);
            String deadline = format.format(submitTime);
            cell.setCellValue("统计周期:" + "截止" + deadline);
            cell.setCellStyle(style);

            //答卷
            ViewAnswerVo viewAnswerVo;
            //答卷的问题
            ViewAnswerQuestionVo viewAnswerQuestionVo;
            //答卷下问题选项
            ViewAnswerQuestionOptionVo viewAnswerQuestionOptionVo;
            //这些实体的列表
            List<ViewAnswerQuestionVo> viewAnswerQuestionVos;
            List<ViewAnswerQuestionOptionVo> viewAnswerQuestionOptionVos;

            Map<Long, ViewAnswerVo> viewAnswerVoMap = new HashMap<Long, ViewAnswerVo>();
            String[] parentNames;
            Long questionId;
            Long optionId;
            int location;
            //把accountId和提交的答案关联
            for (ViewAnswerVo viewAnswerVo1 : viewAnswerVos) {
                viewAnswerVoMap.put(viewAnswerVo1.getAccountId(), viewAnswerVo1);
            }
            int s = 0;
            //遍历中间表
            //代表第四行 开始填写数据
            Integer i = 3;
            for (ResearchGroupViewVo groupViewVo : researchGroupViewVos) {

                row = sheet.createRow(i);
                i++;

                cell = row.createCell((short) 0);
                if (groupViewVo.getAccountName() != null) {
                    cell.setCellValue(groupViewVo.getAccountName());
                }
                cell = row.createCell((short) 1);
                if (groupViewVo.getAccountFullName() != null) {
                    cell.setCellValue(groupViewVo.getAccountFullName());
                }
                cell = row.createCell((short) 2);
                if (groupViewVo.getOrgName() != null) {
                    cell.setCellValue(groupViewVo.getOrgName());
                }
                cell = row.createCell((short) 3);
                if (groupViewVo.getJoinState() == 1) {
                    cell.setCellValue("是");
                } else {
                    cell.setCellValue("否");
                }
                cell = row.createCell((short) 4);
                if (groupViewVo.getFinishTime() != null) {
                    cell.setCellValue(format.format(groupViewVo.getFinishTime()));
                } else {
                    cell.setCellValue("--");
                }

                //用户没有参加,给所有的问题答案表格  赋值“--”
                if (groupViewVo.getJoinState().equals(0)) {
                    //所在部门前面一个cell的位置
                    Integer cellMax = cellSize;
                    for (int o = 4; o <= cellMax; o++) {
                        cell = row.createCell((short) o);
                        cell.setCellValue("--");
                    }
                } else {

                    viewAnswerVo = viewAnswerVoMap.get(groupViewVo.getAccountId());
                    viewAnswerQuestionVos = viewAnswerVo.getAnswerQuestions();
                    if (viewAnswerQuestionVos == null) {
                        viewAnswerQuestionVos = new ArrayList<>();
                        continue;
                    }

                    //如果参加了，自然会给相应cell赋值
                    //  查询考卷的问题
                    for (int j = 0; j < viewAnswerQuestionVos.size(); j++) {
                        viewAnswerQuestionVo = viewAnswerQuestionVos.get(j);
                        questionId = viewAnswerQuestionVo.getId();
                        if (null != locationMap.get(questionId)) {
                            //获取该问题对应的位置
                            location = locationMap.get(questionId);
                        } else {
                            continue;
                        }

                        Integer num = null;
                        // 对获取的答卷的问题和答案进行组装
                        for (TrResearchQuestion question : trResearchQuestions) {
                            if (question.getId().equals(viewAnswerQuestionVo.getId())) {
                                if (num == null) {

                                    num = question.getJumpNum();

                                    if (viewAnswerQuestionVo.getType() == 4) {
                                        row.createCell((short) location);
                                    }
                                    if (viewAnswerQuestionVo.getType() == 3) {
                                        cell = row.createCell(location);
                                        if (viewAnswerQuestionVo.getAnswerContent() != null) {
                                            cell.setCellValue(viewAnswerQuestionVo.getAnswerContent());
                                        }
                                    }
                                    viewAnswerQuestionOptionVos = viewAnswerQuestionVo.getOptions();
                                    if (viewAnswerQuestionOptionVos == null) {
                                        continue;
                                    }
                                    for (int k = 0; k < viewAnswerQuestionOptionVos.size(); k++) {
                                        viewAnswerQuestionOptionVo = viewAnswerQuestionOptionVos.get(k);
                                        //问题类型
                                        Integer questionType = viewAnswerQuestionVo.getType();
                                        //选项名称
                                        String optionContent = viewAnswerQuestionOptionVo.getContent();
                                        //问答题回答内容或者其他选项回答内容
                                        String answerContent = viewAnswerQuestionOptionVo.getAnswerContent();
                                        //该选项是否被选中
                                        Boolean checked = viewAnswerQuestionOptionVo.getAnswerChecked();
                                        if (questionType == 1 && checked) {
                                            cell = row.createCell((short) location);
                                            if (optionContent != null) {
                                                //如果有其他选项，则也赋值
                                                if (answerContent != null && !answerContent.trim().equals("")) {
                                                    optionContent = optionContent + "--" + answerContent;
                                                }
                                                cell.setCellValue(optionContent);
                                            }
                                            num = viewAnswerQuestionOptionVo.getJumpNum();
                                        } else if (questionType == 2 && checked) {
                                            if (row.getCell(location) != null) {
                                                cell = row.getCell(location);
                                                if (optionContent != null) {
                                                    cell.setCellValue(cell.getStringCellValue() + "、" + optionContent);
                                                }
                                            } else {
                                                cell = row.createCell(location);
                                                if (optionContent != null) {
                                                    if (answerContent != null && !answerContent.trim().equals("")) {
                                                        optionContent = optionContent + "--" + answerContent;
                                                    }
                                                    cell.setCellValue(optionContent);
                                                }
                                            }
                                        } else {
                                            optionId = viewAnswerQuestionOptionVo.getId();
                                            if (optionLocationMap.get(optionId) != null) {
                                                location = optionLocationMap.get(optionId);
                                            } else {
                                                continue;
                                            }
                                            cell = row.createCell(location);
                                            if (viewAnswerQuestionOptionVo.getAnswerScore() != null) {
                                                cell.setCellValue(viewAnswerQuestionOptionVo.getAnswerScore());
                                            }
                                        }

                                    }
                                    // 判断当前题目是不是上一题所跳的题
                                } else if (num != null && question.getNo().equals(num)) {
                                    num = question.getJumpNum();

                                    if (viewAnswerQuestionVo.getType() == 4) {
                                        row.createCell((short) location);
                                    }
                                    if (viewAnswerQuestionVo.getType() == 3) {
                                        cell = row.createCell(location);
                                        if (viewAnswerQuestionVo.getAnswerContent() != null) {
                                            cell.setCellValue(viewAnswerQuestionVo.getAnswerContent());
                                        }
                                    }
                                    viewAnswerQuestionOptionVos = viewAnswerQuestionVo.getOptions();
                                    if (viewAnswerQuestionOptionVos == null) {
                                        continue;
                                    }
                                    for (int k = 0; k < viewAnswerQuestionOptionVos.size(); k++) {
                                        viewAnswerQuestionOptionVo = viewAnswerQuestionOptionVos.get(k);
                                        //问题类型
                                        Integer questionType = viewAnswerQuestionVo.getType();
                                        //选项名称
                                        String optionContent = viewAnswerQuestionOptionVo.getContent();
                                        //问答题回答内容或者其他选项回答内容
                                        String answerContent = viewAnswerQuestionOptionVo.getAnswerContent();
                                        //该选项是否被选中
                                        Boolean checked = viewAnswerQuestionOptionVo.getAnswerChecked();
                                        if (questionType == 1 && checked) {
                                            cell = row.createCell((short) location);
                                            if (optionContent != null) {
                                                //如果有其他选项，则也赋值
                                                if (answerContent != null && !answerContent.trim().equals("")) {
                                                    optionContent = optionContent + "--" + answerContent;
                                                }
                                                cell.setCellValue(optionContent);
                                            }
                                            num = viewAnswerQuestionOptionVo.getJumpNum();
                                        } else if (questionType == 2 && checked) {
                                            if (row.getCell(location) != null) {
                                                cell = row.getCell(location);
                                                if (optionContent != null) {
                                                    cell.setCellValue(cell.getStringCellValue() + "、" + optionContent);
                                                }
                                            } else {
                                                cell = row.createCell(location);
                                                if (optionContent != null) {
                                                    if (answerContent != null && !answerContent.trim().equals("")) {
                                                        optionContent = optionContent + "--" + answerContent;
                                                    }
                                                    cell.setCellValue(optionContent);
                                                }
                                            }
                                        }  else {
                                            optionId = viewAnswerQuestionOptionVo.getId();
                                            if (optionLocationMap.get(optionId) != null) {
                                                location = optionLocationMap.get(optionId);
                                            } else {
                                                continue;
                                            }
                                            cell = row.createCell(location);
                                            if (viewAnswerQuestionOptionVo.getAnswerScore() != null) {
                                                cell.setCellValue(viewAnswerQuestionOptionVo.getAnswerScore());
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                //给部门名称赋值
//                int location1 = cellSize + 1;
//                if (groupViewVo.getOrgName() != null) {
//                    cell = row.createCell((short) location1);
//                    cell.setCellValue(groupViewVo.getOrgName());
//                } else {
//                    row.createCell((short) location1);
//                }
                s++;
//                taskDetail(taskContext.getTaskId(), research.getName() + "导出数据第" + s + "行成功");

            }
            //导出
            StringBuffer fileNameSb = new StringBuffer().append(vo.getTaskName()).append(".xlsx");
            String fileName = fileNameSb.toString();
            String path = new StringBuffer().append(requestPath).append(fileNameSb).toString();
            FileOutputStream os = null;
            File file = null;
            try {
                os = new FileOutputStream(path);
                workbook.write(os);
                //阿里云返回url
                upLoadUrl = OssUpload.upload(path, fileName);
//                file = new File(path);
                file = new File("E\\");
                success(taskContext, "成功", upLoadUrl);
            } catch (Exception e1) {
                e1.printStackTrace();
                fail(taskContext, "写入过程中发生错误");
                logger.error("写入数据到Excel的过程中或者上传到阿里云中发生错误");
            } finally {
                if (os != null) {
                    try {
                        os.close();
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (workbook != null) {
                    try {
                        workbook.close();
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (file != null) {
                    file.delete();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            fail(taskContext, researchName + "导出过程中发生错误，请查看日志");
            logger.error("创建Excel的过程中发生错误");
        }

        return upLoadUrl;
    }

    private List<ReportAccountRespVO> queryCanJoinAccount(Long researchId, RequestContext context) {

        List<ReportAccountRespVO> sanmeAccountList = new ArrayList<>();
        Integer canJoinNum = 0;
        //"可见范围，1平台用户可见（企业下所有人员） 2指定学员可见"
        Integer visibRange = researchService.selectById(researchId).getVisibleRange();

        List<Long> accountIds = new ArrayList<>();
        List<Long> orgIds = new ArrayList<>();

        // 如果是调研指定范围
        if (visibRange == 2) {
            TrResearchAuthorize example = new TrResearchAuthorize();
            example.setResearchId(researchId);
            List<TrResearchAuthorize> authorizes = example.selectList(new EntityWrapper(example));
            if (CollectionUtils.isNotEmpty(authorizes)) {
                for (TrResearchAuthorize authorize : authorizes) {
                    if (authorize.getType().equals(1)) {
                        orgIds.add(authorize.getRelationId());
                    } else {
                        accountIds.add(authorize.getRelationId());
                    }
                }
                //获取调研可见范围内的accountIds
                List<ReportAccountRespVO> queryAccountList = queryConditionalAccount(context, orgIds, accountIds);
                sanmeAccountList.addAll(queryAccountList);
//                //获取全平台或者管辖区人员数据
//                List<ReportAccountRespVO> manageAccountList = queryAccountList(context, orgIds, accountIds);
//
//                if (CollectionUtils.isNotEmpty(queryAccountList)) {
//                    if (CollectionUtils.isNotEmpty(manageAccountList)) {
//                        for (ReportAccountRespVO vo : queryAccountList) {
//                            for (ReportAccountRespVO manageVo : manageAccountList) {
//                                if (manageVo.equals(vo.getUserId())) {
//                                    sanmeAccountList.add(vo);
//                                }
//                            }
//                        }
//                    }
//                }
            }

        } else {

            //获取全平台或者管辖区人员数据   orgids,accountIds 都是空的
            sanmeAccountList = queryAccountList(context, orgIds, accountIds);

        }
        return sanmeAccountList;
    }


    //获取全平台或者管辖区人员数据
    private List<ReportAccountRespVO> queryAccountList(RequestContext context, List<Long> orgIds, List<Long> accountIds) {

        List<ReportAccountRespVO> queryAccountList = new ArrayList<>();
        if (context.isAdmin()) {
            //获取全平台的用户数据
            queryAccountList = queryConditionalAccount(context, new ArrayList<>(), new ArrayList<>());
        } else {
            HQAccountInManageParam hp = new HQAccountInManageParam();
            hp.setAccountId(context.getAccountId());
            hp.setSiteId(context.getSiteId());
            hp.setModuleType(AuthzConstant.moduleType.statistics_research);
            ReportAccountRespInManageVO vo = reportClient.getRangeAccountsInManage(hp);
            if (null != vo) {
                queryAccountList = vo.getList();
                if (CollectionUtils.isEmpty(queryAccountList)) {
                    queryAccountList = new ArrayList<>();
                }
            }
        }

        return queryAccountList;
    }

    //查询指定范围内的人
    private List<ReportAccountRespVO> queryConditionalAccount(RequestContext context, List<Long> orgIds, List<Long> accountIds) {
        ReportRangeAccountReqVO rrarv = new ReportRangeAccountReqVO();
        rrarv.setSiteId(context.getSiteId());
        rrarv.setOrgIds(orgIds);
        rrarv.setAccountIds(accountIds);
        List<ReportAccountRespVO> queryAccountList = reportClient.getRangeAccounts(rrarv);
        if (CollectionUtils.isEmpty(queryAccountList)) {
            queryAccountList = new ArrayList<>();
        }
        return queryAccountList;
    }
}
