package com.yizhi.research.application.mapper;

import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.research.application.model.DataRangeModel;
import com.yizhi.research.application.vo.domain.Research;
import com.yizhi.research.application.vo.domain.ResearchVo;
import com.yizhi.research.application.vo.domain.TrResearchAuthorize;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.session.RowBounds;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 调研 Mapper 接口
 * </p>
 *
 * @author shengchenglong
 * @since 2018-03-12
 */
public interface ResearchMapper extends BaseMapper<Research> {

    /**
     * 后台管理分页列表
     *
     * @param state
     * @param name
     * @param rowBounds
     * @return
     */
    List<Research> listPage(@Param("date") String date, @Param("state") Integer state, @Param("name") String name, @Param("bizType") Integer bizType, @Param("range") DataRangeModel dataRangeModel, RowBounds rowBounds);

    Integer listPageCount(@Param("date") String date,@Param("state") Integer state, @Param("name") String name, @Param("bizType") Integer bizType, @Param("range") DataRangeModel dataRangeModel);

    /**
     * 查询所有
     *
     * @return
     */
    int selectAllCount(@Param("siteId") Long siteId);

    /**
     * 批量删除（仅能删除草稿状态）
     *
     * @param ids
     * @return
     */
    int batchDelete(@Param("ids") List<Long> ids);

    /**
     * 学员端调研列表
     *
     * @param idsInRange    可见范围内的调研id集合
     * @param now           当前时间
     * @return
     */
    List<Research> apiListResearch(@Param("idsInRange") List<Long> idsInRange, @Param("accountId") Long accountId,
                                   @Param("siteId") Long siteId, @Param("now") Date now, @Param("state") Integer state, @Param("bizType") Integer bizType, 
                                   RowBounds rowBounds);

    /**
     * 分页模糊查询
     *
     * @param idsInRange    可见范围内的调研id集合
     * @param name
     * @param rowBounds
     * @return
     */
    List<Research> apiSearchPage(@Param("siteId") Long siteId, @Param("name") String name,@Param("accountId") Long accountId,
    		@Param("now") Date date,@Param("idsInRange") List<Long> idsInRange, RowBounds rowBounds);
    /**
     * 查询所有进行中的我的调研
     */
    Integer apiCountResearch(@Param("idsInRange") List<Long> idsInRange, @Param("accountId") Long accountId,
            @Param("siteId") Long siteId, @Param("now") Date now);
    
    int selectListCount(@Param("idsInRange") List<Long> idsInRange, @Param("accountId") Long accountId,
            @Param("siteId") Long siteId, @Param("now") Date now, @Param("state") Integer state, @Param("bizType") Integer bizType);

    LinkedList<Research> selectRealJoin(@Param("researchIds") List<Long> researchIds);

    LinkedList<TrResearchAuthorize> selectRelationIds(@Param("researchIds") List<Long> researchIds);

    List<Research> selectResearchPage(
            @Param("startDate")String startDate, @Param("endDate")String endDate,
            @Param("kwd")String kwd,@Param("orgIds")List<Long> orgIds, @Param("companyId")Long companyId,
            @Param("siteId") Long siteId,RowBounds rowBounds);


    Integer selectResearchCount(@Param("startDate")String startDate, @Param("endDate")String endDate,
                        @Param("kwd")String kwd,@Param("orgIds")List<Long> orgIds, @Param("companyId")Long companyId,
                        @Param("siteId") Long siteId);

    List<Map<String, Object>> getPoolExamList(@Param("name") String name, @Param("ids") List<Long> ids,
                                              @Param("companyId") Long companyId,@Param("siteId") Long siteId,
                                              @Param("orgIds") List<Long> orgIds, Page<Map<String, Object>> page);

    @Select("select * from research where id = #{id} and deleted =0 ")
    Research selectStateOne(@Param("id") Long id);

    List<Research> getAllResearchs();

    Date selectRecordMinTime();

    List<Long> getIdsByDate(@Param("date") Date date,@Param("siteId") Long siteId);

    List<Research> getPageToCalendar(@Param("finishTrIds") List<Long> finishTrIds, @Param("trIds") List<Long> trIds, @Param("date") Date date, @Param("siteId") Long siteId, Page<Research> page);

    Integer getPageToCalendarNum(@Param("finishTrIds") List<Long> finishTrIds, @Param("trIds") List<Long> trIds, @Param("date") Date date, @Param("siteId") Long siteId);

    /**
     * 获取置顶的调研信息
     * @param bizType
     * @return
     */
	List<ResearchVo> getResearchTop(@Param("bizType") Integer bizType, @Param("siteId") Long siteId);
	
	/**
	 * 查看调研详情
	 * @param id
	 * @param siteId
	 * @param accountId
	 * @return
	 */
	ResearchVo selectResearchDetails(@Param("id") Long id, @Param("accountId") Long accountId, @Param("siteId") Long siteId);

    int checkTPlanResearchState(@Param("idsInRange") List<Long> idsInRange, @Param("id") Long id,
                                @Param("siteId") Long siteId);
}
