package com.yizhi.research.application.mapper;

import java.util.Date;
import java.util.List;
import java.util.Map;

import com.yizhi.research.application.vo.domain.Research;
import com.yizhi.research.application.vo.domain.StatisticsResearch;
import com.yizhi.research.application.vo.domain.StatisticsResearchLearn;
import com.yizhi.research.application.vo.domain.TrResearchAnswer;
import org.apache.ibatis.annotations.MapKey;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.session.RowBounds;

import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.baomidou.mybatisplus.plugins.Page;

public interface StatisticsResearchMapper extends BaseMapper<StatisticsResearch> {
    /**
     * 报表得到所有的指定范围人员
     *
     * @return
     */
    List<Long> getAllRelationId(@Param("researchId") Long researchId);

    List<TrResearchAnswer> selectRealJoin(@Param("researchId") Long researchId, @Param("accountIds") List<Long> accountIds,
										  @Param("startDate") String startDate);

    List<StatisticsResearch> selectResearchView(
                                                      @Param("researchId") Long researchId,
                                                      @Param("startDate") String startDate,
                                                      @Param("endDate") String endDate,
                                                      @Param("orgNameorOrgCode") String orgNameorOrgCode,
                                                      @Param("accountName") String accountName,
                                                      @Param("joinState") Integer joinState,
                                                      Page<StatisticsResearch> page);
    Integer selectResearchViewCount(@Param("researchId") Long researchId,
                                    @Param("startDate") String startDate,
                                    @Param("endDate") String endDate,
                                    @Param("orgNameorOrgCode") String orgNameorOrgCode,
                                    @Param("accountName") String accountName,
                                    @Param("joinState") Integer joinState);

	StatisticsResearch selectJoinCount(@Param("researchId") Long researchId,
									@Param("startDate") String startDate,
									@Param("endDate") String endDate,
									@Param("orgNameorOrgCode") String orgNameorOrgCode,
									@Param("accountName") String accountName,
									@Param("joinState") Integer joinState);

    List<StatisticsResearch> selectStatisticsResearchPage(@Param("startDate") String startDate,
                                                      @Param("endDate") String endDate,
                                                      @Param("kwd") String kwd,
                                                      @Param("companyId") Long companyId,
                                                      @Param("orgIds")List<Long> orgIds,
                                                      @Param("siteId") Long siteId,
                                                      RowBounds rowBounds);

    Integer selectStatisticsResearchCount(@Param("startDate") String startDate,
                                          @Param("endDate") String endDate,
                                          @Param("kwd") String kwd,
                                          @Param("companyId") Long companyId,
                                          @Param("orgIds") List<Long>  orgIds,
                                          @Param("siteId") Long siteId);

    List<StatisticsResearch> selectResearchViewList(@Param("researchId") Long researchId,
                                                @Param("orgNameorOrgCode") String orgNameorOrgCode,
                                                @Param("accountName") String accountName,
                                                @Param("joinState") Integer joinState,
                                                    @Param("startDate")String startDate,
                                                    @Param("endDate")String endDate);

	Date selectMaxDate();

	Date selectRecordMinTime();

	List<Research> getAllResearchs(@Param("startDate") String startDate, @Param("endDate") String endDate);

	void deleteRecordeByDate(@Param("currentDate") String currentDate);

	/**
	 * 批量插入调研
	 * @param researchId 调研ID
	 * @param currentDate 调研日期
	 * @return 
	 */
	int insertAccountLearn(@Param("researchId")Long researchId, @Param("currentDate")String currentDate);
	
	/**
	 * 获取添加的调研信息
	 * @param researchId 调研ID
	 * @param currentDate 调研日期
	 * @return 返回调研的学生ID集合
	 */
	@MapKey("account_id")
	List<StatisticsResearchLearn> selectAccountLearn(@Param("researchId")Long researchId, @Param("currentDate")String currentDate);

	List<Long> selectAccountLearnList(@Param("paramMap") Map<String, Object> paramMap, Page<Long> page);

	/**
	 * 查找学员有没有调研
	 * @param courseId
	 * @param accountId
	 * @return
	 */
	Integer selectEmptyCourseAccountLearnCount(@Param("researchId") Long researchId, @Param("accountId") Long accountId);
	
	/**
	 * 删除没有学习记录的学员信息
	 */
	void deleteEmptyAccountLearn();

	/**
	 * 查找该调研有没有人参加了
	 * @param researchId
	 * @return
	 */
	Integer selectEmptyCourseLearnCount(@Param("researchId")Long researchId);
	
	/**
	 * 查找学员有没有学了该调研
	 * @param researchId
	 * @param accountId
	 * @return
	 */
	@MapKey("accountId")
	Map<Long, Long> selectAccountLearnByResearchId(@Param("researchId") Long researchId);
	
	/**
	 * 按部门纬度统计数据量会很大,影响效率.对其进行拆分，按部门统计从此表中查询
	 */
	void insertStatisticsResearchToGroupFind();
	
	void deleteStatisticsResearchToGroupFind();
	
	/**
	 * 调研信息直接从statistics_research_metadata表中查询效率很慢，对其进行拆分.按调研和用户统计的查询条件从此获取
	 */
	void insertStatisticsResearchToAccountGroupFind();
	
	void deleteStatisticsResearchToAccountGroupFind();
}
