package com.yizhi.research.application.mapper;
import java.util.Date;
import java.util.List;

import com.yizhi.research.application.vo.StatisticResearchMetadataVo;
import com.yizhi.research.application.vo.domain.TrResearchAnswer;
import com.yizhi.research.application.vo.report.ResearchGroupViewVo;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Param;

import com.baomidou.mybatisplus.mapper.BaseMapper;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

/**
 * <p>
 * 答卷 Mapper 接口
 * </p>
 *
 * @author shengchenglong
 * @since 2018-03-12
 */
public interface TrResearchAnswerMapper extends BaseMapper<TrResearchAnswer> {
	/**
     * 检查某个学员的某个调研的状态
     */
    Integer checkResearchAnswer
    (@Param("visibleRange") Integer visibleRange, @Param("accountId") Long accountId,@Param("researchId") Long researchId, @Param("relationIds") List<Long> relationsId,@Param("date") Date date);

    Integer checkResearchAnswerState
    (@Param("visibleRange") Integer visibleRange,@Param("accountId") Long accountId, @Param("researchId") Long researchId, @Param("relationIds") List<Long> relationsId,@Param("date") Date date);
    /*
    * 根据调研id查询完成的个数
    * */
    Integer selectFinishCount(@Param("researchId") Long researchId);

    @Update("update tr_research_answer set finish = 2 where research_id = #{researchId} and account_id = #{accountId}")
    void deleteAnswer(@Param("researchId") Long researchId,@Param("accountId")Long accountId);

    /**
     * 根据调研answer的创建时间、调研id、已完成状态查询，
     * @param researchId
     * @param currentDate
     * @return
     */
    List<StatisticResearchMetadataVo> selectLearnRecord(@Param("researchId") Long researchId, @Param("startDate") String startDate, @Param("endDate") String endDate);


    /**
     * 实时查询答卷
     *
     * @param researchId

     * @return
     */
    List<ResearchGroupViewVo> queryAnswerRecord(@Param("researchId") Long researchId, @Param("siteId")Long siteId);

    List<Long> getFinshIdsByIds(@Param("ids")List<Long> ids, @Param("accountId")Long accountId,@Param("siteId") Long siteId);
    
    Integer getResearchAnsweFinish(@Param("accountId")Long accountId,@Param("researchId") Long researchId);
}
