package com.yizhi.research.application.service;

import java.util.List;
import java.util.Map;

import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.IService;
import com.yizhi.research.application.vo.domain.StatisticsResearch;
import com.yizhi.research.application.vo.domain.StatisticsResearchLearn;

public interface StatisticsResearchService extends IService<StatisticsResearch> {

    Page<StatisticsResearch> researchGroup(String startDate, String endDate, String kwd, Integer pageSize, Integer pageNo,
                                           Long companyId, List<Long> orgIds, Long siteId);

    Page<StatisticsResearch> selectResearchView(Long researchId,String startDate, String endDate, String orgNameorOrgCode, String accountName, Integer joinState,
                                                Integer pageNo,Integer pageSize);

	Integer selectResearchViewCount(Long researchId,String startDate, String endDate, String orgNameorOrgCode, String accountName, Integer joinState);

	StatisticsResearch selectJoinCount(Long researchId,String startDate, String endDate, String orgNameorOrgCode, String accountName, Integer joinState
									   );

	List<StatisticsResearch> researchViews(
			Long researchId,String startDate, String endDate, String orgNameorOrgCode, String accountName, Integer joinState,
			Integer pageNo,Integer pageSize
	);
    List<StatisticsResearch> researchViewList(Long researchId, String orgNameorOrgCode, String accountName, Integer joinState,String startDate,String endDate);
	
	/**
	 * 查询统计调研信息，分页查询 
	 * @param paramMap
	 * @param pageNo
	 * @param pageSize
	 * @return
	 */
	Page<Long> selectAccountLearnList(Map<String, Object> paramMap, int pageNo, int pageSize);	
	
	/**
	 * 批量插入学习记录
	 * @param researchId 调研ID
	 * @param curDate 调研日期
	 * @return 返回调研的学生ID集合
	 */
	List<StatisticsResearchLearn> insertAccountLearn(Long researchId, String curDate);

    }
