package com.yizhi.research.application.service.impl;

import java.util.List;
import java.util.Map;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.research.application.mapper.StatisticsResearchMapper;
import com.yizhi.research.application.service.StatisticsResearchService;
import com.yizhi.research.application.vo.domain.StatisticsResearch;
import com.yizhi.research.application.vo.domain.StatisticsResearchLearn;
import org.apache.ibatis.session.RowBounds;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baomidou.mybatisplus.plugins.Page;

@Service
@Transactional
public class StatisticsResearchServiceImpl extends ServiceImpl<StatisticsResearchMapper, StatisticsResearch> implements StatisticsResearchService {

    @Autowired
    private StatisticsResearchMapper statisticsResearchMapper;

    @Override
    public Page<StatisticsResearch> researchGroup(String startDate, String endDate, String kwd, Integer pageSize, Integer pageNo, Long companyId, List<Long> orgIds, Long siteId) {
        Page<StatisticsResearch> page=new Page<>(pageNo,pageSize);
        if(kwd == null || kwd .equals("")){
            kwd = null;
        }
        List<StatisticsResearch> statisticsResearches=statisticsResearchMapper.selectStatisticsResearchPage(startDate,endDate,kwd,companyId,orgIds,siteId,new RowBounds(page.getOffset(),page.getLimit()));
        page.setRecords(statisticsResearches);
        Integer count=statisticsResearchMapper.selectStatisticsResearchCount(startDate,endDate,kwd,companyId,orgIds,siteId);
        for(int i = 0 ; i < statisticsResearches.size(); i ++){
            if(statisticsResearches.get(i) != null ) {
                statisticsResearches.get(i).setIndex((pageNo - 1) * pageSize + i + 1);
            }
        }
        page.setTotal(count);
        return page;
    }

    public Page<StatisticsResearch> selectResearchView(Long researchId,String startDate, String endDate, String orgNameorOrgCode, String accountName, Integer joinState,
                                                Integer pageNo,Integer pageSize){
        Page<StatisticsResearch> page=new Page<>(pageNo,pageSize);
        if(accountName == null || accountName.equals("")){
            accountName = null;
        }
        if(orgNameorOrgCode == null ||orgNameorOrgCode.equals("")){
            orgNameorOrgCode = null;
        }
        List<StatisticsResearch> statisticsResearches=statisticsResearchMapper.selectResearchView(researchId,startDate,endDate,
        		orgNameorOrgCode,accountName,joinState, page);

        /*Integer count=statisticsResearchMapper.selectResearchViewCount(researchId,startDate,endDate,orgNameorOrgCode,accountName,joinState);
        page.setTotal(count);*/
        page.setRecords(statisticsResearches);
        return page;
    }
    public Integer selectResearchViewCount(Long researchId,String startDate, String endDate, String orgNameorOrgCode, String accountName, Integer joinState){
        if(accountName == null || accountName.equals("")){
            accountName = null;
        }
        if(orgNameorOrgCode == null ||orgNameorOrgCode.equals("")){
            orgNameorOrgCode = null;
        }
        return statisticsResearchMapper.selectResearchViewCount(researchId,startDate,endDate,orgNameorOrgCode,accountName,joinState);
    }
    public StatisticsResearch selectJoinCount(Long researchId,String startDate, String endDate, String orgNameorOrgCode, String accountName, Integer joinState
    ){
        if(accountName == null || accountName.equals("")){
            accountName = null;
        }
        if(orgNameorOrgCode == null ||orgNameorOrgCode.equals("")){
            orgNameorOrgCode = null;
        }
        return statisticsResearchMapper.selectJoinCount(researchId,startDate,endDate,orgNameorOrgCode,accountName,joinState);
    }
    public List<StatisticsResearch> researchViews(
            Long researchId,String startDate, String endDate, String orgNameorOrgCode, String accountName, Integer joinState,
            Integer pageSize,Integer pageNo
    ){
        if(accountName == null || accountName.equals("")){
            accountName = null;
        }
        if(orgNameorOrgCode == null ||orgNameorOrgCode.equals("")){
            orgNameorOrgCode = null;
        }
        Page<StatisticsResearch> page=new Page<>(pageNo,pageSize);
        return statisticsResearchMapper.selectResearchView(researchId,startDate,endDate,orgNameorOrgCode,accountName,joinState, page);
    }
    public List<StatisticsResearch> researchViewList(Long researchId, String orgNameorOrgCode, String accountName, Integer joinState,String startDate,String endDate ){
        if(accountName == null || accountName.equals("")){
            accountName = null;
        }
        if(orgNameorOrgCode == null ||orgNameorOrgCode.equals("")){
            orgNameorOrgCode = null;
        }
        return statisticsResearchMapper.selectResearchViewList(researchId,orgNameorOrgCode,accountName,joinState,startDate,endDate);
    }

	@Override
	public List<StatisticsResearchLearn> insertAccountLearn(Long researchId, String curDate) {
		int count = statisticsResearchMapper.insertAccountLearn(researchId, curDate);
		if(count == 0){
			return null;
		}
		
		return statisticsResearchMapper.selectAccountLearn(researchId, curDate);
	}

	@Override
	public Page<Long> selectAccountLearnList(Map<String, Object> paramMap, int pageNo, int pageSize) {
		Page<Long> page = new Page<Long>(pageNo, pageSize);
		List<Long> ids = statisticsResearchMapper.selectAccountLearnList(paramMap, page);
		page.setRecords(ids);
		return page;
	}


}
