package com.yizhi.research.application.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.event.EventWrapper;
import com.yizhi.core.application.publish.CloudEventPublisher;
import com.yizhi.core.application.task.AbstractTaskHandler;
import com.yizhi.core.application.task.TaskExecutor;
import com.yizhi.research.application.eum.QuestionType;
import com.yizhi.research.application.model.AnswerModel;
import com.yizhi.research.application.service.ITrResearchAnswerService;
import com.yizhi.research.application.service.ITrResearchQuestionService;
import com.yizhi.research.application.mapper.*;
import com.yizhi.research.application.vo.api.*;
import com.yizhi.research.application.vo.domain.*;
import com.yizhi.util.application.constant.QueueConstant;
import com.yizhi.util.application.constant.TpActivityType;
import com.yizhi.util.application.event.TrainingProjectEvent;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.*;

/**
 * <p>
 * 答卷 服务实现类
 * </p>
 *
 * @author shengchenglong
 * @since 2018-03-12
 */
@Service
@Transactional
public class TrResearchAnswerServiceImpl extends ServiceImpl<TrResearchAnswerMapper, TrResearchAnswer> implements ITrResearchAnswerService {

    private static final Logger LOGGER = LoggerFactory.getLogger(TrResearchAnswerServiceImpl.class);

    @Autowired
    private IdGenerator idGenerator;
    @Autowired
    private TrResearchQuestionMapper researchQuestionMapper;
    @Autowired
    private TrResearchAnswerMapper researchAnswerMapper;
    @Autowired
    private TrResearchAnswerQuestionMapper researchAnswerQuestionMapper;
    @Autowired
    private TrResearchAnswerQuestionResultMapper researchQuestionResultMapper;
    @Autowired
    private TrResearchQuestionOptionMapper researchQuestionOptionMapper;
    @Autowired
    private ITrResearchQuestionService trResearchQuestionService;

    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private CloudEventPublisher cloudEventPublisher;

    @Override
    public int submitAnswer(AnswerModel answerModel) throws Exception {

        RequestContext context = answerModel.getContext();
        Long accountId = context.getAccountId();
        Long companyId = context.getCompanyId();
        Long orgId = context.getOrgId() == null ? Long.valueOf(0L) : context.getOrgId();
        Long siteId = context.getSiteId() == null ? Long.valueOf(0L) : context.getSiteId();
        String accountName = context.getAccountName();
        Date now = answerModel.getDate();


        int num;
        // 答案vo
        AnswerVo answerVo = answerModel.getAnswerVo();
        TrResearchAnswer answer = buildAnswer(answerVo, accountId, companyId, accountName, siteId, orgId, now);
        //查询该调研所有的问题
        TrResearchQuestion question = new TrResearchQuestion();
        question.setResearchId(answerVo.getResearchId());
        question.setDeleted(0);
        List<TrResearchQuestion> questions = researchQuestionMapper.selectList(new EntityWrapper<TrResearchQuestion>(question));
        Map<Long, TrResearchQuestion> questionMap = new HashMap<Long, TrResearchQuestion>();
        if (!CollectionUtils.isEmpty(questions)) {
            for (TrResearchQuestion q : questions) {
                if (questionMap.get(q.getId()) == null) {
                    questionMap.put(q.getId(), q);
                }
            }
        }
        //查询该调研下所有问题的其他选项
        TrResearchQuestionOption option = new TrResearchQuestionOption();
        option.setResearchId(answerVo.getResearchId());
        option.setIsOther(1);
        option.setDeleted(0);
        option.setRequired(1);
        List<TrResearchQuestionOption> options = researchQuestionOptionMapper.selectList(new EntityWrapper<TrResearchQuestionOption>(option));
        Map<Long, TrResearchQuestionOption> optionMap = new HashMap<Long, TrResearchQuestionOption>();
        for (TrResearchQuestionOption o : options) {
            if (optionMap.get(o.getId()) == null) {
                optionMap.put(o.getId(), o);
            }
        }

        // 答案问题vo
        List<AnswerQuestionVo> questionVos = answerVo.getQuestions();
        // 答案选项，答案内容，答案打分等
        List<TrResearchAnswerQuestionResult> questionResults = new ArrayList<>();
        List<TrResearchAnswerQuestion> answerQuestions = buildAnswerQuestion(questionVos, answer, accountId, accountName, now, questionResults);
        Map<Long, List<TrResearchAnswerQuestionResult>> questionItemMap = new HashMap<Long, List<TrResearchAnswerQuestionResult>>();
        List<TrResearchAnswerQuestionResult> questionResultList;
        for (TrResearchAnswerQuestionResult result : questionResults) {
            questionResultList = questionItemMap.get(result.getAnswerQuestionId());
            if (questionResultList == null) {
                questionResultList = new ArrayList<TrResearchAnswerQuestionResult>();
                questionResultList.add(result);
            } else {
                questionResultList.add(result);
            }
            questionItemMap.put(result.getAnswerQuestionId(), questionResultList);
        }
        TrResearchQuestion q;
        TrResearchQuestionOption o;
        for (TrResearchAnswerQuestion answerQuestion : answerQuestions) {
            questionResultList = questionItemMap.get(answerQuestion.getId());
//            //是否超过五个字的检查
//            if (!CollectionUtils.isEmpty(questionResultList)) {
//                for (TrResearchAnswerQuestionResult result : questionResultList) {
//                    if (result != null && result.getContent() != null && result.getContent(),size() <=5 ) {
//                        return -3;
//                    }
//                }
//            }

            //必答题的检查
            int flag = 1;//需要回答
            q = questionMap.get(answerQuestion.getQuestionId());

            int need = q.getNeedAnswer();


            if (need == 1) {
                if (CollectionUtils.isEmpty(questionResultList)) {
                    return -2;
                } else {
                    for (TrResearchAnswerQuestionResult result : questionResultList) {
                        if (result.getOptionId() != null || (result.getContent() != null && result.getContent() != "") || result.getScore() != null) {
                            flag = 0;
                        }
                    }
                    if (flag == 1) {
                        return -2;
                    }
                }
            }

            if (!CollectionUtils.isEmpty(questionResultList)) {
                for (TrResearchAnswerQuestionResult result : questionResultList) {
                    flag = 1;
                    o = optionMap.get(result.getOptionId());
                    if (o == null || (o != null && result.getContent() != null && result.getContent() != "")) {
                        flag = 0;
                    }
                }
                if (flag == 1) {
                    return -2;
                }
            }

        }

        //根据调研以及accountId查询是否提交过
        TrResearchAnswer reAnswer = new TrResearchAnswer();
        reAnswer.setAccountId(accountId);
        reAnswer.setResearchId(answerVo.getResearchId());
        reAnswer.setFinish(1);
        EntityWrapper<TrResearchAnswer> wrapper = new EntityWrapper<TrResearchAnswer>(reAnswer);
        int size = researchAnswerMapper.selectList(wrapper).size();
        if (size > 0) {
            num = -111;
        } else {
            reAnswer.setFinish(0);
            wrapper = new EntityWrapper<>(reAnswer);
            int s = researchAnswerMapper.selectList(wrapper).size();
            if (s > 0) {
                researchAnswerMapper.delete(wrapper);
            }
            num = researchAnswerMapper.insert(answer);
            researchAnswerQuestionMapper.batchInsert(answerQuestions);
            if (!CollectionUtils.isEmpty(questionResults)) {
                researchQuestionResultMapper.batchInsert(questionResults);
            }
        }


        // 向培训项目发送消息，告知业务已经完成
        EventWrapper<TrainingProjectEvent> eventWrapper = new EventWrapper<TrainingProjectEvent>(answer.getResearchId(), TrainingProjectEvent.getInstance(answer.getResearchId(), TpActivityType.TYPE_RESEARCH, accountId, now, context.getSiteId()));
        LOGGER.info("向培训项目发送消息，告知业务已经完成:{}", eventWrapper);
        taskExecutor.asynExecute(new AbstractTaskHandler() {
            @Override
            public void handle() {
                try {
                    cloudEventPublisher.publish(QueueConstant.TRAINING_PROJECT_EVENT_QUEUE, eventWrapper);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });

        return num;

    }

    /**
     * 学员查看已完成的调研内容
     */
    @Override
    public ViewAnswerVo apiViewAnswer(Long researchId, Long accountId) {
        // 查出答案主体
        List<TrResearchAnswer> answers = new LinkedList<TrResearchAnswer>();
        TrResearchAnswer answer = new TrResearchAnswer();
        answer.setResearchId(researchId);
        answer.setAccountId(accountId);
        answer.setFinish(1);
        EntityWrapper<TrResearchAnswer> wrapper = new EntityWrapper<TrResearchAnswer>(answer);
        answers = researchAnswerMapper.selectList(wrapper);
        if (answers.size() > 0) {
            answer = answers.get(0);
            // 组装答案主体vo	
            ViewAnswerVo answerVo = new ViewAnswerVo();
            answerVo.setAccountId(answer.getAccountId());
            answerVo.setId(answer.getId());
            answerVo.setDuration(answer.getDuration());
            answerVo.setName(answer.getName());
            answerVo.setStartTime(answer.getStartTime());
            answerVo.setSubmitTime(answer.getSubmitTime());
            answerVo.setTerminalType(answer.getTerminalType());
            answerVo.setAnswerQuestions(new ArrayList<>());

            // 查出根据这个researchId查询到的问题
            TrResearchQuestion question = new TrResearchQuestion();
            question.setDeleted(0);
            question.setResearchId(researchId);
            EntityWrapper<TrResearchQuestion> questionEW = new EntityWrapper<>(question);
            questionEW.orderBy("no", true);
            List<TrResearchQuestion> questions = researchQuestionMapper.selectList(questionEW);


            // 查出根据答卷id查到的问题
            TrResearchAnswerQuestion answerQuestion = new TrResearchAnswerQuestion();
            answerQuestion.setResearchId(researchId);
            answerQuestion.setAnswerId(answer.getId());
            answerQuestion.setAccountId(accountId);
            EntityWrapper<TrResearchAnswerQuestion> answerQuestionEW = new EntityWrapper<TrResearchAnswerQuestion>(answerQuestion);
            List<TrResearchAnswerQuestion> answerQuestions = researchAnswerQuestionMapper.selectList(answerQuestionEW);


            // 查出关联问题选项等
            TrResearchQuestionOption questionOption = new TrResearchQuestionOption();
            questionOption.setResearchId(researchId);
            questionOption.setDeleted(0);
            EntityWrapper<TrResearchQuestionOption> optionEW = new EntityWrapper<>(questionOption);
            List<TrResearchQuestionOption> questionOptions = researchQuestionOptionMapper.selectList(optionEW);

            // 查出学员的答案选项
            TrResearchAnswerQuestionResult questionResult = new TrResearchAnswerQuestionResult();
            questionResult.setAnswerId(answer.getId());
            List<TrResearchAnswerQuestionResult> questionResults = researchQuestionResultMapper.selectList(new EntityWrapper<TrResearchAnswerQuestionResult>(questionResult));


            // 如果 问题主体集合不为空 and 回答问题不为空 and 学员回答记录不为空
            if (!CollectionUtils.isEmpty(questions) && !CollectionUtils.isEmpty(answerQuestions) && !CollectionUtils.isEmpty(questionResults)) {
                // 以问题id为key，问题答案为value的map
                Map<Long, List<TrResearchQuestionOption>> questionOptionMap = new HashMap<>();
                //questionOptions:关联的问题选项调研id查询出来的)
                for (TrResearchQuestionOption option : questionOptions) {
                    //当map中没有这个题目时，将该题目关联的选项全部添加进这个map
                    if (questionOptionMap.get(option.getQuestionId()) == null) {
                        List<TrResearchQuestionOption> list = new ArrayList<>();
                        list.add(option);
                        questionOptionMap.put(option.getQuestionId(), list);
                    } else {
                        questionOptionMap.get(option.getQuestionId()).add(option);
                    }
                }
                // 以问题id为key，问题答案为value的map(answerId查出来的)
                Map<Long, List<TrResearchAnswerQuestionResult>> answerResultMap = new HashMap<>();
                for (TrResearchAnswerQuestionResult result : questionResults) {
                    if (answerResultMap.get(result.getAnswerQuestionId()) == null) {
                        List<TrResearchAnswerQuestionResult> list = new ArrayList<>();
                        list.add(result);
                        answerResultMap.put(result.getAnswerQuestionId(), list);
                    } else {
                        answerResultMap.get(result.getAnswerQuestionId()).add(result);
                    }
                }
                List<TrResearchQuestionOption> optionList = null;
                List<TrResearchAnswerQuestionResult> resultList = null;
                TrResearchAnswerQuestion raq = null;
                List<TrResearchQuestion> questionToReMove = new ArrayList<>(50);
                //questions：根据researchId 查到的所有问题
                for (TrResearchQuestion q : questions) {
                    /*questionToReMove.addAll(removeByQuestion(questions,q));*/
                    ViewAnswerQuestionVo questionVo = new ViewAnswerQuestionVo();
                    questionVo.setContent(q.getContent());
                    questionVo.setContentAppendixUrl(q.getContentAppendixUrl());
                    questionVo.setId(q.getId());
                    questionVo.setMaxSelectItem(q.getMaxSelectItem());
                    questionVo.setMinSelectItem(q.getMinSelectItem());
                    questionVo.setNeedAnswer(q.getNeedAnswer());
                    questionVo.setNo(q.getNo());
                    questionVo.setType(q.getType());
                    questionVo.setOptions(new ArrayList<>());
                    //answerQuestions 是这个人这个调研的所有问题
                    // 拿到关联的答案问题
                    for (TrResearchAnswerQuestion aq : answerQuestions) {
                        raq = null;
                        if (questionVo.getId().equals(aq.getQuestionId())) {
                            //判断根据调研id和answerId查询出来的问题是同一个问题，从而可以比较学员选中的答案。
                            raq = aq;
                            break;
                        }
                    }
                    // 判定学员是否回答了这个
                    if (null != raq) {
                        // 拿取问题下的选项
                        optionList = questionOptionMap.get(q.getId());
                        if (!CollectionUtils.isEmpty(optionList)) {
                            // 处理 选择题
                            //1.如果是单选题或者是多选题，学员选项TrResearchAnswerQuestionResult中有OptionId记录正确的选项id
                            if (q.getType().equals(QuestionType.SINGLE_OPTION_QUESTION.getValue())
                                    || q.getType().equals(QuestionType.MULTIPLE_OPTION_QUESTION.getValue())) {
                                //遍历循环根据researchId查询出来的选项
                                for (TrResearchQuestionOption o : optionList) {
                                    ViewAnswerQuestionOptionVo optionVo = new ViewAnswerQuestionOptionVo();
                                    optionVo.setIsOther(o.getIsOther());
                                    optionVo.setContent(o.getContent());
                                    optionVo.setEditable(o.getEditable());
                                    optionVo.setCorrect(o.getCorrect());
                                    optionVo.setId(o.getId());
                                    optionVo.setJumpNum(o.getJumpNum());
                                    optionVo.setNo(o.getNo());
                                    //获得学员回答该题目的选项
                                    resultList = answerResultMap.get(raq.getId());
                                    if (!CollectionUtils.isEmpty(resultList)) {
                                        //遍历这些选项
                                        for (TrResearchAnswerQuestionResult r : resultList) {
                                            if (null != r.getOptionId()) {
                                                optionVo.setAnswerChecked(r.getOptionId().equals(optionVo.getId()));
                                                optionVo.setAnswerContent(r.getContent());
                                                if (optionVo.getAnswerChecked()) {
                                                    //questionToReMove.addAll(removeByQuestion(questions,optionVo.getJumpNum()));
                                                    break;
                                                }
                                            }
                                        }
                                    }

                                    questionVo.getOptions().add(optionVo);
                                }
                            }
                            // 处理 打分题
                            if (q.getType().equals(QuestionType.POINT_QUESTION.getValue())) {
                                for (TrResearchQuestionOption o : optionList) {
                                    //循环调研的选项
                                    ViewAnswerQuestionOptionVo optionVo = new ViewAnswerQuestionOptionVo();
                                    optionVo.setContent(o.getContent());
                                    optionVo.setId(o.getId());
                                    optionVo.setNo(o.getNo());
                                    optionVo.setMaxScore(o.getMaxScore());
                                    optionVo.setMinScore(o.getMinScore());
                                    // 获取分数
                                    resultList = answerResultMap.get(raq.getId());
                                    if (!CollectionUtils.isEmpty(resultList)) {
                                        for (TrResearchAnswerQuestionResult r : resultList) {
                                            if (optionVo.getId().equals(r.getOptionId())) {
                                                optionVo.setAnswerScore(r.getScore());
                                                break;
                                            }
                                        }
                                    }
                                    questionVo.getOptions().add(optionVo);
                                }
                            }
                        }
                        // 处理 问答题
                        if (q.getType().equals(QuestionType.ASK_ANSWER_QUESTION.getValue())) {
                            resultList = answerResultMap.get(raq.getId());
                            if (!CollectionUtils.isEmpty(resultList)) {
                                questionVo.setAnswerContent(resultList.get(0).getContent());
                            }
                        }
                        answerVo.getAnswerQuestions().add(questionVo);
                    }
                }
                List<ViewAnswerQuestionVo> questionVos = answerVo.getAnswerQuestions();
                List<ViewAnswerQuestionVo> questionVoList = new ArrayList<>(50);
                if (!CollectionUtils.isEmpty(questionVos)) {
                    for (ViewAnswerQuestionVo vo : questionVos) {
                        for (TrResearchQuestion q : questionToReMove) {
                            if (q.getId().equals(vo.getId())) {
                                questionVoList.add(vo);
                            }
                        }
                    }
                }
                questionVos.removeAll(questionVoList);
                answerVo.setAnswerQuestions(questionVos);
            }
            return answerVo;
        }

        return null;
    }

    public Page<ViewAnswerVo> apiViewAnswers(Long researchId, Integer pageNo, Integer pageSize) {
        Page<TrResearchAnswer> page = new Page<TrResearchAnswer>(pageNo, pageSize);
        // 查出答案主体
        RowBounds rowBounds = new RowBounds(page.getOffset(), page.getLimit());
        TrResearchAnswer answer = new TrResearchAnswer();
        answer.setResearchId(researchId);
        answer.setFinish(1);
        EntityWrapper<TrResearchAnswer> wrapper = new EntityWrapper<TrResearchAnswer>(answer);
        List<TrResearchAnswer> answers = researchAnswerMapper.selectPage(rowBounds, wrapper);
        int total = researchAnswerMapper.selectFinishCount(researchId);
        List<ViewAnswerVo> viewAnswerVos = new ArrayList<ViewAnswerVo>();
        ViewAnswerVo answerVo;
        for (TrResearchAnswer trResearchAnswer : answers) {
            // 组装答案主体vo
            answerVo = new ViewAnswerVo();
            answerVo.setAccountId(trResearchAnswer.getAccountId());
            answerVo.setId(trResearchAnswer.getId());
            answerVo.setDuration(trResearchAnswer.getDuration());
            answerVo.setName(trResearchAnswer.getName());
            answerVo.setStartTime(trResearchAnswer.getStartTime());
            answerVo.setSubmitTime(trResearchAnswer.getSubmitTime());
            answerVo.setTerminalType(trResearchAnswer.getTerminalType());
            answerVo.setAnswerQuestions(new ArrayList<>());

            // 查出根据这个researchId查询到的问题
            TrResearchQuestion question = new TrResearchQuestion();
            question.setDeleted(0);
            question.setResearchId(researchId);
            EntityWrapper<TrResearchQuestion> questionEW = new EntityWrapper<>(question);
            questionEW.orderBy("no", true);
            List<TrResearchQuestion> questions = researchQuestionMapper.selectList(questionEW);


            // 查出根据答卷id查到的问题
            TrResearchAnswerQuestion answerQuestion = new TrResearchAnswerQuestion();
            answerQuestion.setResearchId(researchId);
            answerQuestion.setAnswerId(answer.getId());
            answerQuestion.setAccountId(trResearchAnswer.getAccountId());
            EntityWrapper<TrResearchAnswerQuestion> answerQuestionEW = new EntityWrapper<TrResearchAnswerQuestion>(answerQuestion);
            List<TrResearchAnswerQuestion> answerQuestions = researchAnswerQuestionMapper.selectList(answerQuestionEW);


            // 查出关联问题选项等
            TrResearchQuestionOption questionOption = new TrResearchQuestionOption();
            questionOption.setResearchId(researchId);
            questionOption.setDeleted(0);
            EntityWrapper<TrResearchQuestionOption> optionEW = new EntityWrapper<>(questionOption);
            optionEW.orderBy("no", true);
            List<TrResearchQuestionOption> questionOptions = researchQuestionOptionMapper.selectList(optionEW);

            // 查出学员的答案选项
            TrResearchAnswerQuestionResult questionResult = new TrResearchAnswerQuestionResult();
            questionResult.setAnswerId(answer.getId());
            List<TrResearchAnswerQuestionResult> questionResults = researchQuestionResultMapper.selectList(new EntityWrapper<TrResearchAnswerQuestionResult>(questionResult));


            // 如果 问题主体集合不为空 and 回答问题不为空 and 学员回答记录不为空
            if (!CollectionUtils.isEmpty(questions) && !CollectionUtils.isEmpty(answerQuestions) && !CollectionUtils.isEmpty(questionResults)) {
                   /*for(TrResearchQuestion q : questions){
                       getNo(q);
                   }*/
                // 以问题id为key，问题答案为value的map
                Map<Long, List<TrResearchQuestionOption>> questionOptionMap = new HashMap<>();
                //questionOptions:关联的问题选项(调研id查询出来的)
                for (TrResearchQuestionOption option : questionOptions) {
                    //当map中没有这个题目时，将该题目关联的选项全部添加进这个map
                    if (questionOptionMap.get(option.getQuestionId()) == null) {
                        List<TrResearchQuestionOption> list = new ArrayList<>();
                        list.add(option);
                        questionOptionMap.put(option.getQuestionId(), list);
                    } else {
                        questionOptionMap.get(option.getQuestionId()).add(option);
                    }
                }

                // 以问题id为key，问题答案为value的map(answerId查出来的)
                Map<Long, List<TrResearchAnswerQuestionResult>> answerResultMap = new HashMap<>();
                for (TrResearchAnswerQuestionResult result : questionResults) {
                    if (answerResultMap.get(result.getAnswerQuestionId()) == null) {
                        List<TrResearchAnswerQuestionResult> list = new ArrayList<>();
                        list.add(result);
                        answerResultMap.put(result.getAnswerQuestionId(), list);
                    } else {
                        answerResultMap.get(result.getAnswerQuestionId()).add(result);
                    }
                }
                List<TrResearchQuestionOption> optionList = null;
                List<TrResearchAnswerQuestionResult> resultList = null;
                TrResearchAnswerQuestion raq = null;
                List<TrResearchQuestion> questionToReMove = new ArrayList<>(50);
                //questions：根据researchId 查到的所有问题
                for (TrResearchQuestion q : questions) {
                    /*questionToReMove.addAll(removeByQuestion(questions,q));*/
                    ViewAnswerQuestionVo questionVo = new ViewAnswerQuestionVo();
                    questionVo.setContent(q.getContent());
                    questionVo.setContentAppendixUrl(q.getContentAppendixUrl());
                    questionVo.setId(q.getId());
                    questionVo.setMaxSelectItem(q.getMaxSelectItem());
                    questionVo.setMinSelectItem(q.getMinSelectItem());
                    questionVo.setNeedAnswer(q.getNeedAnswer());
                    questionVo.setNo(q.getNo());
                    questionVo.setType(q.getType());
                    questionVo.setOptions(new ArrayList<>());
                    //answerQuestions 是这个人这个调研的所有问题
                    // 拿到关联的答案问题
                    for (TrResearchAnswerQuestion aq : answerQuestions) {
                        raq = null;
                        if (questionVo.getId().equals(aq.getQuestionId())) {
                            //判断根据调研id和answerId查询出来的问题是同一个问题，从而可以比较学员选中的答案。
                            raq = aq;
                            break;
                        }
                    }
                    // 判定学员是否回答了这个
                    if (null != raq) {
                        // 拿取问题下的选项
                        optionList = questionOptionMap.get(q.getId());
                        if (!CollectionUtils.isEmpty(optionList)) {
                            // 处理 选择题
                            //1.如果是单选题或者是多选题，学员选项TrResearchAnswerQuestionResult中有OptionId记录正确的选项id
                            if (q.getType().equals(QuestionType.SINGLE_OPTION_QUESTION.getValue())
                                    || q.getType().equals(QuestionType.MULTIPLE_OPTION_QUESTION.getValue())) {
                                //遍历循环根据researchId查询出来的选项
                                for (TrResearchQuestionOption o : optionList) {
                                    ViewAnswerQuestionOptionVo optionVo = new ViewAnswerQuestionOptionVo();
                                    optionVo.setContent(o.getContent());
                                    optionVo.setCorrect(o.getCorrect());
                                    optionVo.setId(o.getId());
                                    optionVo.setJumpNum(o.getJumpNum());
                                    optionVo.setNo(o.getNo());
                                    //获得学员回答该题目的选项
                                    resultList = answerResultMap.get(raq.getId());
                                    if (!CollectionUtils.isEmpty(resultList)) {
                                        //遍历这些选项
                                        for (TrResearchAnswerQuestionResult r : resultList) {
                                            if (null != r.getOptionId()) {
                                                optionVo.setAnswerChecked(r.getOptionId().equals(optionVo.getId()));
                                                optionVo.setAnswerContent(r.getContent());
                                                if (optionVo.getAnswerChecked()) {
                                                    //questionToReMove.addAll(removeByQuestion(questions,optionVo.getJumpNum()));
                                                    break;
                                                }
                                            }
                                        }
                                    }

                                    questionVo.getOptions().add(optionVo);
                                }
                            }
                            // 处理 打分题
                            if (q.getType().equals(QuestionType.POINT_QUESTION.getValue())) {
                                for (TrResearchQuestionOption o : optionList) {
                                    //循环调研的选项
                                    ViewAnswerQuestionOptionVo optionVo = new ViewAnswerQuestionOptionVo();
                                    optionVo.setContent(o.getContent());
                                    optionVo.setId(o.getId());
                                    optionVo.setNo(o.getNo());
                                    optionVo.setMaxScore(o.getMaxScore());
                                    optionVo.setMinScore(o.getMinScore());
                                    // 获取分数
                                    resultList = answerResultMap.get(raq.getId());
                                    if (!CollectionUtils.isEmpty(resultList)) {
                                        for (TrResearchAnswerQuestionResult r : resultList) {
                                            if (optionVo.getId().equals(r.getOptionId())) {
                                                optionVo.setAnswerScore(r.getScore());
                                                break;
                                            }
                                        }
                                    }
                                    questionVo.getOptions().add(optionVo);
                                }
                            }
                        }
                        // 处理 问答题
                        if (q.getType().equals(QuestionType.ASK_ANSWER_QUESTION.getValue())) {
                            resultList = answerResultMap.get(raq.getId());
                            if (!CollectionUtils.isEmpty(resultList)) {
                                questionVo.setAnswerContent(resultList.get(0).getContent());
                            }
                        }
                        answerVo.getAnswerQuestions().add(questionVo);
                    }
                }
                List<ViewAnswerQuestionVo> questionVos = answerVo.getAnswerQuestions();
                List<ViewAnswerQuestionVo> questionVoList = new ArrayList<>(50);
                if (!CollectionUtils.isEmpty(questionVos)) {
                    for (ViewAnswerQuestionVo vo : questionVos) {
                        for (TrResearchQuestion q : questionToReMove) {
                            if (q.getId().equals(vo.getId())) {
                                questionVoList.add(vo);
                            }
                        }
                    }
                }
                questionVos.removeAll(questionVoList);
                answerVo.setAnswerQuestions(questionVos);
            }
            viewAnswerVos.add(answerVo);
        }
        Page<ViewAnswerVo> viewAnswerVoPage = new Page<>(pageNo, pageSize);
        viewAnswerVoPage.setRecords(viewAnswerVos);
        viewAnswerVoPage.setTotal(total);
        return viewAnswerVoPage;
    }

    public Integer apiViewAnswersCount(Long researchId) {
        return researchAnswerMapper.selectFinishCount(researchId);
    }

    public List<ViewAnswerVo> viewAnswerVoList(Long researchId, Integer pageNo, Integer pageSize) {
        Page<TrResearchAnswer> page = new Page<TrResearchAnswer>(pageNo, pageSize);

        // 查出所有用户的答卷主体集合
        RowBounds rowBounds = new RowBounds(page.getOffset(), page.getLimit());
        TrResearchAnswer answer = new TrResearchAnswer();
        answer.setResearchId(researchId);
        answer.setFinish(1);
        EntityWrapper<TrResearchAnswer> wrapper = new EntityWrapper<TrResearchAnswer>(answer);
        List<String> stringList = new ArrayList<>();
        stringList.add("submit_time");
        stringList.add("id");
        wrapper.orderDesc(stringList);
        List<TrResearchAnswer> answers = researchAnswerMapper.selectPage(rowBounds, wrapper);
        if (CollectionUtils.isEmpty(answers)) {
            return new ArrayList<>();
        }

        // 根据researchId查询该调研所有问题集合
        TrResearchQuestion question = new TrResearchQuestion();
        question.setDeleted(0);
        question.setResearchId(researchId);
        EntityWrapper<TrResearchQuestion> questionEW = new EntityWrapper<>(question);
        questionEW.orderBy("no", true);
        List<TrResearchQuestion> questions = researchQuestionMapper.selectList(questionEW);


        // 根据researchId查询该调研所有问题选项集合
        TrResearchQuestionOption questionOption = new TrResearchQuestionOption();
        questionOption.setResearchId(researchId);
        questionOption.setDeleted(0);
        EntityWrapper<TrResearchQuestionOption> optionEW = new EntityWrapper<>(questionOption);
        optionEW.orderBy("no", true);
        List<TrResearchQuestionOption> questionOptions = researchQuestionOptionMapper.selectList(optionEW);


        // 以问题id为key，问题选项为value的map
        Map<Long, List<TrResearchQuestionOption>> questionOptionMap = new HashMap<>();
        for (TrResearchQuestionOption option : questionOptions) {
            if (questionOptionMap.get(option.getQuestionId()) == null) {
                List<TrResearchQuestionOption> list = new ArrayList<>();
                list.add(option);
                questionOptionMap.put(option.getQuestionId(), list);
            } else {
                questionOptionMap.get(option.getQuestionId()).add(option);
            }
        }


        //开始组装数据
        List<ViewAnswerVo> viewAnswerVos = new ArrayList<ViewAnswerVo>();
        ViewAnswerVo answerVo = null;
        for (TrResearchAnswer trResearchAnswer : answers) {


            // 根据调研id、用户id，查出答卷与问题关联关系的集合
            TrResearchAnswerQuestion answerQuestion = new TrResearchAnswerQuestion();
            answerQuestion.setResearchId(researchId);
            answerQuestion.setAnswerId(trResearchAnswer.getId());
            answerQuestion.setAccountId(trResearchAnswer.getAccountId());
            EntityWrapper<TrResearchAnswerQuestion> answerQuestionEW = new EntityWrapper<TrResearchAnswerQuestion>(answerQuestion);
            List<TrResearchAnswerQuestion> answerQuestions = researchAnswerQuestionMapper.selectList(answerQuestionEW);

            // 根据答卷id，查出该学员的问题答案集合
            TrResearchAnswerQuestionResult questionResult = new TrResearchAnswerQuestionResult();
            questionResult.setAnswerId(trResearchAnswer.getId());
            List<TrResearchAnswerQuestionResult> questionResults = researchQuestionResultMapper.selectList(new EntityWrapper<TrResearchAnswerQuestionResult>(questionResult));
            Map<Long, List<TrResearchAnswerQuestionResult>> answerResultMap = new HashMap<>();

            // 以问题答卷关联id为key，问题答案为value的 map
            if (!CollectionUtils.isEmpty(questionResults)) {
                for (TrResearchAnswerQuestionResult result : questionResults) {
                    if (answerResultMap.get(result.getAnswerQuestionId()) == null) {
                        List<TrResearchAnswerQuestionResult> list = new ArrayList<>();
                        list.add(result);
                        answerResultMap.put(result.getAnswerQuestionId(), list);
                    } else {
                        answerResultMap.get(result.getAnswerQuestionId()).add(result);
                    }
                }
            }

            // 组装答案主体vo
            answerVo = fillAnswerVo(answerVo, trResearchAnswer);

            // 如果 问题主体集合不为空 and 回答问题不为空 and 学员回答记录不为空
            if (!CollectionUtils.isEmpty(questions) && !CollectionUtils.isEmpty(answerQuestions)) {

                //遍历所有问题
                for (TrResearchQuestion q : questions) {
                    ViewAnswerQuestionVo questionVo = null;

                    //在answerVo里面组装问题questionVo
                    //q:  问题
                    //answerQuestions  :  该调研该用户的答卷与问题关联关系的集合
                    //questionOptionMap:  以问题id为key，问题选项为value的map
                    //answerResultMap  ： 以问题答卷关联id为key，问题答案为value的 map

                    answerVo = fillQuestionVo(answerVo, questionVo, q, answerQuestions, questionOptionMap, answerResultMap);
                }
            }
            viewAnswerVos.add(answerVo);
        }
        return viewAnswerVos;
    }

    private ViewAnswerVo fillAnswerVo(ViewAnswerVo answerVo, TrResearchAnswer trResearchAnswer) {

        answerVo = new ViewAnswerVo();
        answerVo.setAccountId(trResearchAnswer.getAccountId());
        answerVo.setId(trResearchAnswer.getId());
        answerVo.setDuration(trResearchAnswer.getDuration());
        answerVo.setName(trResearchAnswer.getName());
        answerVo.setStartTime(trResearchAnswer.getStartTime());
        answerVo.setSubmitTime(trResearchAnswer.getSubmitTime());
        answerVo.setTerminalType(trResearchAnswer.getTerminalType());
        answerVo.setAnswerQuestions(new ArrayList<>());


        return answerVo;
    }

    /**
     *
     //
     * @param answerVo         在answerVo里面组装问题questionVo
     * @param questionVo
     * @param q                 问题
     * @param answerQuestions 该调研该用户的答卷与问题关联关系的集合
     * @param questionOptionMap 以问题id为key，问题选项为value的map
     * @param answerResultMap  以问题答卷关联id为key，问题答案为value的 map
     * @return
     */
    private ViewAnswerVo fillQuestionVo(ViewAnswerVo answerVo, ViewAnswerQuestionVo questionVo, TrResearchQuestion q, List<TrResearchAnswerQuestion> answerQuestions,
                                        Map<Long, List<TrResearchQuestionOption>> questionOptionMap, Map<Long, List<TrResearchAnswerQuestionResult>> answerResultMap) {

        TrResearchAnswerQuestion raq = null;

        questionVo = new ViewAnswerQuestionVo();
        questionVo.setContent(q.getContent());
        questionVo.setContentAppendixUrl(q.getContentAppendixUrl());
        questionVo.setId(q.getId());
        questionVo.setMaxSelectItem(q.getMaxSelectItem());
        questionVo.setMinSelectItem(q.getMinSelectItem());
        questionVo.setNeedAnswer(q.getNeedAnswer());
        questionVo.setNo(q.getNo());
        questionVo.setType(q.getType());
        questionVo.setOptions(new ArrayList<>());

        //answerQuestions 是这个人这个调研的所有答卷问题关联记录集合
        for (TrResearchAnswerQuestion aq : answerQuestions) {
            raq = null;
            if (q.getId().equals(aq.getQuestionId())) {
                //通过比较答卷记录的问题id与调研问题id是否相等，判断该用户是否回答了该道题
                raq = aq;
                break;
            }
        }

        // 判定学员是否回答了这个
        if (null != raq) {
            // 拿取问题下的选项
            List<TrResearchQuestionOption> optionList = questionOptionMap.get(q.getId());

            if (!CollectionUtils.isEmpty(optionList)) {
                //在questionVo 里面组装optionVo
                questionVo = fillOptionVo(questionVo, raq, q, optionList, questionOptionMap, answerResultMap);
            } else {
                // 处理 问答题
                if (q.getType().equals(QuestionType.ASK_ANSWER_QUESTION.getValue())) {

                    List<TrResearchAnswerQuestionResult> resultList = answerResultMap.get(raq.getId());
                    if (!CollectionUtils.isEmpty(resultList)) {
                        questionVo.setAnswerContent(resultList.get(0).getContent());
                    }
                }
            }
        }
        answerVo.getAnswerQuestions().add(questionVo);

        return answerVo;
    }

    /**
     *
     * @param questionVo
     * @param raq  答卷问题关联记录
     * @param q   问题
     * @param optionList 选项列表
     * @param questionOptionMap 以问题id为key，问题选项为value的map
     * @param answerResultMap  以问题答卷关联id为key，问题答案为value的 map
     * @return
     */
    private ViewAnswerQuestionVo fillOptionVo(ViewAnswerQuestionVo questionVo, TrResearchAnswerQuestion raq, TrResearchQuestion q,
                                              List<TrResearchQuestionOption> optionList, Map<Long, List<TrResearchQuestionOption>> questionOptionMap,
                                              Map<Long, List<TrResearchAnswerQuestionResult>> answerResultMap) {
        // 处理 选择题
        //1.如果是单选题或者是多选题，学员选项TrResearchAnswerQuestionResult中有OptionId记录正确的选项id
        if (q.getType().equals(QuestionType.SINGLE_OPTION_QUESTION.getValue())
                || q.getType().equals(QuestionType.MULTIPLE_OPTION_QUESTION.getValue())) {

            //遍历循环根据researchId查询出来的选项
            for (TrResearchQuestionOption o : optionList) {
                ViewAnswerQuestionOptionVo optionVo = new ViewAnswerQuestionOptionVo();
                optionVo.setContent(o.getContent());
                optionVo.setCorrect(o.getCorrect());
                optionVo.setId(o.getId());
                optionVo.setJumpNum(o.getJumpNum());
                optionVo.setNo(o.getNo());
                //获得该问题该用户的答案
                List<TrResearchAnswerQuestionResult> resultList = answerResultMap.get(raq.getId());
                if (!CollectionUtils.isEmpty(resultList)) {
                    //遍历这些选项
                    for (TrResearchAnswerQuestionResult r : resultList) {
                        if (null != r.getOptionId()) {
                            optionVo.setAnswerChecked(r.getOptionId().equals(optionVo.getId()));
                            optionVo.setAnswerContent(r.getContent());
                            if (optionVo.getAnswerChecked()) {
                                break;
                            }
                        }
                    }
                }
                questionVo.getOptions().add(optionVo);
            }
        }
        // 处理 打分题
        if (q.getType().equals(QuestionType.POINT_QUESTION.getValue())) {
            for (TrResearchQuestionOption o : optionList) {
                //循环调研的选项
                ViewAnswerQuestionOptionVo optionVo = new ViewAnswerQuestionOptionVo();
                optionVo.setContent(o.getContent());
                optionVo.setId(o.getId());
                optionVo.setNo(o.getNo());
                optionVo.setMaxScore(o.getMaxScore());
                optionVo.setMinScore(o.getMinScore());
                // 获取分数
                List<TrResearchAnswerQuestionResult> resultList = answerResultMap.get(raq.getId());
                if (!CollectionUtils.isEmpty(resultList)) {
                    for (TrResearchAnswerQuestionResult r : resultList) {
                        if (optionVo.getId().equals(r.getOptionId())) {
                            optionVo.setAnswerScore(r.getScore());
                            break;
                        }
                    }
                }
                questionVo.getOptions().add(optionVo);
            }
        }
        return questionVo;
    }

    @Override
    public List<ViewAnswerVo> viewList(Long researchId) {
        TrResearchAnswer answer = new TrResearchAnswer();
        answer.setResearchId(researchId);
        answer.setFinish(1);
        EntityWrapper<TrResearchAnswer> wrapper = new EntityWrapper<TrResearchAnswer>(answer);
        List<TrResearchAnswer> answers = researchAnswerMapper.selectList(wrapper);
        List<ViewAnswerVo> viewAnswerVos = new ArrayList<ViewAnswerVo>();
        ViewAnswerVo answerVo;
        for (TrResearchAnswer trResearchAnswer : answers) {
            // 组装答案主体vo
            answerVo = new ViewAnswerVo();
            answerVo.setAccountId(trResearchAnswer.getAccountId());
            answerVo.setId(trResearchAnswer.getId());
            answerVo.setDuration(trResearchAnswer.getDuration());
            answerVo.setName(trResearchAnswer.getName());
            answerVo.setStartTime(trResearchAnswer.getStartTime());
            answerVo.setSubmitTime(trResearchAnswer.getSubmitTime());
            answerVo.setTerminalType(trResearchAnswer.getTerminalType());
            answerVo.setAnswerQuestions(new ArrayList<>());

            // 查出根据这个researchId查询到的问题
            TrResearchQuestion question = new TrResearchQuestion();
            question.setDeleted(0);
            question.setResearchId(researchId);
            EntityWrapper<TrResearchQuestion> questionEW = new EntityWrapper<>(question);
            questionEW.orderBy("no", true);
            List<TrResearchQuestion> questions = researchQuestionMapper.selectList(questionEW);


            // 查出根据答卷id查到的问题
            TrResearchAnswerQuestion answerQuestion = new TrResearchAnswerQuestion();
            answerQuestion.setResearchId(researchId);
            answerQuestion.setAnswerId(answer.getId());
            answerQuestion.setAccountId(trResearchAnswer.getAccountId());
            EntityWrapper<TrResearchAnswerQuestion> answerQuestionEW = new EntityWrapper<TrResearchAnswerQuestion>(answerQuestion);
            List<TrResearchAnswerQuestion> answerQuestions = researchAnswerQuestionMapper.selectList(answerQuestionEW);


            // 查出关联问题选项等
            TrResearchQuestionOption questionOption = new TrResearchQuestionOption();
            questionOption.setResearchId(researchId);
            questionOption.setDeleted(0);
            EntityWrapper<TrResearchQuestionOption> optionEW = new EntityWrapper<>(questionOption);
            optionEW.orderBy("no", true);
            List<TrResearchQuestionOption> questionOptions = researchQuestionOptionMapper.selectList(optionEW);

            // 查出学员的答案选项
            TrResearchAnswerQuestionResult questionResult = new TrResearchAnswerQuestionResult();
            questionResult.setAnswerId(answer.getId());
            List<TrResearchAnswerQuestionResult> questionResults = researchQuestionResultMapper.selectList(new EntityWrapper<TrResearchAnswerQuestionResult>(questionResult));


            // 如果 问题主体集合不为空 and 回答问题不为空 and 学员回答记录不为空
            if (!CollectionUtils.isEmpty(questions) && !CollectionUtils.isEmpty(answerQuestions) && !CollectionUtils.isEmpty(questionResults)) {
               /* for(TrResearchQuestion q : questions){
                    getNo(q);
                }*/
                // 以问题id为key，问题答案为value的map
                Map<Long, List<TrResearchQuestionOption>> questionOptionMap = new HashMap<>();
                //questionOptions:关联的问题选项(调研id查询出来的)
                for (TrResearchQuestionOption option : questionOptions) {
                    //当map中没有这个题目时，将该题目关联的选项全部添加进这个map
                    if (questionOptionMap.get(option.getQuestionId()) == null) {
                        List<TrResearchQuestionOption> list = new ArrayList<>();
                        list.add(option);
                        questionOptionMap.put(option.getQuestionId(), list);
                    } else {
                        questionOptionMap.get(option.getQuestionId()).add(option);
                    }
                }

                // 以问题id为key，问题答案为value的map(answerId查出来的)
                Map<Long, List<TrResearchAnswerQuestionResult>> answerResultMap = new HashMap<>();
                for (TrResearchAnswerQuestionResult result : questionResults) {
                    if (answerResultMap.get(result.getAnswerQuestionId()) == null) {
                        List<TrResearchAnswerQuestionResult> list = new ArrayList<>();
                        list.add(result);
                        answerResultMap.put(result.getAnswerQuestionId(), list);
                    } else {
                        answerResultMap.get(result.getAnswerQuestionId()).add(result);
                    }
                }
                List<TrResearchQuestionOption> optionList = null;
                List<TrResearchAnswerQuestionResult> resultList = null;
                TrResearchAnswerQuestion raq = null;
                //questions：根据researchId 查到的所有问题
                List<TrResearchQuestion> questionToReMove = new ArrayList<>(50);
                for (TrResearchQuestion q : questions) {
                    /*questionToReMove.addAll(removeByQuestion(questions,q));*/
                    ViewAnswerQuestionVo questionVo = new ViewAnswerQuestionVo();
                    questionVo.setContent(q.getContent());
                    questionVo.setContentAppendixUrl(q.getContentAppendixUrl());
                    questionVo.setId(q.getId());
                    questionVo.setMaxSelectItem(q.getMaxSelectItem());
                    questionVo.setMinSelectItem(q.getMinSelectItem());
                    questionVo.setNeedAnswer(q.getNeedAnswer());
                    questionVo.setNo(q.getNo());
                    questionVo.setType(q.getType());
                    questionVo.setOptions(new ArrayList<>());
                    //answerQuestions 是这个人这个调研的所有问题
                    // 拿到关联的答案问题
                    for (TrResearchAnswerQuestion aq : answerQuestions) {
                        raq = null;
                        if (questionVo.getId().equals(aq.getQuestionId())) {
                            //判断根据调研id和answerId查询出来的问题是同一个问题，从而可以比较学员选中的答案。
                            raq = aq;
                            break;
                        }
                    }
                    // 判定学员是否回答了这个
                    if (null != raq) {
                        // 拿取问题下的选项
                        optionList = questionOptionMap.get(q.getId());
                        if (!CollectionUtils.isEmpty(optionList)) {
                            // 处理 选择题
                            //1.如果是单选题或者是多选题，学员选项TrResearchAnswerQuestionResult中有OptionId记录正确的选项id
                            if (q.getType().equals(QuestionType.SINGLE_OPTION_QUESTION.getValue())
                                    || q.getType().equals(QuestionType.MULTIPLE_OPTION_QUESTION.getValue())) {
                                //遍历循环根据researchId查询出来的选项
                                for (TrResearchQuestionOption o : optionList) {
                                    ViewAnswerQuestionOptionVo optionVo = new ViewAnswerQuestionOptionVo();
                                    optionVo.setContent(o.getContent());
                                    optionVo.setCorrect(o.getCorrect());
                                    optionVo.setId(o.getId());
                                    optionVo.setJumpNum(o.getJumpNum());
                                    optionVo.setNo(o.getNo());
                                    //获得学员回答该题目的选项
                                    resultList = answerResultMap.get(raq.getId());
                                    if (!CollectionUtils.isEmpty(resultList)) {
                                        //遍历这些选项
                                        for (TrResearchAnswerQuestionResult r : resultList) {
                                            if (null != r.getOptionId()) {
                                                optionVo.setAnswerChecked(r.getOptionId().equals(optionVo.getId()));
                                                optionVo.setAnswerContent(r.getContent());
                                                if (optionVo.getAnswerChecked()) {
                                                    // questionToReMove.addAll(removeByQuestion(questions,optionVo.getJumpNum()));
                                                    break;
                                                }
                                            }
                                        }
                                    }

                                    questionVo.getOptions().add(optionVo);
                                }
                            }
                            // 处理 打分题
                            if (q.getType().equals(QuestionType.POINT_QUESTION.getValue())) {
                                for (TrResearchQuestionOption o : optionList) {
                                    //循环调研的选项
                                    ViewAnswerQuestionOptionVo optionVo = new ViewAnswerQuestionOptionVo();
                                    optionVo.setContent(o.getContent());
                                    optionVo.setId(o.getId());
                                    optionVo.setNo(o.getNo());
                                    optionVo.setMaxScore(o.getMaxScore());
                                    optionVo.setMinScore(o.getMinScore());
                                    // 获取分数
                                    resultList = answerResultMap.get(raq.getId());
                                    if (!CollectionUtils.isEmpty(resultList)) {
                                        for (TrResearchAnswerQuestionResult r : resultList) {
                                            if (optionVo.getId().equals(r.getOptionId())) {
                                                optionVo.setAnswerScore(r.getScore());
                                                break;
                                            }
                                        }
                                    }
                                    questionVo.getOptions().add(optionVo);
                                }
                            }
                        }
                        // 处理 问答题
                        if (q.getType().equals(QuestionType.ASK_ANSWER_QUESTION.getValue())) {
                            resultList = answerResultMap.get(raq.getId());
                            if (!CollectionUtils.isEmpty(resultList)) {
                                questionVo.setAnswerContent(resultList.get(0).getContent());
                            }
                        }
                        answerVo.getAnswerQuestions().add(questionVo);
                    }
                }
                List<ViewAnswerQuestionVo> questionVos = answerVo.getAnswerQuestions();
                List<ViewAnswerQuestionVo> questionVoList = new ArrayList<>(50);
                if (!CollectionUtils.isEmpty(questionVos)) {
                    for (ViewAnswerQuestionVo vo : questionVos) {
                        for (TrResearchQuestion q : questionToReMove) {
                            if (q.getId().equals(vo.getId())) {
                                questionVoList.add(vo);
                            }
                        }
                    }
                }
                questionVos.removeAll(questionVoList);
                answerVo.setAnswerQuestions(questionVos);
            }
            viewAnswerVos.add(answerVo);
        }
        return viewAnswerVos;
    }

    /**
     * 组装TrResearchAnswer
     *
     * @param answerVo
     * @param accountId
     * @param companyId
     * @param accountName
     * @param siteId
     * @param orgId
     * @param now
     * @return
     */
    private TrResearchAnswer buildAnswer(AnswerVo answerVo, Long accountId, Long companyId, String accountName, Long siteId, Long orgId, Date now) {
        TrResearchAnswer answer = new TrResearchAnswer();
        answer.setId(idGenerator.generate());
        answer.setAccountId(accountId);
        answer.setCompanyId(companyId);
        answer.setSiteId(siteId);
        answer.setCreateById(accountId);
        answer.setCreateByName(accountName);
        answer.setCreateTime(now);
        answer.setOrgId(orgId);
        answer.setFinish(1);
//        answer.setName(answerVo.getResearchName());
        answer.setResearchId(answerVo.getResearchId());
        answer.setTerminalType(answerVo.getTerminalType());
        answer.setStartTime(answerVo.getStartTime());
        answer.setSubmitTime(now);
        answer.setDuration(((int) (answerVo.getSubmitTime().getTime() - answerVo.getStartTime().getTime())) / 1000);
        return answer;
    }


    /**
     * 组装答卷问题集合
     *
     * @param questionVos
     * @param answer
     * @param accountId
     * @param accountName
     * @param now
     * @return
     */
    private List<TrResearchAnswerQuestion> buildAnswerQuestion(List<AnswerQuestionVo> questionVos, TrResearchAnswer answer, Long accountId, String accountName, Date now, List<TrResearchAnswerQuestionResult> questionResults) throws Exception {
        List<TrResearchAnswerQuestion> answerQuestionList = null;
        if (!CollectionUtils.isEmpty(questionVos)) {
            answerQuestionList = new ArrayList<>();
            for (AnswerQuestionVo questionVo : questionVos) {
                TrResearchAnswerQuestion answerQuestion = new TrResearchAnswerQuestion();
                answerQuestion.setId(idGenerator.generate());
                answerQuestion.setAnswerId(answer.getId());
                answerQuestion.setAccountId(accountId);
                answerQuestion.setCreateById(accountId);
                answerQuestion.setCreateByName(accountName);
                answerQuestion.setCreateTime(now);
                answerQuestion.setQuestionId(questionVo.getQuestionId());
                answerQuestion.setResearchId(answer.getResearchId());

                List<AnswerQuestionItemVo> questionItemVos = questionVo.getQuestionItems();
                if (!CollectionUtils.isEmpty(questionItemVos)) {
                    for (AnswerQuestionItemVo itemVo : questionItemVos) {
                        TrResearchAnswerQuestionResult result = new TrResearchAnswerQuestionResult();
                        result.setId(idGenerator.generate());
                        result.setResearchId(answerQuestion.getResearchId());
                        result.setAnswerId(answer.getId());
                        result.setAnswerQuestionId(answerQuestion.getId());
                        result.setCreateById(accountId);
                        result.setCreateByName(accountName);
                        result.setCreateTime(now);
                        result.setQuestionType(questionVo.getQuestionType());
                        // 如果是单选题或多选题
                        if (result.getQuestionType() == QuestionType.SINGLE_OPTION_QUESTION.getValue()
                                || result.getQuestionType() == QuestionType.MULTIPLE_OPTION_QUESTION.getValue()) {
                            result.setOptionId(itemVo.getOptionId());
                            // 如果有填空
                            if (!StringUtils.isEmpty(itemVo.getContent())) {
                                result.setContent(itemVo.getContent());
                            }
                        }
                        // 如果是问答题
                        else if (result.getQuestionType() == QuestionType.ASK_ANSWER_QUESTION.getValue()) {
                            result.setContent(itemVo.getContent());
                        }
                        // 如果是打分题
                        else if (result.getQuestionType() == QuestionType.POINT_QUESTION.getValue()) {
                            result.setOptionId(itemVo.getOptionId());
                            result.setScore(itemVo.getScore());
                        } else {
                            throw new Exception("未知的问题类型，请检查问题类型是否合规！！");
                        }

                        // 添加到待入库集合
                        questionResults.add(result);
                    }
                }
                answerQuestionList.add(answerQuestion);
            }
        }
        return answerQuestionList;
    }

    /**
     *
     * @param questionList 当前问题列表
     * @param researchQuestion 当前问题
     * @return 根据问题的跳题策略返回的问题列表
     */
   /* public List<TrResearchQuestion> removeByQuestion(List<TrResearchQuestion> questionList,TrResearchQuestion researchQuestion){
        List<TrResearchQuestion> questionList1=new ArrayList<TrResearchQuestion>(50);
        if(researchQuestion.getJumpType() == 2 && researchQuestion.getJumpNum()!=null){
        for(TrResearchQuestion q : questionList){
            //去除根据指定跳题规则跳过的题目
                if(q.getNo()< researchQuestion.getJumpNum()){
                    questionList1.add(q);
                }
            }
        }
        return questionList1;
    }*/

   /* public List<TrResearchQuestion> removeByQuestion(List<TrResearchQuestion> questionList,Integer jumpNum){
        List<TrResearchQuestion> questionList1=new ArrayList<TrResearchQuestion>(50);
        if(jumpNum != null){
            for(TrResearchQuestion q : questionList) {
                if(q.getNo() < jumpNum){
                    questionList1.add(q);
                }
            }
        }
        return questionList1;
    }*/
    /**
     * 获取指定跳题默认下一题的题号
     * @param
     * @return
     */
    /*public void   getNo(TrResearchQuestion researchQuestion) {
        List<TrResearchQuestion> questions = trResearchQuestionService.listAllForJump(researchQuestion.getId());
        Map<String, Object> map = new HashMap<>(4);
        map.put("question_id", researchQuestion.getId());
        map.put("deleted", 0);
        List<TrResearchQuestionOption> options = researchQuestionOptionMapper.selectByMap(map);
        if(!CollectionUtils.isEmpty(questions)){
        for (TrResearchQuestion question : questions) {
            if ((question.getJumpType() == null || question.getJumpType() == 2) && (question.getJumpNum() == null || question.getJumpNum() == -1)) {
                if (researchQuestion.getNo() < question.getNo()) {
                    researchQuestion.setNo(question.getNo());
                }
            }
            if ((question.getJumpType() == null || question.getJumpType() == 1) && !CollectionUtils.isEmpty(options)) {
                for (TrResearchQuestionOption option : options) {
                    if (option.getJumpNum() == null || option.getJumpNum() == -1) {
                        if (researchQuestion.getNo() < question.getNo()) {
                            option.setJumpNum(question.getNo());
                        }
                    }
                }
            }
        }
    }
    }*/
}
