package com.yizhi.research.application.util;

import com.alibaba.fastjson.JSON;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.event.EventWrapper;
import com.yizhi.core.application.publish.CloudEventPublisher;
import com.yizhi.core.application.publish.PublicSendMessageClient;
import com.yizhi.message.application.constans.Constans;
import com.yizhi.message.application.enums.RelationType;
import com.yizhi.research.application.eum.ResearchState;
import com.yizhi.research.application.vo.EvenType;
import com.yizhi.core.application.vo.MessageRemindVo;
import com.yizhi.core.application.vo.TaskVo;
import com.yizhi.research.application.vo.MessageTaskRemindVo;
import com.yizhi.research.application.vo.domain.Research;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Component
public class ResearchEvenSendMessage {

    @Autowired
    private PublicSendMessageClient publicSendMessageClient;
    private Logger logger = LoggerFactory.getLogger(ResearchEvenSendMessage.class);


    /**
     * 触发事件,根据可见范围发消息
     *
     * @param research  业务参数对象
     * @param accountId 用户id为空
     */
    public void evenSendMessage(Research research, Long accountId, EvenType evenType) {

        if (research != null) {
            TaskVo taskVo = new TaskVo();
            taskVo.setTaskName(research.getName());

            MessageRemindVo vo = new MessageRemindVo();
            vo.setVisibleRange(research.getVisibleRange());
            vo.setMessageId(evenType.getKey());
            vo.setMessageType(3);
            vo.setRelationId(research.getId());
            vo.setRelationType(RelationType.DY.getKey());
            vo.setSendType(1);
            vo.setTaskVo(taskVo);
            //定时任务默认五分钟执行一次   这里默认6分钟
            vo.setSendTime(DateUtils.addMinutes(new Date(), 6));
            if (accountId != null) {
                vo.setAccountId(accountId);
            }
            RequestContext requestContext = new RequestContext();
            requestContext.setCompanyId(research.getCompanyId());
            requestContext.setSiteId(research.getSiteId());
            requestContext.setAccountId(research.getCreateById());
            requestContext.setAccountName(research.getCreateByName());
            vo.setRequestContext(requestContext);
            try {
                //临时取消触发功能
//                publicSendMessageClient.processBizEvent(  new EventWrapper<MessageRemindVo>(null, vo));
            } catch (Exception e) {
                e.printStackTrace();
                logger.error("发送消息失败=====================", e);
            }
        }
    }

    /**
     * 系统模板,发消息
     *
     * @param research 业务参数对象
     */
    public void systemSendMessage(Research research, com.yizhi.research.application.vo.MessageRemindVo remindVo, RequestContext context) {
        MessageRemindVo vo = new MessageRemindVo();

        //共用参数
        vo.setRelationType(RelationType.DY.getKey());
        if (context == null) {
            context = new RequestContext();
            context.setCompanyId(research.getCompanyId());
            context.setSiteId(research.getSiteId());
            context.setAccountName(research.getCreateByName());
            context.setAccountId(research.getCreateById());
        }
        vo.setRequestContext(context);
        vo.setRelationId(research.getId());
        vo.setMessageType(2);
        if (remindVo != null) {
            logger.info("messageRemindVo:" + JSON.toJSONString(remindVo));
        }else {
            logger.info("未设置各个业务的提醒服务");
        }

        if (null != remindVo && null != remindVo.getIsCopy() && remindVo.getIsCopy()) {
            vo.setIsCopy(remindVo.getIsCopy());
            vo.setOldRelationId(remindVo.getOldRelationId());
            publicSendMessageClient.processBizEvent(vo);
            logger.error("发送复制消息成功=====================");
            return;
        }

        if (vo.getMessageType() == null || vo.getRelationId() == null || vo.getRelationType() == null) {
            logger.info("messageType:" + remindVo.getMessageType() + "||" + "RelationId:" + remindVo.getRelationId()
                    + "||" + "RelationType:" + remindVo.getRelationType());
            logger.info("相关参数缺失！！");
            return;
        }
        if (null != remindVo.getHasDeleted() && remindVo.getHasDeleted()) {
            vo.setHasDeleted(remindVo.getHasDeleted());
            publicSendMessageClient.processBizEvent(vo);
            logger.error("发送删除消息成功=====================");
        } else {
            //修改调研的状态
            if (remindVo.getTaskStatusUpdate()) {
                //1 为消息业务可发送状态  0 则不行
                vo.setTaskStatusUpdate(true);
                vo.setTaskStatus(research.getState() == ResearchState.RELEASED.getValue() ? 1 : 0);
                publicSendMessageClient.processBizEvent(vo);
                logger.info("发送修改业务状态消息成功=====================");
                return;
            }

            if (research != null) {
                if (!CollectionUtils.isEmpty(remindVo.getMessageTaskRemindVos())) {
                    TaskVo taskVo = new TaskVo();
                    taskVo.setTaskName(research.getName());
                    taskVo.setTaskStratTime(research.getStartTime());
                    taskVo.setTaskEndTime(research.getEndTime());
                    vo.setMessageId(remindVo.getMessageId());
                    vo.setIsChangge(remindVo.getIsChangge());
                    List<MessageTaskRemindVo> m=  remindVo.getMessageTaskRemindVos();
                    List<com.yizhi.core.application.vo.MessageTaskRemindVo> m2=new ArrayList<>();
                    for (MessageTaskRemindVo m1:m
                    ) {
                        com.yizhi.core.application.vo.MessageTaskRemindVo mx=new com.yizhi.core.application.vo.MessageTaskRemindVo();
                        BeanUtils.copyProperties(m1,mx);
                        m2.add(mx);
                    }
                    vo.setMessageTaskRemindVos(m2);
                    vo.setSendType(remindVo.getSendType());
                    vo.setVisibleRange(research.getVisibleRange());
                    vo.setTaskStatus(research.getState() == ResearchState.RELEASED.getValue() ? 1 : 0);
                    vo.setTaskVo(taskVo);
                    try {
                        if (vo.getMessageId() == null || vo.getSendType() == null || vo.getVisibleRange() == null) {
                            logger.info("messageID:" + remindVo.getMessageId() + "||" + "sendType:" + remindVo.getSendType()
                                    + "||" + "VisibleRange:" + remindVo.getVisibleRange());
                            logger.info("相关参数缺失！！!!!");
                            return;
                        }
                        publicSendMessageClient.processBizEvent(vo);
                        logger.info("发送消息成功=====================");
                    } catch (Exception e) {
                        e.printStackTrace();
                        logger.error("发送消息失败=====================", e);
                    }
                }
            }
        }
    }
}
