package com.yizhi.research.application.vo.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import com.yizhi.research.application.vo.MessageRemindVo;
import com.yizhi.research.application.vo.manage.RemindVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 调研
 * </p>
 *
 * @author shengchenglong
 * @since 2018-03-12
 */
@Data
@Api(tags = "Research", description = "调研")
@TableName("research")
public class Research extends Model<Research> {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "调研主键ID，主键")
    @TableId("id")
    private Long id;

    @ApiModelProperty(value = "培训项目ID")
    @TableField("training_project_id")
    private Long trainingProjectId;

    @ApiModelProperty(value = "调研编码，系统将自动生成调研编码；编码规则，按创建顺序累加，例如DY000001，DY000002")
    @TableField("research_no")
    private String researchNo;

    @ApiModelProperty(value = "积分，默认0")
    @TableField("point")
    private Integer point;

    @ApiModelProperty(value = "提醒设置，0否 1是，默认0")
    @TableField("remind")
    private Integer remind;

    @ApiModelProperty(value = "开启邮件提醒（0：否，1是，默认否）")
    @TableField("enable_mail_remind")
    private Integer enableMailRemind;

    @ApiModelProperty(value = "邮件提醒，模板id")
    @TableField("mail_template_id")
    private Long mailTemplateId;

    @ApiModelProperty(value = "开启站内提醒（0：否，1是，默认否）")
    @TableField("enable_app_remind")
    private Integer enableAppRemind;

    @ApiModelProperty(value = "站内消息提醒模板id")
    @TableField("app_template_id")
    private Long appTemplateId;

    @ApiModelProperty(value = "调研名称")
    @TableField("name")
    private String name;

    @ApiModelProperty(value = "开始时间")
    @TableField("start_time")
    private Date startTime;

    @ApiModelProperty(value = "结束时间")
    @TableField("end_time")
    private Date endTime;

    @ApiModelProperty(value = "可见范围，1平台用户可见（企业下所有人员） 2指定学员可见")
    @TableField("visible_range")
    private Integer visibleRange;

    @ApiModelProperty(value = "调研说明")
    @TableField("content")
    private String content;

    @ApiModelProperty(value = "调研备注")
    @TableField("remark")
    private String remark;

    @ApiModelProperty(value = "状态，0草稿 1上架 2下架")
    @TableField("state")
    private Integer state;

    @ApiModelProperty(value = "删除状态：0未删，1已删（默认0）")
    @TableField("deleted")
    private Integer deleted;

    @ApiModelProperty(value = "创建时间")
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;

    @ApiModelProperty(value = "创建人ID")
    @TableField(value = "create_by_id", fill = FieldFill.INSERT)
    private Long createById;

    @ApiModelProperty(value = "创建人姓名")
    @TableField(value = "create_by_name", fill = FieldFill.INSERT)
    private String createByName;

    @ApiModelProperty(value = "修改时间")
    @TableField(value = "update_time", fill = FieldFill.INSERT)
    private Date updateTime;

    @ApiModelProperty(value = "修改人ID")
    @TableField(value = "update_by_id", fill = FieldFill.INSERT)
    private Long updateById;

    @ApiModelProperty(value = "修改人姓名")
    @TableField(value = "update_by_name", fill = FieldFill.INSERT)
    private String updateByName;

    @ApiModelProperty(value = "下架时间")
    @TableField("un_release_time")
    private Date unReleaseTime;

    @ApiModelProperty(value = "下架人ID")
    @TableField("un_release_by_id")
    private Long unReleaseById;

    @ApiModelProperty(value = "下架人姓名")
    @TableField("un_release_by_name")
    private String unReleaseByName;

    @ApiModelProperty(value = "发布时间")
    @TableField("release_time")
    private Date releaseTime;

    @ApiModelProperty(value = "发布人ID")
    @TableField("release_by_id")
    private Long releaseById;

    @ApiModelProperty(value = "发布人姓名")
    @TableField("release_by_name")
    private String releaseByName;

    @ApiModelProperty(value = "企业_ID")
    @TableField("company_id")
    private Long companyId;

    @ApiModelProperty(value = "部门_ID")
    @TableField("org_id")
    private Long orgId;

    @ApiModelProperty(value = "站点_ID")
    @TableField("site_id")
    private Long siteId;

    /**
     * 该调研可参加人数
     */
    @ApiModelProperty(value = "可参加人数")
    @TableField(exist = false)
    private Integer count;

    /**
     * 实际参加人数
     */
    @ApiModelProperty(value = "实际参加人数")
    @TableField(exist = false)
    private Integer realCount;

    /**
     * 提醒集合，不持久化
     */
    @ApiModelProperty(value = "消息提醒")
    @TableField(exist = false)
    private List<TrResearchRemind> reminds;
    
    /**
     * 关联人员集合
     */
    @ApiModelProperty(value = "关联人员")
    @TableField(exist = false)
    private List<TrResearchAuthorize> authorizes;

    @ApiModelProperty(value = "关联人员id")
    @TableField(exist = false)
    private List<Long> relationIds;






    /**
     * 问题集合，不持久化
     */
    @ApiModelProperty(value = "消息提醒")
    @TableField(exist = false)
    private List<TrResearchQuestion> questions;

    @ApiModelProperty(value = "改调研的答卷")
    @TableField(exist = false)
    private List<TrResearchAnswer> trResearchAnswers;

    @ApiModelProperty(value = "搜索列表显示状态：0未开始，1已完成，2进行中，3已过期，4未参加调研")
    @TableField(exist = false)
    private Integer finishState;

    @ApiModelProperty(value = "完成时间")
    @TableField(exist = false)
    private Date finishTime;

    @ApiModelProperty(value = "各个业务设置提醒时的数据")
    @TableField(exist = false)
    private MessageRemindVo messageRemindVo;

    @ApiModelProperty(value = "关键字,逗号分隔")
    @TableField("keywords")
    private String keywords;

    @ApiModelProperty(value = "提醒vo")
    @TableField(exist = false)
    private RemindVo remindVo;

    @ApiModelProperty(value = "是否启用在日历任务中显示")
    @TableField("enable_task")
    private Integer enableTask;

    @ApiModelProperty(value = "调研logo")
    private String image;


    @ApiModelProperty(value = " 业务类型：1调研；2投票")
    private Integer bizType;

    @ApiModelProperty(value = "呈现样式：1逐题呈现；2整页呈现；3整页投票单选")
    private Integer pageMode;
    
    @ApiModelProperty(value = "投票选择次数：0无限制")
    private Integer voteNum;

    @ApiModelProperty(value = "展示样式")
    private Integer styleType;

    @ApiModelProperty(value = "展示样式")
    private String logoSrc;
    
    @Override
    protected Serializable pkVal() {
        return this.id;
    }

}
