package com.yizhi.research.application.vo.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 答案题目
 * </p>
 *
 * @author shengchenglong
 * @since 2018-03-12
 */
@Data
@Api(tags = "TrResearchAnswerQuestion", description = "答案题目")
@TableName("tr_research_answer_question")
public class TrResearchAnswerQuestion extends Model<TrResearchAnswerQuestion> {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "答卷题目ID，主键")
    @TableId("id")
    private Long id;

    @ApiModelProperty(value = "冗余调研id")
    @TableId("research_id")
    private Long researchId;

    @ApiModelProperty(value = "答卷_ID，外键")
    @TableField("answer_id")
    private Long answerId;

    @ApiModelProperty(value = "问题_ID，外键")
    @TableField("question_id")
    private Long questionId;

    @ApiModelProperty(value = "学员_ID")
    @TableField("account_id")
    private Long accountId;

    @ApiModelProperty(value = "创建时间")
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;

    @ApiModelProperty(value = "创建人ID")
    @TableField(value = "create_by_id", fill = FieldFill.INSERT)
    private Long createById;

    @ApiModelProperty(value = "创建人姓名")
    @TableField(value = "create_by_name", fill = FieldFill.INSERT)
    private String createByName;

    @ApiModelProperty(value = "修改时间")
    @TableField(value = "update_time", fill = FieldFill.INSERT)
    private Date updateTime;

    @ApiModelProperty(value = "修改人ID")
    @TableField(value = "update_by_id", fill = FieldFill.INSERT)
    private Long updateById;

    @ApiModelProperty(value = "修改人姓名")
    @TableField(value = "update_by_name", fill = FieldFill.INSERT)
    private String updateByName;

    @ApiModelProperty(value = "问题答案集合，不持久化")
    @TableField(exist = false)
    private List<TrResearchAnswerQuestionResult> questionResults;

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

}
