package com.yizhi.research.application.vo.domain;

import java.io.Serializable;
import java.util.Date;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * <p>
 * 问题附件
 * </p>
 *
 * @author shengchenglong
 * @since 2018-03-12
 */
@Data
@Api(tags = "tr_research_question_attachment", description = "问题附件")
@TableName("tr_research_question_attachment")
public class TrResearchQuestionAttachment extends Model<TrResearchQuestionAttachment> {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "主键")
    @TableId("id")
    private Long id;

    @ApiModelProperty(value = "问题主键_ID，外键")
    @TableField("research_question_id")
    private Long researchQuestionId;
    
    @ApiModelProperty(value = "存放附件路径，附件格式：音频、视频、图片")
    @TableField("content_appendix_url")
    private String contentAppendixUrl;
    
    @ApiModelProperty(value = "是否删除（0：未删，1：已删）")
    @TableField("deleted")
    private Integer deleted;

    @ApiModelProperty(value = "创建时间")
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;

    @ApiModelProperty(value = "创建人ID")
    @TableField(value = "create_by_id", fill = FieldFill.INSERT)
    private Long createById;

    @ApiModelProperty(value = "创建人姓名")
    @TableField(value = "create_by_name", fill = FieldFill.INSERT)
    private String createByName;

    @ApiModelProperty(value = "修改时间")
    @TableField(value = "update_time", fill = FieldFill.INSERT)
    private Date updateTime;

    @ApiModelProperty(value = "修改人ID")
    @TableField(value = "update_by_id", fill = FieldFill.INSERT)
    private Long updateById;

    @ApiModelProperty(value = "修改人姓名")
    @TableField(value = "update_by_name", fill = FieldFill.INSERT)
    private String updateByName;

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

}
