package com.yizhi.site.application.feign.api;

import com.yizhi.site.application.vo.domain.FunctionDisplayConfigVo;
import com.yizhi.site.application.vo.site.FunctionDisplayConfigVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @Author: XieHaijun
 * @Description:
 * @Date: Created in 17:59 2019/4/29
 * @Modified By
 */
@FeignClient(name = "portal", contextId = "FunctionDisplayConfigApiClients")
public interface FunctionDisplayConfigApiClients {

    @GetMapping("/api/functionDisplayConfig/siteId/all/get")
    List<FunctionDisplayConfigVo> getConfigBySiteId(@RequestParam(value = "siteId") Long siteId);

    @GetMapping("/api/functionDisplayConfig/site/all/get")
    List<FunctionDisplayConfigVo> getAllBySiteId();

    /**
     * 根据站点查询配置显示信息（没有配置信息返回null）
     * @return null 或者 List data
     */
    @GetMapping("/api/functionDisplayConfig/site/get")
    List<FunctionDisplayConfigVo> getBySiteId(@RequestParam("siteId") Long siteId);

    @PostMapping("/api/functionDisplayConfig/update")
    Integer update(@RequestBody List<FunctionDisplayConfigVO> vos);
}
