package com.yizhi.site.application.vo.domain;


import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 国际化
 * </p>
 *
 * @author lingye
 * @since 2020-08-13
 */
@Data
@Api(tags = "InternationalEntityVo", description = "")
public class InternationalVo {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "主键")
    private Long id;

    @ApiModelProperty(value = "key值")
    private String key;

    @ApiModelProperty(value = "中文字段")
    private String preTranslation;

    @ApiModelProperty(value = "翻译后")
    private String postTranslation;

    @ApiModelProperty(value = "备注")
    private String translateRemark;

    @ApiModelProperty(value = "0管理端 1 移动端 2 PC端")
    private Integer type;

    @ApiModelProperty(value = "语种id")
    private Long languageId;

    @ApiModelProperty(value = "创建时时间")
    private Date createTime;

    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    @ApiModelProperty(value = "创建人id")
    private Long createById;

    @ApiModelProperty(value = "修改人id")
    private Long updateById;

    @ApiModelProperty(value = "删除标记 1，删除")
    private Integer deleted;



    protected Serializable pkVal() {
        return this.id;
    }

}
