package com.yizhi.site.application.vo.domain;


import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 站点网页名称图片
 * </p>
 *
 * @author fulan123
 * @since 2019-07-05
 */
@Data
@Api(tags = "SiteConfigEntityVo", description = "站点网页名称图片")
public class SiteConfigVo {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "主键")
    private Long id;

    @ApiModelProperty(value = "站点id")
    private Long siteId;

    @ApiModelProperty(value = "公司id")
    private Long companyId;


    @ApiModelProperty(value = "网页图标")
    private String headIco;

    @ApiModelProperty(value = "网页名称")
    private String titleName;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    @ApiModelProperty(value = "创建人的id")
    private Long createById;

    @ApiModelProperty(value = "更新人的id")   private Long updateById;

    @ApiModelProperty(value = "1.删除。0.未删除")
    private Integer delFlag;



    protected Serializable pkVal() {
        return this.id;
    }

}
