package com.yizhi.site.application.controller;

import com.yizhi.site.application.domain.PortalImage;
import com.yizhi.site.application.constant.SiteConstant;
import com.yizhi.site.application.service.PortalBannerService;
import com.yizhi.site.application.service.PortalImageService;
import com.yizhi.site.application.vo.site.*;
import io.swagger.annotations.Api;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Calendar;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 轮播图管理，前端控制器
 * </p>
 *
 * @author bob123
 * @since 2018-03-27
 */
@Api(tags = "管理端-轮播图管理", description = "轮播图管理")
@RestController
@RequestMapping("/manage/banner")
@Log4j2
public class BannerManageController {

	@Autowired
	PortalBannerService portalBannerService;
	@Autowired
	PortalImageService portalImageService;

	/**
	 * 轮播banner管理
	 * 
	 * @param page
	 * @return
	 */
	@GetMapping("/list")
	public ReturnImageVO listPage(@RequestBody SiteComponyIdVO siteComponyIdVO) {
		return portalBannerService.listPage(siteComponyIdVO);
	}

	/**
	 * 轮播banner预览
	 * 
	 * @param id
	 * @return
	 */
	@GetMapping("/preview")
	public List<PortalBannerVo> viewMessage(@RequestParam Long id) {
		return portalBannerService.viewMessage(id);
	}

	/**
	 * 轮播banner项列表
	 * 
	 * @return
	 */
	@GetMapping("/item/list")
	public List<ImageListVO> selectBanner(@RequestBody ImageListVO imageListVO) {
		return portalBannerService.selectBanner(imageListVO);
	}
	
	@PostMapping("/item/drag")
	public Boolean dragImage(@RequestBody IdTwoVO vo){
		return portalBannerService.dragImage(vo);
	}

	/**
	 * 轮播banner项新增
	 * 
	 * @param vo
	 * @return
	 */
	@PostMapping("/item/insert")
	Long insertDetail(@RequestBody BannerImageListVO vo) {
		return portalBannerService.insertDetail(vo);
	}

	/**
	 * 轮播banner项修改
	 * 
	 * @param PortalBanner
	 * @return
	 */
	@PostMapping("/item/update")
	Long updateImage(@RequestBody BannerImageListVO vo) {
		PortalImage portalImage = portalImageService.selectById(vo.getId());
		portalImage.setImgTitle(vo.getImgTitle());
		portalImage.setBannerPath(vo.getBannerPath());
		portalImage.setHomeType(vo.getHomeType());
		portalImage.setLinkUrl(vo.getLinkUrl());
		portalImage.setAddTime(vo.getAddTime());
		portalImage.setImgTitleSub(vo.getImgTitleSub());
		portalImage.setImgSource(vo.getImgSource());
		portalImage.setUpdateById(vo.getAccountId());
		portalImage.setUpdateByName(vo.getAccountName());
		portalImage.setUpdateTime(new Date());

        // 指定时间banner上架操作
        try {
            //先刪除job
            portalBannerService.delete(vo.getId());
        } catch (Exception e) {
            e.printStackTrace();
        }

        // 判断时间
        Calendar nowDate = Calendar.getInstance();
        nowDate.setTime(new Date());
        //输入新闻的发布时间
        if(vo.getAddTime() != null){
        	Calendar releaseTime = Calendar.getInstance();
            releaseTime.setTime(vo.getAddTime());
            if (releaseTime.after(nowDate)){
                portalImage.setState(SiteConstant.TWO);
                portalImageService.updateById(portalImage);
                try {
                    // 新增job
                    portalBannerService.timeUpBanner(vo.getId());
                } catch (Exception e) {
                    e.printStackTrace();
                }

            } else {
                portalImage.setState(SiteConstant.FIRST);
                portalImageService.updateById(portalImage);
            }
        } else {
        	portalImage.setState(SiteConstant.FIRST);
            portalImageService.updateById(portalImage);
        }
        
        return vo.getId();
	}

	/**
	 * 轮播banner项删除
	 * 
	 * @param id
	 * @return
	 */
	@PostMapping("/item/delete")
	Boolean bannerDelete(@RequestBody IdOneVO vo) {
		return portalBannerService.bannerDelete(vo.getId());
	}

	/**
	 * 轮播banner项上架
	 * 
	 * @param id
	 * @return
	 */
	@PostMapping("/item/up")
	Boolean bannerUp(@RequestBody IdOneVO vo) {
		return portalBannerService.bannerUp(vo.getId());
	}

	/**
	 * 轮播banner项下架
	 * 
	 * @param id
	 * @return
	 */
	@PostMapping("/item/down")
	Boolean bannerDown(@RequestBody IdOneVO vo) {
		return portalBannerService.bannerDown(vo.getId());
	}

	@PostMapping("/home/image/listHomeImage")
	public List<ImageListVO> listAllHomeBannerImage(@RequestBody AllHomeBannerImageVO vo) {
		return portalBannerService.listAllHomeBannerImage(vo);
	}

    /**
     * 定时上将banner
     * @param id bannerId
     * @return
     */
    @PostMapping("/up")
    Boolean upBanner(@RequestParam(value = "id") Long id) {
        IdOneVO idOneVO = new IdOneVO();
        idOneVO.setId(id);
        portalBannerService.bannerUp(idOneVO.getId());

        try {
            // 刪除job
            portalBannerService.delete(id);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }
    @PostMapping("/timeup")
    public void updatebanner(@RequestParam(value = "id") Long id){

        portalBannerService.timeUpBanner(id);
    }
}
