package com.yizhi.site.application.controller;

import java.util.List;

import com.yizhi.site.application.domain.DataClassification;
import com.yizhi.site.application.domain.Information;
import com.yizhi.site.application.service.DataClassificationService;
import com.yizhi.site.application.vo.site.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.yizhi.core.application.context.RequestContext;
import com.yizhi.site.application.service.InformationService;

import io.swagger.annotations.Api;

/**
 * <p>
 * 资讯分类，前端控制器
 * </p>
 *
 * @author bob123
 * @since 2018-03-27
 */
@Api(tags = "管理端-资讯分类", description = "资讯分类")
@RestController
@RequestMapping("/manage")
public class ClassifyManageController {
	@Autowired
	private DataClassificationService dataClassificationService;
	@Autowired
	private InformationService informationService;

	/**
	 * 根据父类查找子类
	 * 
	 * @param parentId
	 * @return
	 */
	@GetMapping("/classify/childnode/find")
	public List<DataClassification> getInformation(@RequestParam(name = "parentId") Long parentId) {
		return dataClassificationService.getSon(parentId);
	}

	/**
	 * 查找分类资料
	 * 
	 * @param siteId
	 * @param pageNo
	 * @param pageSize
	 * @return
	 */
	@GetMapping("/site/classify/list")
	public List<ClassificationVO> getClassification(@RequestBody SiteComponyIdVO siteComponyIdVO) {
		return dataClassificationService.getClassification(siteComponyIdVO);
	}

	/**
	 * 保存分类资料
	 * 
	 * @param dataClassification
	 * @return
	 */
	@PostMapping("/site/classify/insertClassify")
	public Boolean insertClassify(@RequestBody DataClassification dataClassification) {
		return dataClassificationService.insertClassification(dataClassification);
	}

	/**
	 * 查询所有的父节点
	 * 
	 * @return
	 */
	@GetMapping("/site/classify/select")
	public List<DataClassification> selectParent(@RequestBody RequestContext context) {
		return dataClassificationService.selectParent(context);
	}

	/**
	 * 修改分类资料
	 * 
	 * @param
	 * @return
	 */
	@PostMapping("/site/classify/updateClassify")
	public Boolean updateClassify(@RequestBody DataClassification dataClassification) {
		return dataClassificationService.updateById(dataClassification);
	}

	/**
	 * 删除分类
	 * 
	 * @param id
	 */
	@PostMapping("/site/classify/delete")
	public RespVO deleteClassify(@RequestBody IdOneVO vo) {
//		return dataClassificationService.deleteById(vo.getId());

       return dataClassificationService.delClassify(vo.getId());
	}

	/**
	 * 查找资讯
	 * 
	 * @param id
	 */
	@GetMapping("/site/classify/information/select")
	public List<Information> selectInformation(@RequestParam(name = "typeTwo") Long typeTwo) {
		return informationService.selectInformation(typeTwo);
	}
	
	/**
	 * 资讯分类拖拽排序
	 */
	@PostMapping("/site/classify/dragClassify")
	public Boolean dragClassify(@RequestBody IdTwoVO vo){
		return dataClassificationService.dragClassify(vo);
	}

}
