package com.yizhi.site.application.domain;

import java.io.Serializable;

import com.baomidou.mybatisplus.enums.FieldFill;
import com.baomidou.mybatisplus.enums.IdType;
import java.util.Date;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableName;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotations.Version;
import lombok.Data;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * <p>
 * 语言国际化的key表
 * </p>
 *
 * @author taoge123
 * @since 2020-09-17
 */
@Data
@ApiModel(value = "InternationalKey", description = "语言国际化的key表 ")
@TableName("international_key")
public class InternationalKey {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "主键")
    @TableId(value="id")
    private Long id;

    @ApiModelProperty(value = "key值")
    @TableField("international_key")
    private String internationalKey;

    @ApiModelProperty(value = "中文字段")
    @TableField("pre_translation")
    private String preTranslation;

    @ApiModelProperty(value = "备注")
    @TableField("translate_remark")
    private String translateRemark;

    @ApiModelProperty(value = "0管理端 1 移动端 2 PC端")
    private Integer type;

    @ApiModelProperty(value = "创建时时间")
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;

    @ApiModelProperty(value = "更新时间")
    @TableField(value = "update_time", fill = FieldFill.INSERT)
    private Date updateTime;

    @ApiModelProperty(value = "创建人id")
    @TableField(value = "create_by_id", fill = FieldFill.INSERT)
    private Long createById;

    @ApiModelProperty(value = "修改人id")
    @TableField(value = "update_by_id", fill = FieldFill.INSERT)
    private Long updateById;

    @ApiModelProperty(value = "删除标记 1，删除")
    private Integer deleted;



}
