package com.yizhi.site.application.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 
 * </p>
 *
 * @author bob123
 * @since 2018-03-27
 */
@ApiModel(value = "PortalBannerEntityVo", description = "轮播图")
@Data
@TableName("tr_portal_banner")
public class PortalBanner extends Model<PortalBanner> {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "轮播图ID")
	private Long id;
	
	@ApiModelProperty(value = "终端ID")
	@TableField("terminal_id")
	private Long terminalId;	
	
	@ApiModelProperty(value = "所属栏目")
	@TableField("banner_name")
	private String bannerName;

	@ApiModelProperty(value = "0删除 1:未删除")
	private Integer state;

    @ApiModelProperty(value = "创建时间")
    @TableField("create_time")
    private Date createTime;

	@ApiModelProperty(value = "创建人")
	@TableField("create_by_id")
	private Long createById;

	@ApiModelProperty(value = "创建人姓名")
	@TableField("create_by_name")
	private String createByName;

	@ApiModelProperty(value = "修改时间")
	@TableField("update_time")
	private Date updateTime;

	@ApiModelProperty(value = "修改人")
	@TableField("update_by_id")
	private Long updateById;

	@ApiModelProperty(value = "修改人姓名")
	@TableField("update_by_name")
	private String updateByName;
	
	@ApiModelProperty(value = "站点ID")
    @TableField("site_id")
    private Long siteId; 

	@Override
	protected Serializable pkVal() {
		return this.id;
	}
}
