package com.yizhi.site.application.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import com.baomidou.mybatisplus.enums.IdType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 
 * </p>
 *
 * @author fulan123
 * @since 2018-12-17
 */
@Data
@Api(tags = "RelationLiveEntityVo", description = "")
@TableName("relation_live")
public class RelationLive extends Model<RelationLive> {

    private static final long serialVersionUID = 1L;


@ApiModelProperty(value = "主键")
	@TableId(value="id", type= IdType.AUTO)
	private Long id;

@ApiModelProperty(value = "终端ID")
	@TableField("terminal_id")
	private Long terminalId;

@ApiModelProperty(value = "关联的直播id")
	@TableField("live_id")
	private Long liveId;


@ApiModelProperty(value = "状态")
private Integer state;


	@TableField(value = "create_by_id", fill = FieldFill.INSERT)
	private Long createById;

	@TableField(value = "create_by_name", fill = FieldFill.INSERT)
	private String createByName;

	@TableField(value = "create_time", fill = FieldFill.INSERT)
	private Date createTime;

	@TableField(value = "update_by_id", fill = FieldFill.INSERT)
	private Long updateById;

	@TableField(value = "update_by_name", fill = FieldFill.INSERT)
	private String updateByName;

	@TableField(value = "update_time", fill = FieldFill.INSERT)
	private Date updateTime;


	@Override
	protected Serializable pkVal() {
		return this.id;
	}

}
