package com.yizhi.site.application.mapper;

import java.util.List;
import java.util.Map;

import com.yizhi.site.application.domain.PortalBanner;
import org.apache.ibatis.annotations.Param;

import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.site.application.vo.site.AllHomeBannerImageVO;
import com.yizhi.site.application.vo.site.ImageListVO;
import com.yizhi.site.application.vo.site.PortalBannerVo;

/**
 * <p>
 *  Mapper 接口
 * </p>
 *
 * @author bob123
 * @since 2018-03-27
 */
public interface PortalBannerMapper extends BaseMapper<PortalBanner> {
	
	public List<PortalBannerVo> viewMessage(@Param(value="id") Long id);
	
	public Integer countPortalBanner(@Param(value="id") Long id, @Param(value="siteId") Long siteId, @Param(value="terminalId") Long terminalId);
	
	public List<PortalBannerVo>  selectPortalBanner(Page<PortalBannerVo> page, Map<String, Object> map);

	public List<ImageListVO> selectBannerImage(Page<ImageListVO> page, Long terminalId);
	
	public List<ImageListVO> listAllHomeBannerImage(AllHomeBannerImageVO vo);
	
	public List<ImageListVO>  selectBanner(@Param(value="bannerName")String bannerName,@Param(value="terminalName") String terminalName );

	public List<PortalBanner> selectByTerminalName(@Param(value="terminalName")String terminalName, @Param(value="siteId")Long siteId, @Param(value="companyId")Long companyId);

}
