package com.yizhi.site.application.service;

import java.util.Date;
import java.util.List;

import com.yizhi.site.application.domain.PortalBanner;
import org.springframework.web.bind.annotation.RequestParam;

import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.IService;
import com.yizhi.site.application.vo.site.AllHomeBannerImageVO;
import com.yizhi.site.application.vo.site.BannerImageListVO;
import com.yizhi.site.application.vo.site.IdTwoVO;
import com.yizhi.site.application.vo.site.ImageListVO;
import com.yizhi.site.application.vo.site.PortalBannerVo;
import com.yizhi.site.application.vo.site.ReturnImageVO;
import com.yizhi.site.application.vo.site.SiteComponyIdVO;

/**
 * <p>
 *  服务类
 * </p>
 *
 * @author bob123
 * @since 2018-03-27
 */
public interface PortalBannerService extends IService<PortalBanner> {

	/**
	 * 轮播banner管理
	 * @param page
	 * @return
	 */
//	public List<PortalBannerVo> listPage(SiteComponyIdVO SiteComponyIdVO);
	public ReturnImageVO listPage(SiteComponyIdVO SiteComponyIdVO);
	
	/**
	 * 轮播banner项列表
	 * @param page
	 * @return
	 */
	//public Page<PortalImageEntityVo> findByList(Page<PortalImageEntityVo> page);
	public List<ImageListVO>  selectBanner(ImageListVO imageListVO);
	
	/**
	 * 轮播banner项新增
	 * @param portalBannerVo
	 * @return
	 */
	public Long insertDetail(BannerImageListVO vo);
	
	/**
	 * 轮播banner预览
	 * @param id
	 * @return
	 */
	public List<PortalBannerVo>  viewMessage(Long id);
	
	/**
	 * 轮播banner项删除
	 * @param id
	 * @param bannerId
	 * @return
	 */
	public Boolean bannerDelete(Long imageId);
	
	/**
	 * 轮播banner项上架
	 * @param id
	 * @return
	 */
	public Boolean bannerUp(@RequestParam Long id);
	
	/**
	 * 轮播banner项下架
	 * @param id
	 * @return
	 */
	public Boolean bannerDown(@RequestParam Long id);

	/**
	 * 获取首页 轮播图片
	 * @param vo
	 * @return
	 */
	public List<ImageListVO> listAllHomeBannerImage(AllHomeBannerImageVO vo);

	/**
	 * 轮播banner图片拖动
	 * @param vo
	 * @return
	 */
	public Boolean dragImage(IdTwoVO vo);
	
	Long createTerminal(String terminalName, Long siteId, Long companyId, Long createById, String createByName, Date date, Long orgId, Integer type, 
			Integer displayType);
	
	void createBanner(Long terminalId, Long siteId, Long createById, String createByName, Date date);

    /**
     *
     * 新增job
     * @param id bannerId
     * @return
     */
	boolean timeUpBanner(Long id);

    /**
     * 刪除job
     * @param id
     * @return
     */
    boolean delete(Long id);
    
    
    
    
    
    
    /**
     * ---------------------------------分隔符---------------------------
     */
    Page<ImageListVO> getAllBanerPc(Long terminalId,Integer pageNo,Integer pageSize);
	
}
