package com.yizhi.site.application.service.impl;

import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.site.application.domain.TrPortalPage;
import com.yizhi.site.application.domain.TrPortalPageBottom;
import com.yizhi.site.application.domain.TrPortalPageBottomLink;
import com.yizhi.site.application.mapper.TrPortalPageMapper;
import com.yizhi.site.application.service.ITrPortalPageBottomLinkService;
import com.yizhi.site.application.service.ITrPortalPageBottomService;
import com.yizhi.site.application.service.ITrPortalPageService;
import com.yizhi.site.application.vo.domain.TrPortalPageBottomVo;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.site.application.vo.site.TrPortalPageBottomLinkEntityVo;
import com.yizhi.site.application.vo.site.TrPortalPagePCVo;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;

import java.util.Date;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author liang123
 * @since 2018-12-24
 */
@Service
public class TrPortalPageServiceImpl extends ServiceImpl<TrPortalPageMapper, TrPortalPage> implements ITrPortalPageService {

	
	@Autowired
	IdGenerator idGenerator;
	@Autowired
	private ITrPortalPageBottomService portalPageBottomService;
	@Autowired
	private ITrPortalPageBottomLinkService trPortalPageBottomLinkService;
	
	@Override
	public Boolean pageBottomSave(TrPortalPagePCVo trPortalPagePCVo) {
		// TODO Auto-generated method stub
		Date date=new Date();
		TrPortalPageBottom trPortalPageBottom=null;
		Long linkedId=idGenerator.generate();
		TrPortalPageBottomVo trPortalPageBottomEnd=trPortalPagePCVo.getTrPortalPageBottomEntityVo();
		if(trPortalPageBottomEnd!=null) {
			Integer type=trPortalPageBottomEnd.getType();
			
			trPortalPageBottom=new TrPortalPageBottom();
			trPortalPageBottom.setId(linkedId);
			trPortalPageBottom.setPageId(trPortalPagePCVo.getPageId());
			trPortalPageBottom.setType(type);
			trPortalPageBottom.setState(1);//未删除
			trPortalPageBottom.setCreateById(ContextHolder.get().getAccountId());
			trPortalPageBottom.setCreateByName(ContextHolder.get().getAccountName());
			trPortalPageBottom.setCreateTime(date);
			trPortalPageBottom.setContent(trPortalPageBottomEnd.getContent());
			
			if(type==1) {//文案
				
				return portalPageBottomService.insert(trPortalPageBottom);
			}
			if(type==2) {//链接
				trPortalPageBottom.setContentType(trPortalPageBottom.getContentType());
				trPortalPageBottom.setDisplay(trPortalPageBottom.getDisplay());
				trPortalPageBottom.setContent(trPortalPageBottomEnd.getContent());
				portalPageBottomService.insert(trPortalPageBottom);
				List<TrPortalPageBottomLinkEntityVo> listTrPortalPageBottomLink=trPortalPagePCVo.getListTrPortalPageBottomLinkEntityVo();
				if(CollectionUtils.isNotEmpty(listTrPortalPageBottomLink)) {
					TrPortalPageBottomLink trPortalPageBottomLink=null;
					
					for (int i = 0; i < listTrPortalPageBottomLink.size(); i++) {
						trPortalPageBottomLink=new TrPortalPageBottomLink();
						trPortalPageBottomLink.setId(idGenerator.generate());
						trPortalPageBottomLink.setLinkId(linkedId);
						trPortalPageBottomLink.setTag(listTrPortalPageBottomLink.get(i).getTag());
						trPortalPageBottomLink.setContentUrl(listTrPortalPageBottomLink.get(i).getContentUrl());
						trPortalPageBottomLink.setCreateById(ContextHolder.get().getAccountId());
						trPortalPageBottomLink.setCreateByName(ContextHolder.get().getAccountName());
						trPortalPageBottomLink.setCreateTime(date);
						trPortalPageBottomLinkService.insert(trPortalPageBottomLink);
					}
				}
			}
		}
		return null;
		
	}

	@Override
	public TrPortalPage getTrPortalPageByTerminald(Long terminalId) {
		// TODO Auto-generated method stub
		TrPortalPage tpp=new TrPortalPage();
		tpp.setTerminalId(terminalId);
		EntityWrapper<TrPortalPage> wrapper=new EntityWrapper<TrPortalPage>(tpp);
		tpp=this.selectOne(wrapper);
		if(tpp==null) {
			tpp=new TrPortalPage();
			tpp.setId(idGenerator.generate());
			tpp.setTerminalId(terminalId);
			tpp.setType(0);
			tpp.setContent("上海易知科技提供技术支持");
			tpp.setCreateById(ContextHolder.get().getAccountId());
			tpp.setCreateByName(ContextHolder.get().getAccountName());
			tpp.setCreateTime(new Date());
			this.insert(tpp);
		}
		return tpp;
	}

	@Override
	public Boolean pageBottomUpdate(Long pageId, Integer type) {
		// TODO Auto-generated method stub
		TrPortalPage tpp=new TrPortalPage();
		tpp.setId(pageId);
		tpp.setType(type);
		return this.updateById(tpp);
	}

}
