package com.yizhi.site.application.feign;

import com.yizhi.site.application.vo.site.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 轮播
 * @author HUIHUI.DUAN
 * @date 2018/3/28 10:44
 */
@FeignClient(name = "portal", contextId = "BannerManageFeignClients")
public interface BannerManageFeignClients {
	
	/**
	 * 轮播banner管理
	 * @param page
	 * @return
	 */
	@GetMapping("/manage/banner/list")
    ReturnImageVO listPage(@RequestBody SiteComponyIdVO siteComponyIdVO);
	
	
	/**
	 * 轮播banner预览
	 * @param id
	 * @return
	 */
	@GetMapping("/manage/banner/preview")
	List<PortalBannerVo>  viewMessage(@RequestParam("id") Long id);
	
	/**
	 * 轮播banner项列表
	 * @return
	 */
	@GetMapping("/manage/banner/item/list")
	public List<ImageListVO> selectBanner(ImageListVO imageListVO);
	

	/**
	 * 轮播banner图片拖动
	 * @param vo
	 * @return
	 */
	@PostMapping("/manage/banner/item/drag")
	Boolean dragImage(@RequestBody IdTwoVO vo);
	
	/**
	 * 轮播banner项新增
	 * @param PortalBanner
	 * @return
	 */
	@PostMapping("/manage/banner/item/insert")
	Long insertDetail(@RequestBody BannerImageListVO vo);
	
	/**
	 * 轮播banner项修改
	 * @param PortalBanner
	 * @return
	 */
	@PostMapping("/manage/banner/item/update")
	Long updateImage(@RequestBody BannerImageListVO vo);
	
	/**
	 * 轮播banner项删除
	 * @param id
	 * @return
	 */
	@PostMapping("/manage/banner/item/delete")
	Boolean bannerDelete(@RequestBody IdOneVO vo);
	
	
	/**
	 * 轮播banner项上架
	 * @param id
	 * @return
	 */
	@PostMapping("/manage/banner/item/up")
	Boolean bannerUp(@RequestBody IdOneVO vo);
	
	/**
	 * 轮播banner项下架
	 * @param id
	 * @return
	 */
	@PostMapping("/manage/banner/item/down")
	Boolean bannerDown(@RequestBody IdOneVO vo);
	
	/**
	 * 首页获取轮播图片
	 * @param vo
	 * @return
	 */
	@PostMapping("/manage/banner/home/image/listHomeImage")
	List<ImageListVO> listAllHomeBannerImage(@RequestBody AllHomeBannerImageVO vo);

    /**
     * 定时上架banner
     * @param id
     * @return
     * @since 2018-9-5 15:23:40
     */
    @PostMapping(value = "/manage/banner/up")
    Boolean upBanner(@RequestParam(value = "id") Long id);

}
