package com.yizhi.site.application.feign;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.site.application.vo.domain.SiteVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 多站点管理
 * 
 * @author HUIHUI.DUAN
 * @date 2018/3/28 10:44
 *
 */
@FeignClient(name = "portal", contextId = "MoreSiteManageFeignClients")
public interface MoreSiteManageFeignClients {

	/**
	 * 分页列表
	 */
	@GetMapping("/sites/list")
	Page<SiteVo> listPage(@RequestBody Page<SiteVo> page);

	/**
	 * 新增站点
	 */
	@PostMapping("/sites/insert")
	Boolean insertDetail(@RequestBody SiteVo site);

	/**
	 * 站点编辑
	 */
	@PostMapping("/sites/update")
	Boolean updateById(@RequestBody SiteVo site);

	/**
	 * 站点查看
	 */
	@GetMapping("/sites/view")
	SiteVo find(@RequestParam("id") Long id);

	/**
	 * 站点上架
	 */
	@PostMapping("/sites/up")
	Boolean siteUp(@RequestParam("id") Long id);

	/**
	 * 站点上架
	 */
	@PostMapping("/sites/down")
	Boolean siteDown(@RequestParam("id") Long id);

	/**
	 * 站点设置管理人员
	 */
	@PostMapping("/sites/user/manage")
	Boolean setManagePersonnal(@RequestParam("siteId") Long siteId, @RequestParam("accountId") Long accountId);

}
