package com.yizhi.site.application.feign;

import com.yizhi.site.application.vo.domain.PageFooterItemVo;
import com.yizhi.site.application.vo.domain.PageFooterVo;
import com.yizhi.site.application.vo.site.PageFooterItemConfigVo;
import com.yizhi.site.application.vo.site.PageFooterVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 *   底页编辑 接口
 */
@FeignClient(name = "portal", contextId = "PageFooterClient")
public interface PageFooterClient {


    /**
     * 编辑页底信息
     *
     * @param pageFooter
     * @return
     */
    @PostMapping("/manage/page/pageFooter/save")
    public PageFooterVo pageFooterSave(@RequestBody PageFooterVo pageFooter);

    /**
     * 保存文案
     * @param pageFooterItem
     * @return
     */
    @PostMapping("/manage/page/pageFooterItem/save")
    public PageFooterItemVo pageFooterItemSave(@RequestBody PageFooterItemVo pageFooterItem);

    /**
     * 保存链接
     * @param pageFooterItemConfigVo
     * @return
     */
    @PostMapping("/manage/page/pageFooterItemConfig/save")
    PageFooterItemConfigVo spageFooterItemConfigSave(@RequestBody PageFooterItemConfigVo pageFooterItemConfigVo);


    /**
     * 根据FooterItemId 删除
     * @param id
     * @return
     */
    @GetMapping("/manage/page/pageFooterItem/delete")
    public Boolean delete(@RequestParam("id") Long id);

    /**
     * 新增回显查询列表
     *
     * @param TerminalType
     * @return
     */
    @GetMapping("/manage/page/pageFooterItem/getList")
    public PageFooterVO getList(@RequestParam(name = "TerminalType") Integer TerminalType);



    /**
     * 底页查询列表
     *
     * @return
     */
    @GetMapping("/manage/page/pageFooterItem/get")
    public PageFooterVO selectPage(@RequestParam(name = "TerminalType")Integer TerminalType);

    /**
     * 排序(文案、链接)
     *
     * @param list
     * @return
     */
    @PostMapping("/manage/page/pageFooterItem/sort")
    public Integer pageFooterItemSort(@RequestBody List<PageFooterItemVo> list);
}
