package com.yizhi.site.application.feign;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.site.application.vo.domain.PublicationVo;
import com.yizhi.site.application.vo.domain.PublicationVo;
import com.yizhi.site.application.vo.site.*;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(name = "portal", contextId = "PublicationManageFeignClients")
public interface PublicationManageFeignClients {

	/**
	 * 查看投稿
	 */
	@PostMapping("/site/classify/publication/list")
	public Page<PublicationVo> list(@RequestBody PublicationParamVO vo);

	@ApiOperation(value = "查询发布的新闻列表")
	@PostMapping("/site/classify/publication/release/list")
	public Page<PublicationVo> releaseList(@RequestBody PublicationParamReleaseVO vo);

	/**
	 * 保存资料分类
	 */
	@PostMapping("/site/classify/publication/insert")
	public Long insert(@RequestBody PublicationVo publicationVo);

	/**
	 * 修改资料分类
	 */
	@PostMapping("/site/classify/publication/update")
	public Boolean update(@RequestBody PublicationVo publicationVo);

	/**
	 * 删除投稿
	 */
	@PostMapping("/site/classify/publication/delete")
	Boolean deleteById(@RequestBody IdOneVO vo);

	/**
	 * 投稿发布
	 */
	@GetMapping("/site/classify/publication/releases")
	boolean releases(@RequestParam(name = "id") Long id);

	/**
	 * 投稿取消发布
	 */
	@GetMapping("/site/classify/publication/unreleases")
	boolean unreleases(@RequestParam(name = "id") Long id);

	/**
	 * 投稿预览
	 */
	@GetMapping(value = "/site/classify/publication/view/{id}")
	PublicationVo publicationView(@RequestParam(name = "id") Long id);

	/**
	 * 投稿审批通过
	 */
	@GetMapping(value = "/site/classify/publication/approve/{id}")
	boolean approve(@RequestParam(name = "id") Long id);

	/**
	 * 投稿审批不通过
	 */
	@GetMapping(value = "/site/classify/publication/unApprove/{id}")
	boolean unApprove(@RequestParam(name = "id") Long id);

	/**
	 * 搜索投稿
	 */
	@GetMapping(value = "/site/classify/publication/listbyName")
	List<PublicationVo> listbyName(@RequestParam(name = "name") String name, @RequestParam(name = "siteId") Long siteId);

    /**
     * 新闻投稿公告上架
     * @param id 新闻公告id
     * @return
     */
    @GetMapping("/site/classify/publication/upPublication")
    public boolean upPublication(@RequestParam(value = "id") Long id);
	/**
	 * 新闻投稿pdf转图片需要
	 * @return
	 */
	@PostMapping(value = "/site/classify/publication/updateContent")
	public boolean updateContent(@RequestBody PublicationVo publicationVo);
	
	/**
	 * 滚动提示接口：投稿管理（4天内创建且待审核的数据）
	 * @return
	 */
	@GetMapping("/site/classify/publication/selectContributionManagementForScroll")
	List<PublicationVo> selectContributionManagementForScroll();
}
