package com.yizhi.site.application.feign.api;

import com.yizhi.site.application.vo.domain.*;
import com.yizhi.site.application.vo.site.AnnouncementVO;
import com.yizhi.site.application.vo.site.ApiPortalPCLink;
import com.yizhi.site.application.vo.site.HomeLogoEntityVo;
import com.yizhi.site.application.vo.site.PortalTemplateVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(name = "portal", contextId = "PortalApiPCFeignClients")
public interface PortalApiPCFeignClients {
	
	/**
	 * 首页第一行信息
	 */
	@GetMapping(value = "/api/portal/pc/base/message")
    HomeLogoEntityVo baseMeaage(@RequestParam("siteId") Long siteId, @RequestParam("terminalType") Integer terminalType);
	
	
	@GetMapping(value="/api/portal/pc/link/up")
	List<ApiPortalPCLink> listApiPortalPCLinkUp(@RequestParam("siteId") Long siteId, @RequestParam("terminalType") Integer terminalType);
	
	
	@GetMapping(value="/api/portal/pc/banner/image")
	List<PortalImageVo> listApiPortalPCPortalImage(@RequestParam("siteId") Long siteId, @RequestParam("terminalType") Integer terminalType);
	
	@GetMapping(value="/api/portal/pc/look/num")
    TrPortalLookNumVo listApiPortalPCPortalLookNum(@RequestParam("siteId") Long siteId, @RequestParam("terminalType") Integer terminalType);
	
	
	@GetMapping(value="/api/portal/pc/live")
	Long getLiveActivityPc(@RequestParam("siteId") Long siteId, @RequestParam("terminalType") Integer terminalType);
	
	
	@GetMapping(value="/api/portal/pc/link/down")
	List<ApiPortalPCLink> listApiPortalPCLinkDown(@RequestParam("siteId") Long siteId, @RequestParam("terminalType") Integer terminalType);
	

	@GetMapping(value="/api/portal/pc/announcement/select")
	List<AnnouncementVO> getApiRelationAnnouncement(@RequestParam("siteId") Long siteId, @RequestParam("terminalType") Integer terminalType);
	
	/**
	 * 模板list
	 * @param terminalId
	 * @return
	 */
	@GetMapping("/api/portal/pc/module/list/select")
	List<PortalTemplateVo> moduleListSelectApi(@RequestParam("siteId") Long siteId, @RequestParam("terminalType") Integer terminalType);
	
	
	/**
	 * 模板内容展示
	 * @param id
	 * @return
	 */
	@GetMapping("/api/portal/pc/template/content/view")
	List<ProtalPlateVo> templateContentView(@RequestParam(name = "id", required = true) Long id);
	
	
	
	/**
	 * 推荐新闻
	 * @param siteId
	 * @param ids
	 * @return
	 */
	@GetMapping("/api/portal/pc/news/supply/notIds")
	List<InformationVo> listSupplyInformation(@RequestParam("siteId")Long siteId, @RequestParam(name="ids",required=false)List<Long> ids);
	
	@GetMapping("/api/portal/pc/news/read/count")
	Integer newsReadCount(@RequestParam("id")Long id);

	/**
	 * 获取用模板的详情
	 * @param id
	 * @return
	 */
	@GetMapping("/api/portal/pc/get/template")
	PortalTemplateVo getPortalTemplate(@RequestParam(name = "id") Long id);
	
}
