package com.yizhi.site.application.vo.site;

import com.baomidou.mybatisplus.activerecord.Model;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * <p>
 * 国际化
 * </p>
 *
 * @author lingye
 * @since 2020-08-24
 */
@Data
public class InternationalVO extends Model<InternationalVO> {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "主键")
    private Long id;

    @ApiModelProperty(value = "keyId")
    private Long internationalKeyId;

    @ApiModelProperty(value = "key值")
    private String key;

    @ApiModelProperty(value = "中文字段")
    private String preTranslation;

    @ApiModelProperty(value = "翻译后")
    private String postTranslation;

    @ApiModelProperty(value = "备注")
    private String translateRemark;

    @ApiModelProperty(value = "0管理端 1 移动端 2 PC端")
    private Integer type;

    @ApiModelProperty(value = "语种id")
    private String languageId;

    @ApiModelProperty(value = "语种code")
    private String languageCode;

    @ApiModelProperty(value = "1:已翻译 0：未翻译 2:全部")
    private Integer state;

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

}
