package com.yizhi.site.application.vo.site;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@ApiModel(value = "ModuleAllVO", description = "门户显示各个模块信息")
@Data
public class ModuleAllVO {

    @ApiModelProperty(value = "id")
    private Long id;

    @ApiModelProperty(value = "模块名字")
    private String moduleName;

    @ApiModelProperty(value = "模块logo")
    private String moduleLogo;

    @ApiModelProperty(value = "模块类型")
    private String moduleType;

    @ApiModelProperty(value = "培训项目开始时间")
    private String startTime;

    @ApiModelProperty(value = "培训项目结束时间")
    private String endTime;

    @ApiModelProperty(value = "培训项目下的课程数量")
    private Integer activityNum;

    @ApiModelProperty(value = "如果是培训项目，培训项目下的所有课程的总时长，如果是单个课程，那就是课程的时长")
    private Long courseTotalTime;

    @ApiModelProperty(value = "课程评分")
    private BigDecimal grade;

    @ApiModelProperty(value = "课程学习人数")
    private Integer courseNum;

    @ApiModelProperty("新闻内容/讲师头衔")
    private String newsContent;

    @ApiModelProperty(value = "新闻时间")
    private String releaseTime;

    @ApiModelProperty("新闻阅读次数")
    private Integer newsReadCount;


    @ApiModelProperty("直播频道号")
    private String channel;

    @ApiModelProperty(value = "学时")
    private Float totalDuration;

    @ApiModelProperty("课程学时显示 true 显示，false不显示")
    private Boolean courseDurationShow;

    @ApiModelProperty("外链的url")
    private String siteUrl;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "创建人")
    private String createByName;

    @ApiModelProperty(value = "点赞数")
    private Integer likeNum;

    @ApiModelProperty(value = "学习数")
    private Integer studyNum;

    @ApiModelProperty(value = "说明 moduleType=专区 ,存放code")
    private String directions;

    @ApiModelProperty(value = "pc:1使用内容图片 2使用新图片")
    private Integer thumbnail;

    @ApiModelProperty(value = "课程：0:表示未完成，1表示已完成   1:上架 0：下架")
    private Integer status;

    @ApiModelProperty(value = "讲师库来源，内部 inner，外部 outer")
    private String source;

    @ApiModelProperty(value = "内容类型")
    private String type;
    
    @ApiModelProperty(value = "业务id")
    private Long bizId;

    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    @ApiModelProperty(value = "观看类型：0: 公开播放 ; 1: 站内授权播放; ")
    private Integer viewType;
    @ApiModelProperty("实际价格")
    private Integer actualPrice;
    @ApiModelProperty("原价格")
    private Integer originalPrice;

}
