package com.yizhi.site.application.controller;


import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.application.orm.util.QueryUtil;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.site.application.constant.SiteConstant;
import com.yizhi.site.application.domain.*;
import com.yizhi.site.application.internationlization.InternationalizationUtil;
import com.yizhi.site.application.mapper.PortalTerminalMapper;
import com.yizhi.site.application.service.*;
import com.yizhi.site.application.vo.domain.PortalTemplateVo;
import com.yizhi.site.application.vo.site.*;
import com.yizhi.site.application.vo.site.ReportParamVO.ReportVO;
import com.yizhi.statistics.application.entity.Report;
import com.yizhi.statistics.application.feign.ReportClient;
import com.yizhi.system.application.utils.ClassUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.text.SimpleDateFormat;
import java.util.*;


/**
 * <p>
 * 门户管理，前端控制器
 * </p>
 *
 * @author bob123
 * @since 2018-03-27
 */
@Api(tags = "管理端配置", description = "配置首页")
@RestController
@RequestMapping("/manage/portal")
public class PortalManageController {

    private static final Logger logger = LoggerFactory.getLogger(PortalManageController.class);

    @Autowired
    private PortalTerminalService portalTerminalService;

    @Autowired
    private HomeImageService homeImageService;

    @Autowired
    private PortalNavigateService portalNavigateService;

    @Autowired
    private HomeAnnouncementService homeAnnouncementService;

    @Autowired
    private PortalHomeService portalHomeService;

    @Autowired
    private PortalTemplateService portalTemplateService;

    @Autowired
    ProtalPlateService protalPlateService;
    @Autowired
    private IdGenerator idGenerator;
    @Autowired
    private PortalTerminalMapper portalTerminalMapper;
    
    @Autowired
    private IRelationReportService relationReportService;
    
    @Autowired
    private ReportClient reportClient;
    @Autowired
    private InternationalizationUtil internationalizationUtil;

    @GetMapping("/list")
    public List<TerminalListVO> listPortal(@RequestBody SiteComponyIdVO siteComponyIdVO) {
        return portalTerminalService.listPortal(siteComponyIdVO);
    }

    @PostMapping("/release/{terminalId}")
    public Long releasePortal(@PathVariable Long terminalId) {
        return portalTerminalService.releasePortal(terminalId);
    }

    @PostMapping("/unrelease/{terminalId}")
    public Long unreleasePortal(@PathVariable Long terminalId) {
        return portalTerminalService.unReleasePortal(terminalId);
    }

    @GetMapping("/login/view/{terminalId}")
    public PortalLogin loginPageView(@PathVariable Long terminalId) {
        return portalTerminalService.loginPageView(terminalId);
    }

    @PostMapping("/login/insertLogin")
    @ResponseBody
    public Long loginPageInsert(@RequestBody PortalLoginListVO vo) {
        return portalTerminalService.loginPageInsert(vo);
    }

    @PostMapping("/login/updatePortalLogin")
    public Long loginPageUpdate(@RequestBody PortalLogin pl) {
        return portalTerminalService.loginPageUpdate(pl);
    }

    @PostMapping("/login/releasePortalLogin")
    public Long loginPageRelease(@RequestBody PortalLogin pl) {
        return portalTerminalService.loginPageRelease(pl);
    }

    //首页
    @GetMapping("/home/preview/{terminalId}")
    public PortalPreviewVO previewPortal(@PathVariable Long terminalId) {
        return portalTerminalService.previewPortal(terminalId);
    }

    @PostMapping("/home/release")
    public Long homeRelease(@RequestBody IdOneVO vo) {
        return portalTerminalService.homeRelease(vo);
    }

    @PostMapping("/navigate/listNavigate")
    public HeadNavigateListVO listNavigate(@RequestBody PageParamVO vo) {
        return portalTerminalService.listNavigate(vo);
    }

    @PostMapping("/navigate/updateNavigateList")
    public Boolean updateNavigate(@RequestBody NavigateListVO vo) {
        return portalTerminalService.updateNavigate(vo);
    }


    @PostMapping("/navigate/deletePortalNavigate")
    public boolean deleteNavigate(@RequestBody NavigateListVO vo) {
        return portalTerminalService.deleteNavigate(vo);
    }

    @PostMapping("/navigate/list/insertNavigateInsertList")
    public boolean insertListNavigate(@RequestBody NavigateInsertListVO vo) {
        return portalTerminalService.insertListNavigate(vo);
    }

    @PostMapping("/banner/image/dragImage")
    public Boolean dragImage(@RequestBody IdTwoVO vo) {
        return portalTerminalService.dragImage(vo);
    }

    @PostMapping("/banner/image/listImage/{homeId}")
    public List<ImageListVO> listImage(@PathVariable Long homeId) {
        return portalTerminalService.listImage(homeId);
    }

    @PostMapping("/banner/deleteHomeImage")
    public boolean deleteBannerImage(@RequestBody HomeImageListVO vo) {
        return portalTerminalService.deleteBannerImage(vo);
    }

    @GetMapping("/banner/preview/{imageId}")
    public String previewImage(@PathVariable Long imageId) {
        return portalTerminalService.previewImage(imageId);
    }

    @PostMapping("/banner/selectBannerImage")
    public Page<ImageListVO> selectBannerImage(@RequestBody PageParamVO vo) {
        return portalTerminalService.selectBannerImage(vo);
    }

    @PostMapping("/banner/list/insertBannerImageList")
    public boolean insertBannerImageList(@RequestBody InsertListVO vo) {
        return portalTerminalService.insertBannerImageList(vo);
    }

    @PostMapping("/template/uploadBannerImage")
    public Long uploadBannerImage(@RequestBody UploadImageVO vo) {
        return portalTerminalService.uploadBannerImage(vo);
    }

    @PostMapping("/template/insertTemplateList")
    public TemplateAddVO insertTemplate(@RequestBody TemplateAddVO vo) {
        return portalTerminalService.insertTemplate(vo);
    }

    @PostMapping("/template/deletePortalTemplate")
    public boolean deleteTemplate(@RequestBody PortalTemplateVo pt) {
        PortalTemplate p=new PortalTemplate();
        BeanUtils.copyProperties(pt,p);
        return portalTerminalService.deleteTemplate(p);
    }

    @GetMapping("/template/view/{templateId}")
    public TemplateListVO viewTemplate(@PathVariable Long templateId) {
        return portalTerminalService.viewTemplate(templateId);
    }

    /**
     * 管理页面的课程的模板代码块
     *
     * @param vo
     * @return
     */
    @PostMapping("/template/updateTemplateList")
    public Long updateTemplate(@RequestBody TemplateUpdateVO vo) {
        return portalTerminalService.updateTemplate(vo);
    }

    @PostMapping("/template/course/ListTemplateCourse/{templateId}")
    public List<PopCourseListVO> ListTemplateCourse(@PathVariable Long templateId) {
        return portalTerminalService.ListTemplateCourse(templateId);
    }

    @PostMapping("/template/course/list/insertTemplateCourse")
    public boolean insertTemplateCourse(@RequestBody CourseAddVO listVo) {
        return portalTerminalService.insertTemplateCourse(listVo);
    }

    @PostMapping("/home/logo/insertHomeLogo")
    public Long insertHomeLogo(@RequestBody HomeLogoVO vo) {
        return portalTerminalService.insertHomeLogo(vo);
    }

    @PostMapping("/home/logo/updateHomeLogo")
    public Long updateHomeLogo(@RequestBody HomeLogoVO vo) {
        return portalTerminalService.updateHomeLogo(vo);
    }

    @GetMapping("/home/logo/viewHomeLogo/{homeId}")
    public HomeLogoVO viewHomeLogo(@PathVariable Long homeId) {
        return portalTerminalService.viewHomeLogo(homeId);
    }

    @PostMapping("/home/announcement/selectAnnouncement")
    public Page<AnnouncementVO> selectAnnouncement(@RequestBody PageParamVO vo) {
        return portalTerminalService.selectAnnouncement(vo);
    }

    @GetMapping("/home/announcement/previewAnnouncement/{imformationId}")
    public PreviewImformationVO previewAnnouncement(@PathVariable String imformationId) {
        return portalTerminalService.previewAnnouncement(imformationId);
    }

    @PostMapping("/home/announcement/listAnnouncement")
    public Page<AnnouncementVO> listAnnouncement(@RequestBody PageParamVO vo) {
        return portalTerminalService.listAnnouncement(vo);
    }

    @PostMapping("/home/announcement/deleteAnnouncement")
    public Boolean deleteAnnouncement(@RequestBody HomeInformationListVO vo) {
        return portalTerminalService.deleteAnnouncement(vo);
    }

    @PostMapping("/home/announcement/insertAnnouncementList")
    public Boolean insertAnnouncementList(@RequestBody InsertListVO vo) {
        return portalTerminalService.insertAnnouncementList(vo);
    }

    @GetMapping("/template/news/listSelectedNews/{templateId}")
    public List<TemplateNewsVO> listSelectedNews(@PathVariable Long templateId) {
        return portalTerminalService.listSelectedNews(templateId);
    }

    @GetMapping("/template/selected/previewNews/{id}")
    public PreviewNewsVO previewNews(@PathVariable Long id) {
        return portalTerminalService.previewNews(id);
    }

    @PostMapping("/template/insertTemplateNews")
    public boolean insertTemplateNews(@RequestBody NewsAddVO vo) {
        return portalTerminalService.insertTemplateNews(vo);
    }

    @PostMapping("/navigate/dragNavigate")
    public Boolean dragNavigate(@RequestBody IdTwoVO vo) {
        return portalTerminalService.dragNavigate(vo);
    }

    /**
     * 管理后台首页配置
     *
     * @param terminalId
     * @return
     * @date 2019-2-26
     */
    @ApiOperation(value = "轮播图、导航、我的列表")
    @GetMapping("/home/view")
    public PortalPreviewVO getPortalView(
            @RequestParam(name = "terminalId") Long terminalId
    ) {
        RequestContext requestContext = ContextHolder.get();
        PortalHome portalHome = new PortalHome();
        portalHome.setTerminalId(terminalId);
        Long homeId = portalHomeService.selectOne(QueryUtil.condition(portalHome)).getId();
        logger.info("homeId：" + homeId);
        PortalPreviewVO portalPreviewVO = new PortalPreviewVO();
        portalPreviewVO.setTerminalId(terminalId);
        portalPreviewVO.setHomeId(homeId);
        portalPreviewVO.setSiteId(requestContext.getSiteId());
        // 轮播图
        try {
            List<PreviewImageVO> rotationImages = homeImageService.getRotationImages(homeId);
            if (CollectionUtils.isNotEmpty(rotationImages)) {
                portalPreviewVO.setImageList(rotationImages);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        // 导航列表
        try {
            //获取全部的导航列表包括可以显示的 和不显示的
            List<NavigateListVO> navigateList = portalNavigateService.getNavigateList(homeId);
            if (CollectionUtils.isNotEmpty(navigateList)) {
                portalPreviewVO.setNavigateList(navigateList);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        // 公告
        try {
            List<AnnouncementVO> announcementList = homeAnnouncementService.getAnnouncementList(homeId);
            if (CollectionUtils.isNotEmpty(announcementList)) {
                portalPreviewVO.setAnnouncementList(announcementList);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        //我的任务
        PortalTemplate template = new PortalTemplate();
        template.setHomeId(homeId);
        template.setSiteId(requestContext.getSiteId());
        template.setModuleType(0);
        template = portalTemplateService.selectOne(new EntityWrapper<>(template));
        if (template != null) {
            TaskPortalVo vo = new TaskPortalVo();
            vo.setId(template.getId());
            vo.setDisplay(template.getDisplay() == 1 ? true : false);
            vo.setModuleName(template.getModuleName());
            portalPreviewVO.setTaskPortalVo(vo);
        }
        return portalPreviewVO;
    }

    /**
     * 获取模块的list
     *
     * @param terminalId
     * @return
     * @Date 2019-3-4 16:05:12
     */
    @ApiOperation(value = "模块列表")
    @GetMapping("/getManageModuleList")
    public List<PortalTemplate> getManageModuleList(@RequestParam(name = "terminalId") Long terminalId) {
        return portalTemplateService.getManageModuleList(terminalId);
    }

    /**
     * 首页模块的拖拽
     *
     * @param sourceId
     * @param targetId
     * @return
     */
    @ApiOperation(value = "首页模块配置移动")
    @PostMapping("/sortTemplate")
    public Boolean sortTemplate(
            @RequestParam(value = "sourceId", required = true) Long sourceId,
            @RequestParam(value = "targetId", required = false) Long targetId,
            @RequestParam(value = "type", required = false) Integer type
    ) {
        if (type != null) {
            return portalTemplateService.sortTemplate(sourceId, type);
        } else {
            return portalTemplateService.sortTemplate(sourceId, targetId);
        }
    }

    @GetMapping("/getTemplateById")
    public PortalTemplateVo getTemplateById(@RequestParam(name = "id") Long id) {
        PortalTemplate p = portalTemplateService.getTemplateById(id);
        PortalTemplateVo pv=new PortalTemplateVo();
        BeanUtils.copyProperties(p,pv);
        return pv;
    }


    @GetMapping("/transferTemplate")
    public Boolean transferTemplate(
            @RequestParam(name = "id") Long id,
            @RequestParam(name = "type") Integer type
    ) {
        return portalTemplateService.sortTemplate(id, type);
    }
    /**
     * 查询首页配置的模块的列表
     * @param terminalName 终端名称 PC 和移动端
     * @param moduleType 首页模块的类型
     * @return List
     * */
    @GetMapping("/homeConfigList")
    public List<Long> selectHomeConfigList(
            @RequestParam("terminalName") String terminalName,
            @RequestParam("moduleType") int moduleType
            ){
        return protalPlateService.selectHomeConfigList(terminalName.trim(),ContextHolder.get().getSiteId(),moduleType);
    }

    /**
     * 用于启用关闭今日任务
     * @param id
     * @param dispaly
     * @return
     */
    @GetMapping("/task/update")
    public Boolean taskPortalUpdate(@RequestParam("id") Long id,
                                    @RequestParam("dispaly") Integer dispaly) {
        PortalTemplate template = new PortalTemplate();
        template.setId(id);
        template.setDisplay(dispaly);
        return portalTemplateService.updateById(template);
    }
    /**
     * 用于微信端  是否展示今日任务模块
     * @return
     */
    @GetMapping("/task/get")
    public TaskPortalVo getTaskPortal() {
        RequestContext requestContext = ContextHolder.get();
        List<TerminalListVO> listPortal = portalTerminalMapper.listPortal(requestContext.getSiteId(), requestContext.getCompanyId());

        if (CollectionUtils.isNotEmpty(listPortal)) {
            for (TerminalListVO a : listPortal) {
                if (a.getType() == 3) {
                    PortalHome portalHome = new PortalHome();
                    portalHome.setTerminalId(a.getId());
                    Long homeId = portalHomeService.selectOne(QueryUtil.condition(portalHome)).getId();

                    PortalTemplate template = new PortalTemplate();
                    template.setHomeId(homeId);
                    template.setSiteId(requestContext.getSiteId());
                    template.setModuleType(SiteConstant.ZERO);

                    template = portalTemplateService.selectOne(new EntityWrapper<>(template));
                    if (template != null) {
                        TaskPortalVo vo = new TaskPortalVo();
                        vo.setId(template.getId());
                        vo.setModuleName(template.getModuleName());
                        vo.setDisplay(template.getDisplay() == 1 ? true : false);
                        Map<Long, String> map = new HashMap<>();
                        if (StringUtils.isNotBlank(requestContext.getLanguageType())) {
                            map = internationalizationUtil.getMap(ClassUtils.getTableName(PortalTemplate.class), Arrays.asList(template.getId()), requestContext.getLanguageType());
                            if (map != null) {
                                String word = "";
                                vo.setModuleName(word);
                            }
                        }
                        return vo;
                    }
                }
            }
        }
        return null;
    }
    
    @PostMapping("/report/save") 
    public Boolean reportUpdate(@RequestBody ReportParamVO paramVO) {
    	SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    	RequestContext context = ContextHolder.get();
    	Long accountId = context.getAccountId();
    	String accountName = context.getAccountName();
    	Long terminalId = paramVO.getTerminalId();
    	List<ReportVO> list = paramVO.getReportList();
    	Date date = new Date();
    	List<RelationReport> batch = new ArrayList<RelationReport>();
		Boolean isTrue=false;
		//保存当前配置
    	try {
			if (CollectionUtils.isNotEmpty(list)) {
				for(ReportVO vo:list) {
					Report one = reportClient.getById(vo.getReportId());
			    	RelationReport report = new RelationReport();
			    	report.setStartTime(one.getStartTime());
			    	report.setEndTime(one.getEndTime());
			    	report.setId(idGenerator.generate());
			    	report.setTerminalId(terminalId);
			    	report.setReportId(vo.getReportId());
			    	report.setReportName(vo.getReportName());
			    	report.setStartPush(vo.getStartPush());
			    	report.setEndPush(vo.getEndPush());
			    	report.setCreateById(accountId);
			    	report.setCreateByName(accountName);
			    	report.setCreateTime(date);
			    	batch.add(report);
				}
					isTrue = relationReportService.insertBatch(batch);
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
    	return isTrue;
    }
    
    @GetMapping("/report/update")
    public Boolean update(@RequestParam("id")Long id,@RequestParam("startPush")String startPush,@RequestParam("endPush")String endPush) {
    	SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    	RequestContext context = ContextHolder.get();
    	Long accountId = context.getAccountId();
    	String accountName = context.getAccountName();
    	Date date = new Date();
		Boolean isTrue=false;
		//保存当前配置
    	try {
    		RelationReport report = new RelationReport();
    		report.setId(id);
	    	report.setStartPush(new Date(Long.parseLong(startPush)));
	    	report.setEndPush(new Date(Long.parseLong(endPush)));
    		report.setUpdateById(accountId);
    		report.setUpdateByName(accountName);
    		report.setUpdateTime(date);
    		isTrue = relationReportService.updateById(report);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
    	return isTrue;
    }
    
    @GetMapping("/top")
    public Boolean top(@RequestParam("id") Long id) {
    	RequestContext context = ContextHolder.get();
		Boolean isTrue=false;
    	RelationReport report = relationReportService.selectById(id);
    	if (null!=report) {
			Integer isTop = report.getIsTop();
			report.setIsTop(isTop.equals(1)?0:1);
			report.setUpdateById(context.getAccountId());
			report.setUpdateByName(context.getAccountName());
			report.setUpdateTime(new Date());
			isTrue = relationReportService.updateById(report);
		}
    	return isTrue;
    }
    
    @GetMapping("/delete")
    public Boolean delete(@RequestParam("id") Long id) {
		Boolean isTrue=false;
    	RelationReport report = relationReportService.selectById(id);
    	if (null!=report) {
    		report.setState(0);
			isTrue = relationReportService.updateById(report);
		}
    	return isTrue;
    }
    
    @GetMapping("/report/list")
    public List<RelationReport> list(@RequestParam("terminalId") Long terminalId){
    	RelationReport report = new RelationReport();
    	report.setTerminalId(terminalId);
    	report.setState(1);
    	EntityWrapper<RelationReport> wrapper = new EntityWrapper<RelationReport>(report);
    	wrapper.orderBy("is_top", false).orderBy("update_time", false).orderBy("create_time", false);
    	List<RelationReport> list = relationReportService.selectList(wrapper);
    	return list;
    }

    /**
     * 获取站点导航列表
     * @param siteId
     * @param relationId
     * @return
     */
    @GetMapping("/getNavigateListByRelationId")
    public List<PortalNavigate> getNavigateListByRelationId(@RequestParam("siteId") Long siteId,
                                                            @RequestParam("relationId") Long relationId){
        return portalNavigateService.getNavigateListByRelationId(siteId,relationId);
    }
}

