package com.yizhi.site.application.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.site.application.constant.SiteConstant;
import com.yizhi.site.application.domain.Information;
import com.yizhi.site.application.domain.Publication;
import com.yizhi.site.application.service.InformationService;
import com.yizhi.site.application.service.PortalBannerService;
import com.yizhi.site.application.service.PublicationService;
import com.yizhi.site.application.vo.site.IdOneVO;
import com.yizhi.site.application.vo.site.ParamVO;
import com.yizhi.site.application.vo.site.PublicationParamReleaseVO;
import com.yizhi.site.application.vo.site.PublicationParamVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 投稿管理，前端控制器
 * </p>
 *
 * @author yanglang
 * @since 2024-12-17
 */
@Api(tags = "管理端-投稿管理", description = "投稿管理")
@RestController
@RequestMapping("/site/classify/publication")
public class PublicationManageController {

	@Autowired
	private InformationService informationService;

	@Autowired
	private PublicationService publicationService;

	@Autowired
    PortalBannerService portalBannerService;

    private static final Logger LOGGER = LoggerFactory.getLogger(PublicationManageController.class);

	@PostMapping("/list")
	public Page<Publication> list(@RequestBody PublicationParamVO vo) {
		return publicationService.publicationList(vo);
	}

	@ApiOperation(value = "查询发布的新闻列表")
	@PostMapping("/release/list")
	public Page<Publication> releaseList(@RequestBody PublicationParamReleaseVO vo) {
		return publicationService.publicationReleaseList(vo);
	}

	@PostMapping("/insert")
	public Long insert(@RequestBody Publication publication) {
		return publicationService.insertPublication(publication);
	}

	@PostMapping("/update")
	public Boolean update(@RequestBody Publication publication) {
        publication.setState(SiteConstant.THREE);
        publicationService.updateById(publication);
		Information information = new Information();
		BeanUtils.copyProperties(publication, information);
		informationService.updateById(information);
        return true;
	}

	@PostMapping("/delete")
	public boolean deleteById(@RequestBody IdOneVO vo) {
		return publicationService.deleteById(vo.getId());
	}

	@GetMapping("/releases")
	public boolean releases(@RequestParam(name = "id") Long id) {
		ParamVO vo = new ParamVO();
		vo.setIds(CollectionUtil.newArrayList(id));
		return publicationService.releases(vo);
	}

	@GetMapping("/unreleases")
	public boolean unreleases(@RequestParam(name = "id") Long id) {
		ParamVO vo = new ParamVO();
		vo.setIds(CollectionUtil.newArrayList(id));
		return publicationService.unreleases(vo);
	}

	@GetMapping("/view/{id}")
	public Publication publicationView(@RequestParam(name = "id") Long id) {
		return publicationService.publicationView(id);
	}

	@GetMapping("/approve/{id}")
	public boolean approve(@RequestParam(name = "id") Long id) {
		return publicationService.approve(id);
	}

	@GetMapping("/unApprove/{id}")
	public boolean unApprove(@RequestParam(name = "id") Long id) {
		return publicationService.unApprove(id);
	}
	
	@GetMapping(value = "/listbyName")
	public List<Publication> listbyName(@RequestParam(name = "name")String name, @RequestParam(name = "siteId")Long siteId){
		return publicationService.listbyName(name, siteId);
	}

    /**
     * 新闻资讯公告上架
     * @param id 新闻公告id
     * @return
     */
    @GetMapping(value = "/upPublication")
    public boolean upPublication(@RequestParam(value = "id") Long id) {
        return publicationService.releasePublication(id);
    }

    /**
     * 新闻资讯pdf转图片需要
     * @return
     */
    @PostMapping(value = "/updateContent")
    public boolean updateContent(@RequestBody Publication publication) {
        if (publication.getId() == null) {
            LOGGER.error("异常处理新闻pdf转图片，id为空！");
            return false;
        }
      return this.publicationService.updateById(publication);
    }
    
    /**
     * 滚动提示接口：投稿管理（4天内创建且待审核的数据）
     * @return
     */
    @GetMapping("/selectContributionManagementForScroll")
    public List<Publication> selectContributionManagementForScroll() {
        return publicationService.selectContributionManagementForScroll();
    }
}
