package com.yizhi.site.application.controller.api;


import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.site.application.domain.FunctionDisplayConfig;
import com.yizhi.site.application.domain.SiteDic;
import com.yizhi.site.application.domain.SiteLanguage;
import com.yizhi.site.application.service.IFunctionDisplayConfigService;
import com.yizhi.site.application.enums.FunctionDeviceTypeCode;
import com.yizhi.site.application.enums.FunctionTypeCode;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.site.application.service.ISiteDicService;
import com.yizhi.site.application.service.ISiteLanguageService;
import com.yizhi.core.application.task.TaskExecutor;
import com.yizhi.util.application.date.DateUtil;
import com.yizhi.site.application.vo.site.FunctionDisplayConfigVO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 * 显示配置---》功能项显示配置 前端控制器
 * </p>
 *
 * @author 谢海军123
 * @since 2019-04-29
 */
@RestController
@RequestMapping("/api/functionDisplayConfig")
public class FunctionDisplayConfigApiController {

    @Autowired
    private IFunctionDisplayConfigService displayConfigService;

    @Autowired
    private IdGenerator idGenerator;
    @Autowired
    private ISiteDicService siteDicService;

    @Autowired
    private ISiteLanguageService siteLanguageService;

    @Autowired
    private TaskExecutor taskExecutor;

    public static final String LANGUAGE ="language";

    private static List<String> keys;

    //固定语言，无法关闭
    private static List<String> STABLE_LANGUAGE = Arrays.asList("zh_CN","en_US");

    private static final Logger LOGGER = LoggerFactory.getLogger(FunctionDisplayConfigApiController.class);

    static {
        FunctionTypeCode[] types = FunctionTypeCode.values();
        keys = new ArrayList<>();
        for(FunctionTypeCode item : types){
            keys.add(item.getCode());
        }
    }

    @GetMapping("/siteId/all/get")
    public List<FunctionDisplayConfig> getConfigBySiteId(@RequestParam(value = "siteId") Long siteId){
        List<FunctionDisplayConfig> data = displayConfigService.findSiteConfig(siteId);
        if(CollectionUtils.isEmpty(data)){
            return null;
        }
        return data;
    }

    @GetMapping("/site/all/get")
    public List<FunctionDisplayConfig> getAllBySiteId(){
        RequestContext rt = ContextHolder.get();

        List<FunctionDisplayConfig> data = displayConfigService.findSiteConfig(rt.getSiteId());
        if(CollectionUtils.isEmpty(data)){
            data = initConfig(rt,null);
        }else {
            //并集
            //list1.addAll(list2);
            //交集
            //list1.retainAll(list2);
            //差集
            //list1.removeAll(list2);
            //无重复并集
            /*list2.removeAll(list1);
            list1.addAll(list2);*/
            List<String> extisTypes = data.stream().map(objectItem->objectItem.getFunctionType()).collect(Collectors.toList());
            List<String> cloneData = new ArrayList<>();
            //cloneData.addAll(keys);
            //cloneData.remove(extisTypes);
            LOGGER.info("数据库已经配置的类型 = {}", JSON.toJSONString(extisTypes));
            for(String ids : keys){
                if(!extisTypes.contains(ids)){
                    cloneData.add(ids);
                }
            }
            LOGGER.info("系统的keys = {},克隆数据={}", JSON.toJSONString(keys),JSON.toJSONString(cloneData));
            if(!CollectionUtils.isEmpty(cloneData)){
                List<FunctionDisplayConfig> dataNew = initConfig(rt,cloneData);
                data.addAll(dataNew);
            }
        }
        return data;
    }


    @GetMapping("/site/get")
    public List<FunctionDisplayConfig> getBySiteId(@RequestParam("siteId") Long siteId){
        List<FunctionDisplayConfig> data = displayConfigService.findSiteConfig(siteId);
        if(CollectionUtils.isEmpty(data)){
            return null;
        }
        return data;
    }

    @PostMapping("/update")
    public Integer update(@RequestBody List<FunctionDisplayConfigVO> vos){
        RequestContext rt = ContextHolder.get();
        Date upDatetime = new Date();
        List<FunctionDisplayConfig> addObj = new ArrayList<>();
        for(FunctionDisplayConfigVO item : vos){
            if(item.getId()==null){
                return 1;
            }
            FunctionDisplayConfig displayConfigOld = displayConfigService
                    .selectById(item.getId());
            if(displayConfigOld == null){
                return 2;
            }
            FunctionDisplayConfig displayConfig = new FunctionDisplayConfig();
            displayConfig.setId(item.getId());
            displayConfig.setShowDisplay(item.getShowDisplay());
            displayConfig.setUpdateById(rt.getAccountId());
            displayConfig.setUpdateByName(rt.getAccountName());
            displayConfig.setUpdateTime(upDatetime);
            Long upAccount = displayConfigOld.getUpdateById();
            if(Objects.nonNull(upAccount)){
                String log = upAccount+":"+
                        DateUtil.toSeconds(displayConfigOld.getUpdateTime())+
                        ":"+(displayConfigOld.getShowDisplay()?1:0);
                List<String> logs = new ArrayList<>();
                logs.add(log);
                String operateLog = displayConfigOld.getOperateLog();
                if(StringUtils.isNotBlank(operateLog)){
                    String[] splitArr = operateLog.split("#");
                    List<String> oldList = Arrays.asList(splitArr);
                    List<String> page = oldList.stream().limit(30).collect(Collectors.toList());
                    logs.addAll(page);
                }
                displayConfig.setOperateLog(logs.stream().collect(Collectors.joining("#")));
            }
            addObj.add(displayConfig);
        }
        if(!CollectionUtils.isEmpty(addObj)){
            for(FunctionDisplayConfig addItem : addObj){
                displayConfigService.updateById(addItem);
            }
        }
        return 0;
    }


    /**
     * 初始化配置
     * @param rt
     * @return
     */
    private List<FunctionDisplayConfig> initConfig(RequestContext rt,List<String> keys) {
        List<FunctionDisplayConfig> data = new ArrayList<>();
        Date insertTime = new Date();
        // 初始化该站点配置
        if(CollectionUtils.isEmpty(keys) || keys.contains(FunctionTypeCode.COURSE.getCode())){
            data.add(
                    addConfig(rt, FunctionTypeCode.COURSE.getName(),FunctionTypeCode.COURSE.getCode(),
                            FunctionDeviceTypeCode.PC_AND_TEL.getName(),FunctionDeviceTypeCode.PC_AND_TEL.getCode(),insertTime)
            );
        }

        if(CollectionUtils.isEmpty(keys) || keys.contains(FunctionTypeCode.TRAINING.getCode())) {
            data.add(
                    addConfig(rt, FunctionTypeCode.TRAINING.getName(),FunctionTypeCode.TRAINING.getCode(),
                            FunctionDeviceTypeCode.PC_AND_TEL.getName(),FunctionDeviceTypeCode.PC_AND_TEL.getCode(),insertTime)
            );
        }
        if(CollectionUtils.isEmpty(keys) || keys.contains(FunctionTypeCode.VIDEO_HORSE_LAMP.getCode())) {
            data.add(
                    addConfig(rt, FunctionTypeCode.VIDEO_HORSE_LAMP.getName(),FunctionTypeCode.VIDEO_HORSE_LAMP.getCode(),
                            FunctionDeviceTypeCode.PC_AND_TEL.getName(),FunctionDeviceTypeCode.PC_AND_TEL.getCode(),insertTime)
            );
        }
        if(CollectionUtils.isEmpty(keys) || keys.contains(FunctionTypeCode.SIGN.getCode())) {
            data.add(
                    addConfig(rt, FunctionTypeCode.SIGN.getName(),FunctionTypeCode.SIGN.getCode(),
                            FunctionDeviceTypeCode.PC.getName(),FunctionDeviceTypeCode.PC.getCode(),insertTime)
            );
        }
        if(CollectionUtils.isEmpty(keys) || keys.contains(FunctionTypeCode.LANGUAGE.getCode())) {
            data.add(
                    addConfig(rt, FunctionTypeCode.LANGUAGE.getName(),FunctionTypeCode.LANGUAGE.getCode(),
                            FunctionDeviceTypeCode.MG_WECHAT_PC.getName(),FunctionDeviceTypeCode.MG_WECHAT_PC.getCode(),insertTime)
            );

//            taskExecutor.asynExecute(new AbstractTaskHandler() {
//                @Override
//                public void handle() {
                    addSiteLanguageList(rt.getCompanyId(), rt.getSiteId());
//                }
//            });

        }

        if(CollectionUtils.isEmpty(keys) || keys.contains(FunctionTypeCode.LIVEREPLAY.getCode())) {
            data.add(
                    addConfig(rt, FunctionTypeCode.LIVEREPLAY.getName(),FunctionTypeCode.LIVEREPLAY.getCode(),
                            FunctionDeviceTypeCode.PC_AND_TEL.getName(),FunctionDeviceTypeCode.PC_AND_TEL.getCode(),insertTime)
            );
        }
        return data;
    }


    public boolean initLanguageConfig(RequestContext rt) {

        Date insertTime = new Date();
        addConfig(rt, FunctionTypeCode.LANGUAGE.getName(), FunctionTypeCode.LANGUAGE.getCode(),
                FunctionDeviceTypeCode.MG_WECHAT_PC.getName(), FunctionDeviceTypeCode.MG_WECHAT_PC.getCode(), insertTime);
        addSiteLanguageList(rt.getCompanyId(), rt.getSiteId());
        return true;
    }

    /**
     * 新增配置
     * @param rt
     * @param functionName
     * @param functionType
     * @param useDevice
     * @param pseDeviceType
     * @param insertTime
     * @return
     */
    private FunctionDisplayConfig addConfig(RequestContext rt,
                                             String functionName,String functionType,
                                             String useDevice ,String  pseDeviceType,
                                             Date insertTime) {
        FunctionDisplayConfig displayConfig = new FunctionDisplayConfig();
        displayConfig.setId(idGenerator.generate());
        displayConfig.setOrgId(rt.getOrgId());
        displayConfig.setSiteId(rt.getSiteId());
        displayConfig.setCompanyId(rt.getCompanyId());
        displayConfig.setCreateById(rt.getAccountId());
        displayConfig.setCreateByName(rt.getAccountName());
        displayConfig.setCreateTime(insertTime);
        displayConfig.setFunctionName(functionName);
        displayConfig.setFunctionType(functionType);
        displayConfig.setUseDevice(useDevice);
        displayConfig.setUseDeviceType(pseDeviceType);
        displayConfig.setShowDisplay(false);
        displayConfigService.insert(displayConfig);
        return displayConfig;
    }

    /**
     *  批量新增站点语言
     * @param companyId
     * @param siteId
     */
    @Transactional(rollbackFor = Exception.class)
    public void addSiteLanguageList(Long companyId, Long siteId) {
        if (siteId == 0L){
            LOGGER.info("siteId=0,数据异常！！！");
            return;
        }
        SiteLanguage tem = new SiteLanguage();
        tem.setSiteId(siteId);
        int result = siteLanguageService.selectCount(new EntityWrapper<>(tem));
        if (result > 0 ){
            LOGGER.info("已存在数据，无需新增！！！");
            return;
        }
        List<SiteDic> siteDics = siteDicService.getSiteDicListByCode(LANGUAGE);
        SiteLanguage siteLanguage = null;
        Date date = new Date();
        int i = 0;
        List<SiteLanguage> siteLanguages = new ArrayList<>();
        for (SiteDic dic : siteDics) {
            i++;
            siteLanguage = new SiteLanguage();
            Long id = idGenerator.generate();
            LOGGER.info("id:{}",id);
            siteLanguage.setId(id);
            siteLanguage.setLanguageId(dic.getId());
            siteLanguage.setCreateTime(date);
            siteLanguage.setUpdateTime(date);
            siteLanguage.setCompanyId(companyId);
            siteLanguage.setSiteId(siteId);
            //当语种状态更改，在另一入口更新状态
            siteLanguage.setDeleted("1".equals(dic.getStatus()) ? 0 : 1);
            siteLanguage.setStatus("1".equals(dic.getStatus()) ? 1 : 0);
            siteLanguage.setSort(i);
            siteLanguages.add(siteLanguage);
        }
        LOGGER.info("当前list：{}",JSON.toJSON(siteLanguages));

        boolean insertBatchFlag = siteLanguageService.insertBatch(siteLanguages);
        LOGGER.info("新开站点批量导入站点语言:{}",insertBatchFlag);
    }

}

