package com.yizhi.site.application.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 
 * </p>
 *
 * @author bob123
 * @since 2018-03-27
 */
@ApiModel(value = "HomeImageEntityVo", description = "终端关联轮播图片")
@Data
@TableName("tr_home_image")
public class HomeImage extends Model<HomeImage> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    private Long id;
    
    @ApiModelProperty(value = "首页ID")
    @TableField("home_id")
    private Long homeId;
    
    @ApiModelProperty(value = "站点ID")
    @TableField("site_id")
    private Long siteId;
    
    @ApiModelProperty(value = "轮播图片ID")
    @TableField("image_id")
    private Long imageId;
    
    @ApiModelProperty(value = "0删除 1: 未发布 2：发布")
    private Integer state;
    
    @ApiModelProperty(value = "创建时间")
    @TableField("create_time")
    private Date createTime;
    
    @ApiModelProperty(value = "创建人")
    @TableField("create_by_id")
    private Long createById;
    
    @ApiModelProperty(value = "创建人姓名")
    @TableField("create_by_name")
    private String createByName;
    
    @ApiModelProperty(value = "修改时间")
    @TableField("update_time")
    private Date updateTime;
    
    @ApiModelProperty(value = "修改人")
    @TableField("update_by_id")
    private Long updateById;
    
    @ApiModelProperty(value = "修改人姓名")
    @TableField("update_by_name")
    private String updateByName;

    @ApiModelProperty(value = "排序")
    @TableField("sort")
    private Integer sort;

    @Override
    protected Serializable pkVal() {
        return this.id;
    }
}
