package com.yizhi.site.application.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import com.yizhi.site.application.vo.domain.InformationClassify;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 
 * </p>
 *
 * @author bob123
 * @since 2018-03-27
 */
@ApiModel(value = "InformationEntityVo", description = "资讯")
@Data
@TableName("information")
public class Information extends Model<Information> {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "主鍵")
	private Long id;

	@ApiModelProperty(value = "封面logo")
	@TableField("logo_path")
	private String logoPath;

	@ApiModelProperty(value = "编号")
	private String number;

	@ApiModelProperty(value = "文章名称")
	@TableField("file_name")
	private String fileName;

	@ApiModelProperty(value = "文章父类型  1： 新闻   2: 公告")
	@TableField("type_one")
	private Long typeOne;

	@TableField(exist = false)
	private String typeOneName;

	@ApiModelProperty(value = "文章子类型（二级）")
	@TableField("type_two")
	private Long typeTwo;

	@TableField(exist = false)
	private String typeTwoName;

	@ApiModelProperty(value = "作者")
	private String author;

	@ApiModelProperty(value = "发布时间")
	@TableField("release_time")
	private Date releaseTime;

	@ApiModelProperty(value = "内容")
	private String content;

	@ApiModelProperty(value = "原文链接")
	@TableField("link_url")
	private String linkUrl;

	@ApiModelProperty(value = "自定义关键字")
	@TableField("key_words")
	private String keyWords;
	
	@ApiModelProperty(value = "置顶状态, 0: 未置顶 1:置顶")
	@TableField("is_top")
	private Long isTop;

	@ApiModelProperty(value = "状态 0 删除 1 未发布 2 发布")
	private Integer state;

	@ApiModelProperty(value = "站点ID")
	@TableField("site_id")
	private Long siteId;

	@ApiModelProperty(value = "创建时间")
	@TableField("create_time")
	private Date createTime;

	@ApiModelProperty(value = "创建人")
	@TableField("create_by_id")
	private Long createById;

	@ApiModelProperty(value = "创建人姓名")
	@TableField("create_by_name")
	private String createByName;

	@ApiModelProperty(value = "修改时间")
	@TableField("update_time")
	private Date updateTime;

	@ApiModelProperty(value = "修改人")
	@TableField("update_by_id")
	private Long updateById;

	@ApiModelProperty(value = "修改人姓名")
	@TableField("update_by_name")
	private String updateByName;

	@ApiModelProperty(value = "上传的pdfOss路径")
	@TableField("pdf_oss_url")
	private String pdfOssUrl;

	@ApiModelProperty(value = "上传的pdf文件名")
	@TableField("pdf_file_name")
	private String pdfFileName;

	@ApiModelProperty(value = "文章子类型（三级）")
	@TableField("type_three")
	private Long typeThree;
	
	@ApiModelProperty(value = "文章子类型（三级）名称")
	@TableField(exist = false)
	private String typeThreeName;
	
	@ApiModelProperty(value = "副标题")
	@TableField("title_sub")
	private String titleSub;
	
	@ApiModelProperty(value = "图片来源")
	@TableField("img_source")
	private String imgSource;
	
	@ApiModelProperty(value = "资讯分类")
	@TableField(exist = false)
	private List<InformationClassify> informationClassify;

	@ApiModelProperty(value = "阅读数量")
	@TableField(exist = false)
	private Integer readNum = 0;
	
	@ApiModelProperty(value = "阅读人数")
	@TableField(exist = false)
	private Integer readDistinctNum = 0;

	@ApiModelProperty(value = "点赞数量")
	@TableField(exist = false)
	private Integer admireNum = 0;

	@ApiModelProperty(value = "收藏数量")
	@TableField(exist = false)
	private Integer favoriteNum = 0;

	@ApiModelProperty(value = "转发数量")
	@TableField(exist = false)
	private Integer relayNum = 0;

	@ApiModelProperty(value = "信息来源")
	@TableField("source")
	private String source;

	@ApiModelProperty(value = "专题")
	@TableField("topic")
	private String topic;
	
	@Override
	protected Serializable pkVal() {
		return this.id;
	}
}