package com.yizhi.site.application.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 
 * </p>
 *
 * @author bob123
 * @since 2018-03-27
 */
@ApiModel(value = "PortalLoginEntityVo", description = "登录页")
@Data
@TableName("tr_portal_login")
public class PortalLogin extends Model<PortalLogin> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    private Long id;
    
    @ApiModelProperty(value = "终端ID")
    @TableField("terminal_id")
    private Long terminalId;

    @ApiModelProperty(value = "站点ID")
    @TableField("site_id")
    private Long siteId;

    @ApiModelProperty(value = "背景")
    @TableField("bgimg_path")
    private String bgimgPath;

    @ApiModelProperty(value = "0: 删除  1: 未发布  2: 发布")
    private Integer state;

    @ApiModelProperty(value = "创建时间")
    @TableField("create_time")
    private Date createTime;

    @ApiModelProperty(value = "创建人")
    @TableField("create_by_id")
    private Long createById;

    @ApiModelProperty(value = "创建姓名")
    @TableField("create_by_name")
    private String createByName;

    @ApiModelProperty(value = "更新时间")
    @TableField("update_time")
    private Date updateTime;

    @ApiModelProperty(value = "更新人")
    @TableField("update_by_id")
    private Long updateById;

    @ApiModelProperty(value = "更新姓名")
    @TableField("update_by_name")
    private String updateByName;

    @ApiModelProperty(value = "登录名说明文字")
    @TableField("loginName_desc")
    private String loginNameDesc;

    @ApiModelProperty(value = "登陆密码说明文字")
    @TableField("loginPwd_desc")
    private String loginPwdDesc;


    @Override
    protected Serializable pkVal() {
        return this.id;
    }
}
