package com.yizhi.site.application.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 资讯阅读次数统计
 * </p>
 *
 * @author lilingye
 * @since 2018-06-25
 */
@Data
@Api(tags = "TrInformationReadNumberEntityVo", description = "资讯阅读次数统计")
@TableName("tr_information_read_number")
public class TrInformationReadNumber extends Model<TrInformationReadNumber> {

    private static final long serialVersionUID = 1L;


@ApiModelProperty(value = "主键")
	private Long id;

@ApiModelProperty(value = "外键")
	@TableField("information_id")
	private Long informationId;

@ApiModelProperty(value = "冗余")
	@TableField("site_id")
	private Long siteId;

@ApiModelProperty(value = "阅读次数")
	private Integer number;

@ApiModelProperty(value = "创建时间")
	@TableField(value = "create_time", fill = FieldFill.INSERT)
	private Date createTime;

@ApiModelProperty(value = "创建人")
	@TableField(value = "create_by_id", fill = FieldFill.INSERT)
	private Long createById;

@ApiModelProperty(value = "创建人姓名")
	@TableField(value = "create_by_name", fill = FieldFill.INSERT)
	private String createByName;

@ApiModelProperty(value = "更新时间")
	@TableField(value = "update_time", fill = FieldFill.INSERT)
	private Date updateTime;

@ApiModelProperty(value = "更新人")
	@TableField(value = "update_by_id", fill = FieldFill.INSERT)
	private Long updateById;

@ApiModelProperty(value = "更新姓名")
	@TableField(value = "update_by_name", fill = FieldFill.INSERT)
	private String updateByName;


	@Override
	protected Serializable pkVal() {
		return this.id;
	}

}
