package com.yizhi.site.application.domain;

import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * <p>
 * 
 * </p>
 *
 * @author 谢海军
 * @since 2018-07-24
 */
@Data
@ApiModel(value = "TrPortalBlockEntityVo", description = "门户列表区块对象")
@TableName("tr_portal_block")
public class TrPortalBlock {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "唯一主键")
	private Long id;

    @ApiModelProperty(value = "终端ID")
	@TableField("terminal_id")
	private Long terminalId;

    @ApiModelProperty(value = "门户列表块的类型 1：底部菜单区块；2：菜单栏区块；3：公告栏区块")
	@TableField("block_type")
	private Integer blockType;

    @ApiModelProperty(value = "区块是否显示 1：显示；0：不显示")
	private Integer display;

	@TableField("bottom_menu")
	@ApiModelProperty(value = "底部菜单列表")
	private String bottomMenu;

    @ApiModelProperty(value = "创建人id")
	@TableField(value = "create_by_id", fill = FieldFill.INSERT)
	private Long createById;

    @ApiModelProperty(value = "创建人姓名")
	@TableField(value = "create_by_name", fill = FieldFill.INSERT)
	private String createByName;

    @ApiModelProperty(value = "创建时间")
	@TableField(value = "create_time", fill = FieldFill.INSERT)
	private Date createTime;

    @ApiModelProperty(value = "修改人id")
	@TableField(value = "update_by_id", fill = FieldFill.UPDATE)
	private Long updateById;

    @ApiModelProperty(value = "修改人姓名")
	@TableField(value = "update_by_name", fill = FieldFill.UPDATE)
	private String updateByName;

    @ApiModelProperty(value = "更新时间")
	@TableField(value = "update_time", fill = FieldFill.UPDATE)
	private Date updateTime;



}
