package com.yizhi.site.application.internationlization;

import com.baomidou.mybatisplus.toolkit.CollectionUtils;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;

import com.yizhi.site.application.domain.PortalTemplate;
import com.yizhi.site.application.domain.SiteDic;

import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.site.application.service.ISiteDicService;

import com.yizhi.core.application.task.AbstractTaskHandler;
import com.yizhi.core.application.task.TaskExecutor;
import com.yizhi.system.application.enums.ModuleType;
import com.yizhi.system.application.enums.TerminalType;
import com.yizhi.system.application.feign.InternationalizationClient;
import com.yizhi.system.application.feign.InternationalizationWordClient;
import com.yizhi.system.application.utils.ClassUtils;
import com.yizhi.system.application.vo.InternationalizationVo;
import com.yizhi.system.application.vo.domain.Internationalization;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 国际化
 */
@Component
public class InternationalizationUtil {

    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private InternationalizationClient internationalizationClient;
    @Autowired
    private IdGenerator idGenerator;
    @Autowired
    private InternationalizationWordClient internationalizationWordClient;
    @Autowired
    private ISiteDicService siteDicService;

    public static final String LANGUAGE ="language";

    /**
     * 添加需要国家化的字段
     *
     * @param a
     */
    public void addInternationalization(Internationalization a) {
        RequestContext context = ContextHolder.get();

        a.setId(idGenerator.generate());
        a.setSiteId(context.getSiteId());
        a.setOrgId(context.getOrgId());
        a.setCompanyId(context.getCompanyId());
        a.setCreateTime(new Date());
        a.setCreateById(context.getAccountId());
        a.setCreateByName(context.getAccountName());
        taskExecutor.asynExecute(new AbstractTaskHandler() {
            @Override
            public void handle() {
                internationalizationClient.add(a);
            }
        });
    }

    public void addInternationalizationList(PortalTemplate portalTemplate) {
        RequestContext context = ContextHolder.get();
        List<SiteDic> siteDics = siteDicService.getSiteDicListByCode(LANGUAGE);
        Internationalization a = null;
        for (SiteDic dic:siteDics) {
            a = new Internationalization();
            a.setName(portalTemplate.getModuleName());
            a.setModuleName(ModuleType.PORTAL.getName());
            a.setModuleType(ModuleType.PORTAL.getCode());
            a.setTableType(ClassUtils.getTableName(PortalTemplate.class));
            a.setTaskId(portalTemplate.getId());
            a.setTerminalType(TerminalType.PC.getCode());
            a.setId(idGenerator.generate());
            a.setSiteId(context.getSiteId());
            a.setOrgId(context.getOrgId());
            a.setCompanyId(context.getCompanyId());
            a.setCreateTime(new Date());
            a.setCreateById(context.getAccountId());
            a.setCreateByName(context.getAccountName());
            internationalizationClient.add(a);
        }
    }

    /**
     * 修改需要国家化的字段
     *
     * @param a
     */
    public void updateInternationalization(InternationalizationVo a) {
        taskExecutor.asynExecute(new AbstractTaskHandler() {
            @Override
            public void handle() {
                internationalizationClient.update(a);
            }
        });
    }

    /**
     * 删除国家化的字段
     *
     * @param a
     */
    public void deletedInternationalization(InternationalizationVo a) {
        taskExecutor.asynExecute(new AbstractTaskHandler() {
            @Override
            public void handle() {
                internationalizationClient.deleted(a);
            }
        });
    }

    /**
     *根据业务id  获取对应的国际化的值
     */
    public Map<Long, String> getMap(String tableType, List<Long> taskIds, String languageType) {
        if (CollectionUtils.isNotEmpty(taskIds)) {
            return internationalizationWordClient.getMap(tableType, taskIds,languageType);
        }
        return null;
    }
}
