package com.yizhi.site.application.mapper;

import com.yizhi.site.application.domain.DataClassification;
import com.yizhi.site.application.vo.domain.DataClassificationVo;
import com.yizhi.site.application.vo.site.ClassificationVO;
import com.baomidou.mybatisplus.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * Mapper 接口
 * </p>
 *
 * @author bob123
 * @since 2018-03-27
 */
public interface DataClassificationMapper extends BaseMapper<DataClassification> {

	List<ClassificationVO> selectSonClassification(@Param("siteId") Long siteId);

	Long selectMaxSort(@Param("parentId") Long parentId);

    /**
     * 获得所有新闻二级分类(没有内容的筛除)
     * @param siteId
     * @param typeOne
     * @return
     */
    List<DataClassification> getSubcategories(@Param("siteId") Long siteId, @Param("typeOne") Long typeOne);

    /**
     * 获取新闻的分类
     * @param siteId
     * @param parentId
     * @return
     */
    List<DataClassificationVo> selectClassification(@Param("siteId") Long siteId, @Param("parentId") Long parentId);


    /**
     * 获取分类列表的评论数量
     * @param classificationIds 分类ID列表
     * @param siteId 站点ID
     * @return 分类ID和评论数量的映射关系
     */
    List<Map<String, Object>> getCommentCountForClassifications(@Param("classificationIds") List<Long> classificationIds, @Param("siteId") Long siteId);
}