package com.yizhi.site.application.service;


import com.baomidou.mybatisplus.service.IService;
import com.yizhi.site.application.domain.InternationalKey;
import com.yizhi.site.application.vo.site.InternationalVO;

import java.util.Map;

/**
 * <p>
 * 语言国际化的key表  服务类
 * </p>
 *
 * @author taoge123
 * @since 2020-09-17
 */
public interface IInternationalKeyService extends IService<InternationalKey> {

    /**
     * 根据终端类型获取 keyMap
     * @param terminalType
     * @param key
     * @return <key,keyId>
     */
    public Map<String,Long> getKeyMap(Integer terminalType,String key);

    /**
     * 根据终端类型获取 keyMap
     * @param terminalType
     * @param key
     * @return <id,domain>
     */
    public Map<Long,InternationalKey> getKeyIdMap(Integer terminalType,String key);

    Integer update(InternationalVO internationalVO);

}
