package com.yizhi.site.application.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.yizhi.site.application.domain.HomeLogo;
import com.yizhi.site.application.mapper.HomeLogoMapper;
import com.yizhi.site.application.service.HomeLogoService;
import com.yizhi.site.application.constant.SiteConstant;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.site.application.service.PortalHomeService;
import com.yizhi.site.application.service.PortalTerminalService;
import com.yizhi.site.application.vo.site.HomeLogoVO;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author bob123
 * @since 2018-04-02
 */
@Service
public class HomeLogoServiceImpl extends ServiceImpl<HomeLogoMapper, HomeLogo> implements HomeLogoService {
	
	@Autowired
	private IdGenerator idGenerator;
	
	@Autowired
	private HomeLogoMapper homeLogoMapper;
	
	
	@Autowired
	private PortalTerminalService portalTerminalService;
	@Autowired
	private PortalHomeService portalHomeService;

	@Override
	public HomeLogoVO homeLogoList(Long homeId) {
		HomeLogoVO vo = new HomeLogoVO();
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("home_id", homeId);
		map.put("state", SiteConstant.FIRST);
		List<HomeLogo> selectByMap = this.selectByMap(map);
		if(selectByMap.size() > 0){
			HomeLogo hl = selectByMap.get(0);
			BeanUtils.copyProperties(hl, vo, "state", "createTime", "createById", "createByName", "updateTime", "updateById", "updateByName");
		}
		return vo;
	}

	@Override
	public boolean copyHomeLogo(Long sourceId, Long targetId) {
		List<HomeLogo> list = new ArrayList<HomeLogo>();
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("home_id", sourceId);
		map.put("state", SiteConstant.FIRST);
		List<HomeLogo> selectByMap = this.selectByMap(map);
		HomeLogo p = null;
		for(HomeLogo pn : selectByMap){
			p = new HomeLogo();
			BeanUtils.copyProperties(pn, p);
			p.setId(idGenerator.generate());
			p.setHomeId(targetId);
			list.add(p);
		}
		if(list.size() > 0){
			this.insertBatch(list);
		}
		return true;
	}

	
	
	
	/**
	 * -----------------------------------------------------分割线------------------------------------
	 */
	
	
	
	@Override
	public HomeLogoVO insertHomeLogoPc(Long terminalId,String logoPath) {
		// TODO Auto-generated method stub
		HomeLogoVO homeLogoVO=new HomeLogoVO();
		 //通过终端ID找到homeId
		Long homeId=portalHomeService.getHomeId(terminalId);
		Long id=idGenerator.generate();
	
		if(homeId!=null) {
			//一个homeId只能有一个logo  如果查到有logo 直接返回空对象
			List<HomeLogo> selectOneHomeLogo=selectOneHomeLogoByHomeId(homeId);
			if(!CollectionUtils.isEmpty(selectOneHomeLogo)) {
				return homeLogoVO;
			}
			
			else {
				HomeLogo homeLogo=new HomeLogo();
				homeLogo.setId(id);
				homeLogo.setHomeId(homeId);
				homeLogo.setLogoPath(logoPath);
				homeLogo.setState(1);
				homeLogo.setCreateById(ContextHolder.get().getAccountId());
				homeLogo.setCreateByName(ContextHolder.get().getAccountName());
				homeLogo.setCreateTime(new Date());
				homeLogoMapper.insert(homeLogo);
			}
			//返回对象
			homeLogoVO.setId(id);
			homeLogoVO.setLogoPath(logoPath);
			homeLogoVO.setHomeId(homeId);
		}
		return homeLogoVO;
	}
	
	
	@Override
	public HomeLogoVO updateHmeLogoPc(Long logoId,String newLogoPath) {
		// TODO Auto-generated method stub
		HomeLogo homeLogo=new HomeLogo();
	    homeLogo.setId(logoId);
		homeLogo.setLogoPath(newLogoPath);
		homeLogo.setUpdateById(ContextHolder.get().getAccountId());
		homeLogo.setUpdateByName(ContextHolder.get().getAccountName());
		homeLogo.setUpdateTime(new Date());
		//更新操作
		homeLogoMapper.updateById(homeLogo);
		//返回信息
		HomeLogoVO homeLogoVO=new HomeLogoVO();
		homeLogoVO.setId(logoId);
		homeLogoVO.setLogoPath(newLogoPath);
		return homeLogoVO;
	}
	
	

	@Override
	public HomeLogoVO viewHomeLogoPc(Long terminalId) {
		// TODO Auto-generated method stub
			Long homeId=portalHomeService.getHomeId(terminalId);
			if(homeId!=null) {
				HomeLogo homeLogoEntity=new HomeLogo();
				homeLogoEntity.setHomeId(homeId);
				homeLogoEntity.setState(1);
				HomeLogo homeLogo=homeLogoMapper.selectOne(homeLogoEntity);
				HomeLogoVO homeLogoVO=new HomeLogoVO();
				if(homeLogo!=null) {
					homeLogoVO.setId(homeLogo.getId());
					homeLogoVO.setHomeId(homeLogo.getHomeId());
					homeLogoVO.setLogoPath(homeLogo.getLogoPath());
				}
				return homeLogoVO;
			}
		return new HomeLogoVO();
	}

	@Override
	public List<HomeLogo> selectOneHomeLogoByHomeId(Long homeId) {
		// TODO Auto-generated method stub
		HomeLogo homeLogo=new HomeLogo();
		homeLogo.setHomeId(homeId);
		homeLogo.setState(1);//只查找上架的
		EntityWrapper<HomeLogo> wrapper=new EntityWrapper<HomeLogo>(homeLogo);
		return homeLogoMapper.selectList(wrapper);
	}

	@Override
	public Boolean deleteHomeLogoPc(Long logoId) {
		// TODO Auto-generated method stub
		HomeLogo homeLogo=new HomeLogo();
		homeLogo.setId(logoId);
		homeLogo.setState(2);
		homeLogo.setUpdateById(ContextHolder.get().getAccountId());
		homeLogo.setUpdateByName(ContextHolder.get().getAccountName());
		homeLogo.setUpdateTime(new Date());
		return homeLogoMapper.updateById(homeLogo)>0;
	}

	@Override
	public HomeLogo baseMeaagePCByTerminalId(Long siteId, Integer terminalType) {
		// TODO Auto-generated method stub
		return homeLogoMapper.baseMeaagePCByTerminalId(siteId, terminalType);
	}

	
}
