package com.yizhi.site.application.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.core.application.cache.RedisCache;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.enums.InternationalEnums;
import com.yizhi.core.application.exception.BizException;
import com.yizhi.site.application.constant.SiteConstant;
import com.yizhi.site.application.domain.DataClassification;
import com.yizhi.site.application.domain.Information;
import com.yizhi.site.application.domain.ProtalPlate;
import com.yizhi.site.application.domain.Publication;
import com.yizhi.site.application.mapper.*;
import com.yizhi.site.application.service.*;
import com.yizhi.site.application.vo.domain.InformationClassify;
import com.yizhi.site.application.vo.site.*;
import com.yizhi.util.application.constant.ReturnCode;
import com.yizhi.util.application.date.DateUtil;
import lombok.extern.log4j.Log4j2;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Service;

import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * com.yizhi.site.application.service.impl
 *
 * @author yanglang
 * @create 2024-12-17 14:38:56
 */
@Log4j2
@Service
public class PublicationServiceImpl extends ServiceImpl<PublicationMapper, Publication> implements PublicationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PublicationServiceImpl.class);
    private static final String jobGroup = "publication";

    @Autowired
    private IdGenerator idGenerator;
    @Autowired
    private DataClassificationService dataClassificationService;
    @Autowired
    private ProtalPlateService protalPlateService;

    @Autowired
    private InformationService informationService;

    @Autowired
    private InformationClassifyMapper informationClassifyMapper;
    @Autowired
    private RedisTemplate redisTemplate;

    @Override
    public List<Publication> selectPublication(Long typeTwo) {
        Publication publication = new Publication();
        publication.setTypeTwo(typeTwo);
        EntityWrapper<Publication> wrapper = new EntityWrapper<Publication>(publication);
        return this.selectList(wrapper);
    }

    @Override
    public Page<Publication> publicationList(PublicationParamVO vo) {
        // modify by lingye
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
        try {
            if (vo.getStart() != null) {
                Date startTime = sdf.parse(sdf.format(vo.getStart()));


                Date endTime = sdf.parse(sdf.format(vo.getEnd()));

                // 查询结束时间 加一天
                Calendar c = Calendar.getInstance();
                c.setTime(endTime);
                c.add(Calendar.DAY_OF_MONTH, 1);

                Date end = c.getTime();
                log.info("开始时间：" + startTime + "；结束时间：" + end);

                vo.setStart(sdf.parse(sdf.format(vo.getStart())));
                vo.setEnd(end);
            }
        } catch (ParseException e) {
            e.printStackTrace();
        }

        if(vo.getSiteId()==null) {
            vo.setSiteId(ContextHolder.get().getSiteId());
        }
        if(vo.getPageNo()==null){
            vo.setPageNo(1);
        }
        if(vo.getPageSize()==null){
            vo.setPageSize(10);
        }
        Page<Publication> page = new Page<Publication>(vo.getPageNo(), vo.getPageSize());
        List<Publication> list = null;
        if(vo.getTypeId()!=null) {
            DataClassification selectById = dataClassificationService.selectById(vo.getTypeId());
            if (selectById != null) {
                if (selectById.getParentId() == 0) {
                    vo.setLevel(1L);
                } else {
                    selectById = dataClassificationService.selectById(selectById.getParentId());
                    if (selectById.getParentId() == 0) {
                        vo.setLevel(2L);
                    } else {
                        vo.setLevel(3L);
                    }
                }
            }
        }
        list = this.baseMapper.publicationFirstList(vo, page);//新闻分类列表
        if (list.size() > 0 && list != null) {
            for (Publication info : list) {
                if(info.getTypeOne() != null && info.getTypeOne() == 0){
                    info.setTypeOneName("其他");
                }
                if (info.getTypeOne() != null && info.getTypeOne() != 0) {
                    info.setTypeOneName(findNameById(info.getTypeOne()));
                }
                if (info.getTypeTwo() != null && info.getTypeTwo() != 0) {
                    info.setTypeTwoName(findNameById(info.getTypeTwo()));
                }
                if (info.getTypeThree() != null && info.getTypeThree() != 0) {
                    info.setTypeThreeName(findNameById(info.getTypeThree()));
                }
            }
        }
        page.setRecords(list);
        return page;
    }

    @Override
    public Long insertPublication(Publication publication) {
        Long id = idGenerator.generate();
        publication.setId(id);
        publication.setNumber(getNumber());
        publication.setSubmitTime(new Date());
        publication.setState(SiteConstant.TWO);
        this.insert(publication);
        return id;
    }

    @Override
    public boolean releases(ParamVO vo) {
        List<Long> ids = vo.getIds();
        RequestContext res = ContextHolder.get();
        Long siteId = res.getSiteId();
        List<Publication> list = new ArrayList<Publication>();
        Publication selectById = null;
        for (Long id : ids) {
            selectById = this.selectById(id);
            selectById.setState(SiteConstant.FOUR);
            selectById.setReleaseTime(new Date());
            list.add(selectById);
            Information informationViewVO = informationService.informationView(id);
            if(informationViewVO==null||informationViewVO.getId()==null) {
                Information information = new Information();
                BeanUtils.copyProperties(selectById, information);
                if(ObjectUtil.isNotEmpty(selectById.getOssUrl())){
                    try {
                        JSONArray jsonArray = JSONArray.parseArray(selectById.getOssUrl());
                        if(jsonArray.size()>0){
                        	if(StringUtils.isEmpty(selectById.getLogoPath())){
                        		 information.setLogoPath(jsonArray.getString(0));
                        	}
                            information.setPdfOssUrl(selectById.getOssUrl());
                            String imgDiv = "<p></p><div class=\"media-wrap image-wrap\"><img id=\"%s\" title=\"%s\" alt=\"image\" src=\"%s\"/></div><p></p>\n";
                            String content = selectById.getContent();
                            if(content==null){
                                content ="";
                            }
                            for(int i = 0;i<jsonArray.size();i++){
                                content+=String.format(imgDiv,i,i,jsonArray.getString(i));
                            }
                            information.setContent(content);
                        }
                    }catch (Exception e){
                    }
                }
                informationService.insertInformation(information, id);
            }else{
                informationService.releases(new ParamVO(){{setIds(CollectionUtil.newArrayList(id));}});
            }
        }
        if (list.size() > 0) {
            this.updateBatchById(list);
        }
        return true;
    }

    @Override
    public boolean releasePublication(Long id) {
        Publication publication = this.selectById(id);
        publication.setState(SiteConstant.FOUR);
        // 新闻公告上架操作
        this.updateById(publication);
        return true;
    }

    @Override
    public boolean unreleases(ParamVO vo) {
        List<Long> ids = vo.getIds();
        List<Publication> list = new ArrayList<Publication>();
        Publication selectById = null;
        for (Long id : ids) {
            selectById = this.selectById(id);
            selectById.setState(SiteConstant.THREE);
            list.add(selectById);
        }
        if (list.size() > 0) {
            this.updateBatchById(list);
            informationService.unreleases(vo);
        }
        return true;
    }

    @Override
    public Page<PublicationStudentVO> publicationList(Long typeOne, Integer pageNo, Integer pageSize, Long siteId) {
        Page<PublicationStudentVO> page = new Page<PublicationStudentVO>(pageNo, pageSize);
        Integer state = 2;
        List<PublicationStudentVO> list = this.baseMapper.selectpublicationVO(typeOne, siteId, state, page);
        page.setRecords(list);
        return page;
    }

    @Override
    public Publication getPublication(Long id, Long siteId) {
        Publication publication = new Publication();
        publication.setSiteId(siteId);
        publication.setId(id);
        publication.setState(2);
        EntityWrapper<Publication> wrapper = new EntityWrapper<Publication>(publication);
        return this.selectOne(wrapper);
    }

    @Override
    public List<Publication> searchPublication(Page<Publication> page, Publication info) {
        if(info.getSiteId()==null) {
            info.setSiteId(ContextHolder.get().getSiteId());
        }
        return this.baseMapper.searchpublication(page, info);
    }

    @Override
    public List<Publication> listbyName(String name, Long siteId) {
        Publication info = new Publication();
        info.setFileName(name);
        info.setSiteId(siteId);
        info.setState(SiteConstant.FOUR);
        return this.baseMapper.searchpublication(info);
    }

    @Override
    public Publication publicationView(Long id) {
        Publication info = this.selectById(id);
        if (info == null) {
            return null;
        }
        if(info.getTypeOne() != null && info.getTypeOne() == 0){
            info.setTypeOneName("其他");
        }
        if (info.getTypeOne() != null && info.getTypeOne() != 0) {
            info.setTypeOneName(findNameById(info.getTypeOne()));
        }
        if (info.getTypeTwo() != null && info.getTypeTwo() != 0) {
            info.setTypeTwoName(findNameById(info.getTypeTwo()));
        }
        if (info.getTypeThree() != null && info.getTypeThree() != 0) {
            info.setTypeThreeName(findNameById(info.getTypeThree()));
        }

        //设置资讯分类
        InformationClassify classify = new InformationClassify();
        classify.setInformationId(id);
        EntityWrapper<InformationClassify> wrapper = new EntityWrapper<InformationClassify>(classify);
        List<InformationClassify> informationClassify = informationClassifyMapper.selectList(wrapper);
        info.setInformationClassify(informationClassify);

        return info;
    }


    @Override
    public boolean approve(Long id) {
        Publication publication = this.selectById(id);

        try {
            publication.setApproveTime(new Date());
            publication.setState(SiteConstant.THREE);
            publication.setApproveById(ContextHolder.get().getAccountId());
            return this.updateById(publication);
        } catch (Exception e) {
            log.error("审批通过失败,id=" + id + "错误消息={}", e);
        }

        return true;
    }

    @Override
    public boolean unApprove(Long id) {
        Publication publication = this.selectById(id);

        try {
            publication.setState(SiteConstant.FIVE);
            publication.setUpdateById(ContextHolder.get().getAccountId());
            return this.updateById(publication);
        } catch (Exception e) {
            log.error("审批不通过失败,id=" + id + "错误消息={}", e);
        }

        return true;
    }

    @Override
    public List<Publication> getRelationAnnouncementPC(Long terminalId) {
        return this.baseMapper.getRelationAnnouncementPC(terminalId);
    }

    @Override
    public Page<Publication> getPublicationByTypeOne(Long typeOne, Integer pageNo, Integer pageSize, Long siteId, List<Long> listIds) {
        LOGGER.info("参数："+listIds);
        Page<Publication> page = new Page<Publication>(pageNo, pageSize);
        Publication publication = new Publication();
        publication.setTypeOne(typeOne);
        publication.setState(2);
        publication.setSiteId(siteId);
        EntityWrapper<Publication> wrapper = new EntityWrapper<Publication>(publication);
        if (null!=listIds&&listIds.size()>0) {
            LOGGER.info("参数长度大于0");
            wrapper.notIn("id", listIds);
        }
        return this.selectPage(page, wrapper);
    }

    @Override
    public Page<Publication> getAllAnnouncementPC(Long terminalId, Integer pageNo, Integer pageSize) {
        // TODO Auto-generated method stub
        Long siteId = ContextHolder.get().getSiteId();
        DataClassification dataClassification = new DataClassification();
        dataClassification.setSiteId(siteId);
        dataClassification.setParentId(0L);
        dataClassification.setName("公告");
        dataClassification.setState(1);
        EntityWrapper<DataClassification> wrapper = new EntityWrapper<DataClassification>(dataClassification);
        //公告的一级信息  公告没有二级标题
        DataClassification dataClassification2 = dataClassificationService.selectOne(wrapper);
        //已经关联的公告具体信息
        List<Publication> listInformations = this.baseMapper.getRelationAnnouncementPC(terminalId);
        List<Long> listIds = null;
        if (CollectionUtils.isNotEmpty(listInformations)) {
            listIds = new ArrayList<Long>();
            for (int i = 0; i < listInformations.size(); i++) {
                listIds.add(listInformations.get(i).getId());
            }
        }

        if (dataClassification2 != null) {
            //一级分类ID
            Long id = dataClassification2.getId();
            return getPublicationByTypeOne(id, pageNo, pageSize, siteId, listIds);
        }
        return null;
    }

    @Override
    public Page<Publication> getAllNewsPC(Long terminalId, Integer pageNo, Integer pageSize) {
        // TODO Auto-generated method stub
        Long siteId = ContextHolder.get().getSiteId();
        DataClassification dataClassification = new DataClassification();
        dataClassification.setSiteId(siteId);
        dataClassification.setParentId(0L);
        dataClassification.setName("新闻");
        dataClassification.setState(1);
        EntityWrapper<DataClassification> wrapper = new EntityWrapper<DataClassification>(dataClassification);
        DataClassification dataClassification2 = dataClassificationService.selectOne(wrapper);
        if (dataClassification2 != null) {
            //一级分类ID
            Long id = dataClassification2.getId();
            //已经关联的新闻除外
//            Long templateId = informationMapper.informationRelationGetInformationIds(terminalId);
            List<Long> relationNnews = this.baseMapper.selectRelationIds(terminalId);
//            if (templateId != null) {
//                relationNnews = informationMapper.getRelationInformationIds(templateId);
//            }
            return getPublicationByTypeOne(id, pageNo, pageSize, siteId, relationNnews);
        }
        return null;
    }

    @Override
    public List<Publication> getRelationPublication(Long id) {
        // TODO Auto-generated method stub
        ProtalPlate plate = new ProtalPlate();
        plate.setTemplateId(id);
        plate.setState(1);//未删除
        EntityWrapper<ProtalPlate> wrapper = new EntityWrapper<ProtalPlate>(plate);
        List<ProtalPlate> listProtalPlate = protalPlateService.selectList(wrapper);
        List<Long> listInformationIds = null;
        if (CollectionUtils.isNotEmpty(listProtalPlate)) {
            listInformationIds = new ArrayList<Long>();
            for (int i = 0; i < listProtalPlate.size(); i++) {
                listInformationIds.add(listProtalPlate.get(i).getLinkContent());
            }
            if (CollectionUtils.isNotEmpty(listInformationIds)) {
                return this.selectBatchIds(listInformationIds);
            }
        }
        return null;
    }

    @Override
    public List<Publication> listSupplyPublication(Long siteId, List<Long> ids) {
        // TODO Auto-generated method stub
        DataClassification dataClassification = new DataClassification();
        dataClassification.setSiteId(siteId);
        dataClassification.setParentId(0L);
        dataClassification.setName("新闻");
        dataClassification.setState(1);
        EntityWrapper<DataClassification> wrapper = new EntityWrapper<DataClassification>(dataClassification);
        DataClassification dataClassification2 = dataClassificationService.selectOne(wrapper);
        if (dataClassification2 != null) {
            //一级分类ID
            Long id = dataClassification2.getId();

            Publication publication = new Publication();
            publication.setTypeOne(id);
            publication.setState(2);
            EntityWrapper<Publication> wrapperPublication = new EntityWrapper<Publication>(publication);
            wrapperPublication.notIn("id", ids);
            wrapperPublication.orderBy("release_time", false);
            wrapperPublication.orderBy("submit_time", false);
            return this.selectList(wrapperPublication);

        }
        return null;
    }

    @Override
    public Page<Publication> publicationReleaseList(PublicationParamReleaseVO vo) {

        //查找分类;获取分类下
        SiteComponyIdVO siteComponyIdVO = new SiteComponyIdVO();
        siteComponyIdVO.setCompanyId(vo.getCompanyId());
        siteComponyIdVO.setSiteId(vo.getSiteId());
        siteComponyIdVO.setCreateById(vo.getAccountId());
        siteComponyIdVO.setCreateByName(vo.getAccountName());
        siteComponyIdVO.setOrgId(vo.getOrgId());
        siteComponyIdVO.setSiteId(vo.getSiteId());
        List<ClassificationVO> classificationVOList = dataClassificationService.getClassification(siteComponyIdVO);
        Long typeOne = null;
        for (ClassificationVO classificationVO :
                classificationVOList) {
            if (SiteConstant.PORTALNEWS.equals(classificationVO.getName())) {
                typeOne = classificationVO.getId();

                log.info("typeOne值为:" + typeOne);
                break;
            }
        }
        vo.setTypeId(typeOne);
        //获取所有上架新闻列表
        PublicationParamVO publicationParamVO = new PublicationParamVO();
        BeanUtils.copyProperties(vo,publicationParamVO);
        publicationParamVO.setState(4);
        Page<Publication> page = new Page<Publication>(vo.getPageNo(), vo.getPageSize());

        if(vo.getTypeId()!=null) {
            DataClassification selectById = dataClassificationService.selectById(vo.getTypeId());
            if (selectById != null) {
                if (selectById.getParentId() == 0) {
                    publicationParamVO.setLevel(1L);
                } else {
                    selectById = dataClassificationService.selectById(selectById.getParentId());
                    if (selectById.getParentId() == 0) {
                        publicationParamVO.setLevel(2L);
                    } else {
                        publicationParamVO.setLevel(3L);
                    }
                }
            }
        }
        if(publicationParamVO.getSiteId()==null) {
            publicationParamVO.setSiteId(ContextHolder.get().getSiteId());
        }
        List<Publication> list = this.baseMapper.publicationFirstList(publicationParamVO, page);

        if (list.size() > 0 && list != null) {
            for (Publication info : list) {
                if(info.getTypeOne() != null && info.getTypeOne() == 0){
                    info.setTypeOneName("其他");
                }
                if (info.getTypeOne() != null && info.getTypeOne() != 0) {
                    info.setTypeOneName(findNameById(info.getTypeOne()));
                }
                if (info.getTypeTwo() != null && info.getTypeTwo() != 0) {
                    info.setTypeTwoName(findNameById(info.getTypeTwo()));
                }
                if (info.getTypeThree() != null && info.getTypeThree() != 0) {
                    info.setTypeThreeName(findNameById(info.getTypeThree()));
                }
            }
        }
        page.setRecords(list);
        return page;



    }


    private String findNameById(Long id) {
        DataClassification selectById = dataClassificationService.selectById(id);
        if (selectById != null) {
            return selectById.getName();
        }
        return null;
    }

    public String getNumber(){
        Long numVal = getIncrement("publication:number");
        NumberFormat formatter = NumberFormat.getNumberInstance();
        formatter.setMinimumIntegerDigits(4);
        formatter.setGroupingUsed(false);
        String idStr = formatter.format(numVal);
        return String.join(DateUtil.format(new Date(),"yyyy"), this.baseMapper.getNumberByCode("publication_number"), idStr);
    }

    /**
     * 获取自增数据
     *
     * @param key
     * @return
     */
    public Long getIncrement(String key) {
        ValueOperations<String, Long> valueOperations = redisTemplate.opsForValue();
        Long t = redisTemplate.getExpire(key);
        return ObjectUtil.isEmpty(t) ? valueOperations.increment(key) : valueOperations.increment(key,t);
    }
    
    @Override
    public List<Publication> selectContributionManagementForScroll() {
        RequestContext context = ContextHolder.get();
        
        List<Publication> list = this.baseMapper.selectContributionManagementForScroll(context.getSiteId());
        
        if (list.size() > 0 && list != null) {
            for (Publication info : list) {
                if(info.getTypeOne() != null && info.getTypeOne() == 0){
                    info.setTypeOneName("其他");
                }
                if (info.getTypeOne() != null && info.getTypeOne() != 0) {
                    info.setTypeOneName(findNameById(info.getTypeOne()));
                }
                if (info.getTypeTwo() != null && info.getTypeTwo() != 0) {
                    info.setTypeTwoName(findNameById(info.getTypeTwo()));
                }
                if (info.getTypeThree() != null && info.getTypeThree() != 0) {
                    info.setTypeThreeName(findNameById(info.getTypeThree()));
                }
            }
        }
        return list;
    }
}
