package com.yizhi.site.application.service.impl;

import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.site.application.domain.TrPortalPageBottom;
import com.yizhi.site.application.mapper.TrPortalPageBottomMapper;
import com.yizhi.site.application.service.ITrPortalPageBottomService;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;

import java.util.Date;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author wfd123
 * @since 2018-12-24
 */
@Service
public class TrPortalPageBottomServiceImpl extends ServiceImpl<TrPortalPageBottomMapper, TrPortalPageBottom> implements ITrPortalPageBottomService {

	
	@Autowired
	private TrPortalPageBottomMapper trPortalPageBottomMapper;
	
	@Override
	public Boolean pageBottomDelete(Long id) {
		// TODO Auto-generated method stub
		TrPortalPageBottom trPortalPageBottom=new TrPortalPageBottom();
		trPortalPageBottom.setId(id);
		trPortalPageBottom.setState(0);
		trPortalPageBottom.setUpdateById(ContextHolder.get().getAccountId());
		trPortalPageBottom.setUpdateByName(ContextHolder.get().getAccountName());
		trPortalPageBottom.setUpdateTime(new Date());
		return this.updateById(trPortalPageBottom);
	}

	@Override
	public Boolean pageBottomUpdateSort(Long id, Integer isDown) {
		// TODO Auto-generated method stub
		TrPortalPageBottom trPortalPageBottomCurr=this.selectById(id);
		Long pageId=trPortalPageBottomCurr.getPageId();
		Integer curSort=trPortalPageBottomCurr.getSort();
		
		Long nextId=trPortalPageBottomMapper.getNextIdByCurId(pageId, curSort, isDown);
		if(nextId!=null) {
			Date date=new Date();
			
			TrPortalPageBottom trPortalPageBottomNext=this.selectById(nextId);
			Integer nextSort=trPortalPageBottomNext.getSort();
			
			
			TrPortalPageBottom b1=new TrPortalPageBottom();
			b1.setId(id);
			b1.setSort(nextSort);
			b1.setUpdateById(ContextHolder.get().getAccountId());
			b1.setUpdateByName(ContextHolder.get().getAccountName());
			b1.setUpdateTime(date);
			this.updateById(b1);
			
			
			TrPortalPageBottom b2=new TrPortalPageBottom();
			b2.setId(nextId);
			b2.setSort(curSort);
			b2.setUpdateById(ContextHolder.get().getAccountId());
			b2.setUpdateByName(ContextHolder.get().getAccountName());
			b2.setUpdateTime(date);
			this.updateById(b1);
		}
		return true;
	}

}
