package com.yizhi.site.application.feign;

import com.yizhi.site.application.vo.site.PortalThemeColorEntityVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name = "portal", contextId = "PortalThemeColorClients")
public interface PortalThemeColorClients {

    /**
     * 查询站点和终端类型的颜色配置信息
     * @param companyId
     * @param siteId
     * @param terminalType
     * @return
     */
    @GetMapping("/theme/color/get")
    PortalThemeColorEntityVo getThemeColorBySiteId(@RequestParam(value = "companyId") Long companyId,
                                                   @RequestParam(value = "siteId") Long siteId,
                                                   @RequestParam(value = "terminalType") Integer terminalType);

    /**
     * 根据主键重置
     * @param id
     * @return
     */
    @GetMapping("/theme/color/reset")
    Boolean reset(@RequestParam(value = "id") Long id,
                  @RequestParam(value = "accountId") Long accountId);


    /**
     * 保存主题颜色配置
     * @param portalThemeColor
     * @return
     */
    @PostMapping("/theme/color/save")
    PortalThemeColorEntityVo save(@RequestBody PortalThemeColorEntityVo portalThemeColor);
}
