package com.yizhi.site.application.feign.api;

import com.yizhi.site.application.vo.site.PortalBlockVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @Author: XieHaijun
 * @Description:
 * @Date: Created in 9:27 2018/7/25
 * @Modified By
 */
@FeignClient(name = "portal", contextId = "PortalBlockFeignClients")
public interface PortalBlockFeignClients {

    /**
     * 首页区块显示设置变更
     * @param portalBlockVO
     * @return
     */
    @RequestMapping(value = "/portalBlock/status/change",method = RequestMethod.POST)
    public PortalBlockVO displayChange(@RequestBody PortalBlockVO portalBlockVO);

    /**
     * 根据终端id和区块id查询区块显示状态
     * @param terminalId
     * @param blockType
     * @param optionId
     * @param optionName
     * @return
     */
    @RequestMapping(value = "/portalBlock/terminalId/get",method = RequestMethod.GET)
    public PortalBlockVO getByTerminalId(@RequestParam(value = "terminalId") Long terminalId,
                                         @RequestParam(value = "blockType") Integer blockType,
                                         @RequestParam("optionId") Long optionId,
                                         @RequestParam("optionName") String optionName);
}
