package com.yizhi.site.application.vo.domain;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 门户系统字典
 * </p>
 *
 * @author lly
 * @since 2019-4-29
 */
@Data
@ApiModel(value = "SiteDicEntityVo", description = "门户系统字典")
public class SiteDicVo {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "记录id")
	private Long id;

    @ApiModelProperty(value = "父节点id")
	private Long parentId;

    @ApiModelProperty(value = "字典名称")
	private String name;

    @ApiModelProperty(value = "字典代码")
	private String code;

    @ApiModelProperty(value = "描述")
	private String des;

    @ApiModelProperty(value = "启用状态 1 启用 2失效")
	private String status;

    @ApiModelProperty(value = "图片")
	private String imgUrl;

    @ApiModelProperty(value = "字典类型")
	private String type;

    @ApiModelProperty(value = "添加时间")
	private Date createTime;

    @ApiModelProperty(value = "修改时间")
	private Date updateTime;
    
    @ApiModelProperty(value = "排序")
	private Integer sort;


    protected Serializable pkVal() {
        return null;
    }
}
