package com.yizhi.site.application.vo.site;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
@ApiModel(value="PublicationParamReleaseVO", description="查看投稿参数VO")
public class PublicationParamReleaseVO extends ContextVO {
	
	@ApiModelProperty(value="标题")
	private String fileName;
	
	@ApiModelProperty(value="当前页")
	private Integer pageNo;
	
	@ApiModelProperty(value="每页的个数")
	private Integer pageSize;
	
	@ApiModelProperty(value="类型")
	private Long typeId;
	
	@ApiModelProperty(value="发布时间的起点")
	private Date start;
	
	@ApiModelProperty(value="发布时间的终点")
	private Date end;
	
	private Long siteId;

	@ApiModelProperty(value = "状态 0 删除 1 草稿 2 待审核 3 待发布 4 已发布 5 不通过")
	private Integer state;

	private Long companyId;
	private String companyCode;
	private String companyName;
	private String siteCode;
	private String siteName;
	private Integer siteType;
	private Long siteMember;
	private Long orgId;
	private String orgName;
	private Long accountId;
	private String accountName;
	private String accountFullName;
	private String headPortrait;
	private String requestId;
	private boolean admin;
	private List<Long> orgIds;
	private String authCode;
	private List<Long> relationIds;
	private List<Long> managerIds;
}
